<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Class Auth
 * @property Ion_auth|Ion_auth_model $ion_auth        The ION Auth spark
 * @property CI_Form_validation      $form_validation The form validation library
 */
class Auth extends MY_Controller
{
  private $empresa_dominio;
  private $portada;

  public function __construct()
  {
    parent::__construct();
    $this->load->database();
    $this->load->library(['ion_auth', 'form_validation']);
    $this->load->helper(['url', 'language']);
    $this->load->helper('randpass_helper');


    $this->load->library('lib_email');
    $this->load->library('remates_hooks');
    $this->load->library('auth_hooks');
    $this->load->library('ion_auth');

    $this->load->model('v2pantallas_inicio_model');
    $this->load->model('v2empresa_model');
    $this->load->model('v2dominios_model');
    $this->load->model('v2opciones_model');
    $this->load->model('v2usuarios_model');
    $this->load->model('v2permisos_model');



    $this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));

    $dominio_root_default = $this->v2dominios_model->get($this->config->item('default_dominio_root_id'));
    if ($_SERVER['HTTP_HOST'] == ($this->config->item('default_dominio') . '.' . $dominio_root_default->dominio)) {
        $this->portada = $this->config->item('default_portada');
    } else {
      $this->empresa_dominio = $this->v2empresa_model->get_x_dominio($_SERVER['HTTP_HOST']);
      if (!$this->empresa_dominio) {
        redirect('http' . "://" . $this->config->item('default_dominio') . '.' . $dominio_root_default->dominio . '/');
      } else {
        $this->portada    = $this->config->item('path_imagenes_empresa') . $this->empresa_dominio->foto_portada;
      }
    }
    $this->data['empresa_nombre'] = $this->empresa_dominio->nombre;

    $this->lang->load('auth');
    $this->data['message'] = $this->session->flashdata('message');
  }

  /**
   * Redirect if needed, otherwise display the user list
   */
  public function index()
  {
    if (!$this->my_ion_auth->logged_in()) {
      redirect('auth/login', 'refresh');
    } else {
      redirect('/', 'refresh');
    }
  }

  /**
   * Log the user in
   */
  public function login()
    {
        if (!$this->my_ion_auth->logged_in()) {
            /* Load */
            $this->load->config('admin/dp_config');
            $this->load->config('common/dp_config');

            /* Valid form */
            $this->form_validation->set_rules('identity', 'Identity', 'required|strtolower');
            $this->form_validation->set_rules('password', 'Password', 'required');

            /* Data */
            $this->data['title']               = $this->config->item('title');
            $this->data['title_lg']            = $this->config->item('title_lg');
            $this->data['auth_social_network'] = $this->config->item('auth_social_network');
            $this->data['forgot_password']     = $this->config->item('forgot_password');
            /* Esteban: 12/02/17 | 11:21:55  Acá es donde hay que ver si tiene conexión con CGym */
            $this->data['new_membership'] = $this->config->item('new_membership');
            $es_superadmin = false;

            if ($this->form_validation->run() == true) {
                $remember = (bool) $this->input->post('remember');

                if ($usuario = $this->v2usuarios_model->get(array('LOWER(email)' => strtolower($this->input->post('identity')))) ) { /* Esteban: 02/03/17 | 17:14:21  Existe en ION_AUTH? */
                  $empresas = $this->v2usuarios_empresas_model->get_all(array('user_id' => $usuario->id));
                  $existe_en_la_empresa = false;
                  if (is_array($empresas) && count($empresas) > 0) {
                    foreach($empresas as $empresa) {
                      /* Esteban: 24/04/18 | 20:40:06  Superadmin */
                      if(intval($empresa->perfil_id) === 1000) {
                        $existe_en_la_empresa = true;
                        $perfil_id = 1000;
                        $es_superadmin = true;
                      }
                      if ($this->empresa_dominio->idempresas == $empresa->empresa_id) {
                        $existe_en_la_empresa = true;
                        $perfil_id = $empresa->perfil_id;
                        $this->session->set_userdata("empresa_id", $empresa->empresa_id);
                      }
                    }
                  }

                  if (!$existe_en_la_empresa) {
                    $this->session->set_flashdata('message', 'Tu usario está registrado en Remates, pero no está registrado en ' . $this->empresa_dominio->nombre . '. Por favor, verificá los datos y registrate.');
                    $this->session->set_flashdata('tipo_alerta', 'alert-warning');
                    $this->session->set_flashdata('icono', 'fa-exclamation');
                    
                    $this->session->set_flashdata('nombre', $usuario->first_name);
                    $this->session->set_flashdata('apellido', $usuario->last_name);
                    $this->session->set_flashdata('email', $this->input->post('identity'));
                    redirect ('auth/registro', 'refresh');
                  } else {
                    $identifier = $this->ion_auth_model->identity_column; // use model identity column, so it can be overridden in a controller
                    $user_ion = $this->ion_auth_model->where($identifier, $this->input->post('identity'))->where('active', 1)->users()->row();
                    if($user_ion) {
                      /* Esteban: 02/03/17 | 18:08:48  Lo dejo vacío para que quede claro que por acá sale si todo anduvo ok. */
                    } else {
                      $this->session->set_flashdata('message', 'No estás registrado en Remates. Por favor, hacé click en "Registrarme" para registrarte.');
                      $this->session->set_flashdata('tipo_alerta', 'alert-danger');
                      $this->session->set_flashdata('icono', 'fa-exclamation');
                      redirect('auth/login', 'refresh');
                    }
                  }
                } else {
                $this->session->set_flashdata('message', 'No estás registrado en Remates. Por favor, hacé click en "Registrarme" para registrarte.');
                  $this->session->set_flashdata('tipo_alerta', 'alert-danger');
                  $this->session->set_flashdata('icono', 'fa-exclamation');
                  redirect('auth/login', 'refresh');
                }

                if (!$this->my_ion_auth->errors() ) {
                  
                  /* Esteban: 13/02/17 | 15:30:47  Hook para la Ion Auth. */
                  $event  = 'post_set_session';
                  $name   = 'set_session_extra';
                  $class  = $this->auth_hooks;
                  $method = 'set_session_extra';
                  $args   = array();
                  $this->my_ion_auth->set_hook($event, $name, $class, $method, $args);

                  if ($this->my_ion_auth->login($this->input->post('identity'), $this->input->post('password'), $remember)) {

                    if ($es_superadmin) {
                      // $this->session->set_userdata('empresa_id', -1);              
                      if(isset($_SESSION['empresa_id'])) {
                        $this->v2usuarios_model->cargar_permisos($_SESSION['user_id'], $_SESSION['empresa_id']);
                      } else { /* Esteban: 25/04/18 | 11:40:41  Caso del superadmin */
                        $this->v2usuarios_model->cargar_permisos($_SESSION['user_id']);
                      }
                    } else {
                      $this->session->set_userdata('empresa_id', $this->empresa_dominio->idempresas);
                      if (!$this->v2usuarios_model->cargar_permisos($_SESSION['user_id'], $_SESSION['empresa_id'])) {
                          $this->my_ion_auth->logout();
                          redirect('auth/login', 'refresh');
                      }
                    }


                    /* Esteban: 17/02/17 | 13:54:03  Además, is_admin va a depender ahora de la empresa, también. */
                    /* Esteban: 21/04/18 | 17:18:43  Eso está solucionado con la subclase My_ion_auth, en cuyo is_admin se chequea que lo sea para la empresa actual */
                    if ($_SESSION['cache_permisos'] == "SUPERADMIN") {
                      redirect('dashboard', 'refresh');
                    } else {
                      $perfil = $this->v2perfiles_model->with_pantalla_inicio()->get($perfil_id);
                      redirect($perfil->pantalla_inicio->url, 'refresh');
                    }
                  } else {
                    $this->session->set_flashdata('message', $this->my_ion_auth->errors());
                    redirect('auth/login', 'refresh');
                  }
                } else {
                  $this->session->set_flashdata('message', $this->my_ion_auth->errors());
                  redirect('auth/login', 'refresh');
                }
            } else {
              $this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');

              $this->data['identity'] = array(
                  'name'        => 'identity',
                  'id'          => 'identity',
                  'type'        => 'email',
                  'value'       => $this->form_validation->set_value('identity'),
                  'class'       => 'form-control',
                  'placeholder' => 'Email',
              );
              $this->data['password'] = array(
                  'name'        => 'password',
                  'id'          => 'password',
                  'type'        => 'password',
                  'class'       => 'form-control',
                  'placeholder' => 'Contraseña',
              );

              /* Load Template */
              $this->data['portada']            = $this->portada;
              $this->data['title'] = 'Ingreso';
              $this->template->auth_render('login', $this->data);
          }
        } else {
          /* Esteban: 17/02/17 | 13:54:03  Además, is_admin va a depender ahora de la empresa, también. */
          /* Esteban: 21/04/18 | 17:18:43  Eso está solucionado con la subclase My_ion_auth, en cuyo is_admin se chequea que lo sea para la empresa actual */
          if ($_SESSION['cache_permisos'] == "SUPERADMIN") {
            redirect('dashboard', 'refresh');
          } else {
            $usuario_empresa = $this->v2usuarios_empresas_model->get(array('user_id' => $_SESSION['user_id'], 'empresa_id' => $_SESSION['empresa_id']));
            $perfil = $this->v2perfiles_model->with_pantalla_inicio()->get($usuario_empresa->perfil_id);
            redirect($perfil->pantalla_inicio->url, 'refresh');
          }
        }
      }


  /**
   * Log the user out
   */
  public function logout()
  {
    $this->data['title'] = "Logout";

    // log the user out
    $logout = $this->ion_auth->logout();

    // redirect them to the login page
    $this->session->set_flashdata('message', $this->ion_auth->messages());
    redirect('auth/login', 'refresh');
  }

  /**
   * Change password
   */
  public function change_password()
  {
    $this->form_validation->set_rules('old', $this->lang->line('change_password_validation_old_password_label'), 'required');
    $this->form_validation->set_rules('new', $this->lang->line('change_password_validation_new_password_label'), 'required|matches[new_confirm]');
    $this->form_validation->set_rules('new_confirm', $this->lang->line('change_password_validation_new_password_confirm_label'), 'required');

    if (!$this->ion_auth->logged_in())
    {
      redirect('auth/login', 'refresh');
    }

    $user = $this->ion_auth->user()->row();

    if ($this->form_validation->run() === FALSE)
    {
      // display the form
      // set the flash data error message if there is one
      $this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');

    
      $this->data['old_password'] = array(
        'name' => 'old',
        'id' => 'old',
        'type' => 'password',
      );
      $this->data['new_password'] = array(
        'name' => 'new',
        'id' => 'new',
        'type' => 'password',
      );
      $this->data['new_password_confirm'] = array(
        'name' => 'new_confirm',
        'id' => 'new_confirm',
        'type' => 'password',
      );
      $this->data['user_id'] = array(
        'name' => 'user_id',
        'id' => 'user_id',
        'type' => 'hidden',
        'value' => $user->id,
      );

      // render
      $this->_render_page('auth' . DIRECTORY_SEPARATOR . 'change_password', $this->data);
    }
    else
    {
      $identity = $this->session->userdata('identity');

      $change = $this->ion_auth->change_password($identity, $this->input->post('old'), $this->input->post('new'));

      if ($change)
      {
        //if the password was successfully changed
        $this->session->set_flashdata('message', $this->ion_auth->messages());
        $this->logout();
      }
      else
      {
        $this->session->set_flashdata('message', $this->ion_auth->errors());
        redirect('auth/change_password', 'refresh');
      }
    }
  }

  /**
   * Forgot password
   */
  public function forgot_password()
  {
    $this->form_validation->set_rules('email', 'Email Address', 'trim|required|strtolower');
    if ($this->form_validation->run() === true) {
      if ($usuario = $this->v2usuarios_model->get(array('LOWER(email)' => strtolower(trim($this->input->post('email'))))) ) { /* Esteban: 02/03/17 | 17:14:21  Existe en ION_AUTH? */
        //run the forgotten password method to email an activation code to the user
        $forgotten = $this->my_ion_auth->forgotten_password(trim($this->input->post('email')));
      } else {
        $this->session->set_flashdata('message', 'No estás registrado en remateXremate. Por favor, hacé click en "Registrarme" para registrarte.');
        $this->session->set_flashdata('tipo_alerta', 'alert-danger');
        $this->session->set_flashdata('icono', 'fa-exclamation');
        redirect('auth/login', 'refresh');
      }

    if ($forgotten) {

      $data_email = array('nombre_usuario' => $usuario->first_name,
        'link'                               => base_url('/auth/reset_password/' . $forgotten['forgotten_password_code']),
      );
  
      $nombre_remitente = "remateXremate!";
      $html = $this->load->view('email/forgot_password', null, true);

            $html = $this->lib_email->armar_mail($html, $data_email);

            $this->lib_email->enviar_mail(
                $nombre_remitente, // Nombre remitente
                $this->config->item('direccion_altas'), // direccion remitente
                $usuario->email, // email destinatario
                "remateXremate! - Modificar contraseña", // Asunto
                $html
            );


            $this->data['message'] = 'Genial! Ahora, en tu casilla de correo, vas a encontrar el mail con las instrucciones para cambiar tu contraseña!<br /><strong>Si no te llegó dentro de 30 minutos, revisá la carpeta de CORREO NO DESEADO (a veces se llama spam, o junk) y dale permiso para que te lleguen los mails de remateXremate!</strong>';
            $this->data['tipo_alerta'] = 'alert-success';
            $this->data['icono'] = 'fa-check';
            $this->data['title'] = 'Mensaje!';
    $this->template->auth_render('mensajes', $this->data);
        } else {
            $this->session->set_flashdata('message', $this->my_ion_auth->errors());
            redirect("auth/forgot_password", 'refresh');
        }
    } else {
        //setup the input
        $this->data['email'] = array(
            'name'        => 'email',
            'id'          => 'email',
            'value'       => set_value('email'),
            'class'       => 'form-control',
            'placeholder' => 'Email',
        );

        //set any errors and display the form
        $this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');
        $this->data['title'] = 'Restablecer Constraseña';
        $this->template->auth_render('forgot_password_form', $this->data);
    }
  }

  /**
   * Reset password - final step for forgotten password
   *
   * @param string|null $code The reset code
   */
  public function reset_password($code = NULL)
  {
        if (!$code) {
            show_404();
        }
        if ( $user = $this->my_ion_auth->forgotten_password_check($code) ) { /* Esteban: 02/03/17 | 17:14:21  Existe en ION_AUTH? */
          /* Esteban: 04/03/17 | 19:40:56  El código existe en ion_auth */
          $auth = 'ion_auth';
        } elseif ( $user = $this->v2usuarios_tank_model->forgotten_password_check($code) ) { /* Esteban: 02/03/17 | 17:14:21  Existe en TANK_AUTH? */
          /* Esteban: 04/03/17 | 19:40:56  El código existe en tank_auth */
          $auth = 'tank_auth';
        } else { /* Esteban: 04/03/17 | 19:40:31  El código no existe en ninguna de las dos tablas */
      $user = NULL;
          $auth = NULL;
        }


        if ($user) {
            // if the code is valid then display the password reset form
            $this->form_validation->set_rules('new_password', 'Nueva contraseña', 'required|matches[new_password_confirm]');
            $this->form_validation->set_rules('new_password_confirm', 'Confirmar constraseña', 'required');
            if ($this->form_validation->run() == false) {
                // display the form
                // set the flash data error message if there is one
                $this->data['message']             = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');
                $this->data['new_password']        = array(
                    'name'    => 'new_password',
                    'id'      => 'new_password',
                    'type'    => 'password',
                    'class'   => 'form-control'
                );
                $this->data['new_password_confirm'] = array(
                    'name'    => 'new_password_confirm',
                    'id'      => 'new_password_confirm',
                    'type'    => 'password',
                    'class'   => 'form-control',
                );
                $this->data['user_id'] = array(
                    'name'  => 'user_id',
                    'id'    => 'user_id',
                    'type'  => 'hidden',
                    'value' => $user->id,
                );
                // $this->data['csrf'] = $this->_get_csrf_nonce();
                $this->data['code'] = $code;
                // render
              $this->data['title'] = 'Nueva Contraseña';
                $this->template->auth_render('reset_password', $this->data);
            } else {
                // do we have a valid request?
                if ($user->id != $this->input->post('user_id')) {
                    // something fishy might be up
                    if ($auth == 'ion_auth') {
                      $this->my_ion_auth->clear_forgotten_password_code($code);
                    }
                    show_error($this->lang->line('error_csrf'));
                } else {
                    // finally change the password
                    $email = $user->email;
                    if ($auth == 'ion_auth') {
                      $change   = $this->my_ion_auth->reset_password($email, $this->input->post('new_password'));
                    } elseif ($auth == 'tank_auth') {
                      $change = $this->v2usuarios_tank_model->reset_password($email, $code,  $this->input->post('new_password'));
                    } else {
                      $change = null;
                    }


                    if ($change) {
                        // if the password was successfully changed
                        $this->session->set_flashdata('message', $this->my_ion_auth->messages());
                        redirect("auth/login", 'refresh');
                    } else {
                        $this->session->set_flashdata('message', $this->my_ion_auth->errors());
                        redirect('auth/reset_password/' . $code, 'refresh');
                    }
                }
            }
        } else {
            // if the code is invalid then send them back to the forgot password page
            $this->session->set_flashdata('message', $this->my_ion_auth->errors());
            redirect("auth/forgot_password", 'refresh');
        }
  }

  /**
   * Activate the user
   *
   * @param int         $id   The user ID
   * @param string|bool $code The activation code
   */
  public function activate($id, $code = FALSE)
  {

    if ($code !== FALSE)
    {
      $activation = $this->ion_auth->activate($id, $code);
    }
    else if ($this->ion_auth->is_admin())
    {
      $activation = $this->ion_auth->activate($id);
    }

    if ($activation)
    {
      // redirect them to the auth page
      $this->session->set_flashdata('message', $this->ion_auth->messages());
      redirect("auth", 'refresh');
    }
    else
    {
      // redirect them to the forgot password page
      $this->session->set_flashdata('message', $this->ion_auth->errors());
      redirect("auth/forgot_password", 'refresh');
    }
  }

  /**
   * Deactivate the user
   *
   * @param int|string|null $id The user ID
   */
  public function deactivate($id = NULL)
  {
    if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin())
    {
      // redirect them to the home page because they must be an administrator to view this
      return show_error('You must be an administrator to view this page.');
    }

    $id = (int)$id;

    $this->load->library('form_validation');
    $this->form_validation->set_rules('confirm', $this->lang->line('deactivate_validation_confirm_label'), 'required');
    $this->form_validation->set_rules('id', $this->lang->line('deactivate_validation_user_id_label'), 'required|alpha_numeric');

    if ($this->form_validation->run() === FALSE)
    {
      // insert csrf check
      $this->data['csrf'] = $this->_get_csrf_nonce();
      $this->data['user'] = $this->ion_auth->user($id)->row();

      $this->_render_page('auth' . DIRECTORY_SEPARATOR . 'deactivate_user', $this->data);
    }
    else
    {
      // do we really want to deactivate?
      if ($this->input->post('confirm') == 'yes')
      {
        // do we have a valid request?
        if ($this->_valid_csrf_nonce() === FALSE || $id != $this->input->post('id'))
        {
          return show_error($this->lang->line('error_csrf'));
        }

        // do we have the right userlevel?
        if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin())
        {
          $this->ion_auth->deactivate($id);
        }
      }

      // redirect them back to the auth page
      redirect('auth', 'refresh');
    }
  }

  /**
   * Create a new user
   */
  public function registro()
  {
    $this->data['title'] = $this->lang->line('create_user_heading');

    $tables = $this->config->item('tables', 'ion_auth');

    // validate form input
    $this->form_validation->set_rules('first_name', $this->lang->line('create_user_validation_fname_label'), 'trim|required');
    $this->form_validation->set_rules('last_name', $this->lang->line('create_user_validation_lname_label'), 'trim|required');
    $this->form_validation->set_rules('email', $this->lang->line('create_user_validation_email_label'), 'trim|required|valid_email');
    $this->form_validation->set_rules('phone', $this->lang->line('create_user_validation_phone_label'), 'trim');

    if ($this->form_validation->run() === TRUE)
    {
      $email = strtolower($this->input->post('email'));

      $additional_data = array(
        'first_name' => $this->input->post('first_name'),
        'last_name' => $this->input->post('last_name'),
        'phone' => $this->input->post('phone'),
        'foto_documento' => $this->input->post('archivo_dni'),
      );

      if ($usuario = $this->v2usuarios_model->with_empresas()->get(array('LOWER(email)' => $email))) {
        /* Esteban: 26/02/17 | 12:46:36  Existe en la tabla ion_auth? */

        $empresas_usuario_arr = array();
        if (isset($usuario->empresas)) {
          foreach ($usuario->empresas as $empresas_usuario) {
            $empresas_usuario_arr[] = $empresas_usuario->idempresas;
          }
        }
        
        if (in_array($this->empresa_dominio->idempresas, $empresas_usuario_arr)) {
          /* Esteban: 26/02/17 | 12:47:01  Existe en la empresa que está accediendo? */
          $this->ion_auth_model->set_error('account_creation_duplicate_identity');
        } else {
          $this->session->set_flashdata('user_id', $usuario->id);
          $this->session->set_flashdata('auth', 'ion_auth');
          $this->firebug->log('$usuario->id ---> ' . var_export($usuario->id, true));
          redirect('auth/validar_password', 'refresh');
        }
      } else {
        /* Esteban: 26/02/17 | 12:47:35  No existe. Lo registro como nuevo */

        /* REGISTRO  */
        $password = get_random_password(6, 8, false, true, false);
        $this->firebug->log('$additional_data ---> ' . var_export($additional_data, true));
        if ($this->form_validation->run() === TRUE && ($user_id = $this->my_ion_auth->register($email, $password, $email, $additional_data))) {

          /* Esteban: 21/02/17 | 15:54:55  Manda el mail de bienvenida a remateXremate. */

          $nombre_remitente = "remateXremate!";

          $html = $this->load->view('/email/bienvenido_remates', null, true);

          $link               = site_url();
          $link_arr           = parse_url($link);
          $link_arr['scheme'] = "http://";
          $link = $link_arr['scheme'] . trim($link_arr['host'] ? $link_arr['host'] : array_shift(explode('/', $link_arr['path'], 2))); // Listo. Lo más pelado posible.

          $campos_email = array('NOMBRE_USUARIO' => $this->input->post('first_name'),
              'EMPRESA'                              => $this->empresa_dominio->nombre,
              'USERNAME'                             => $email,
              'PASSWORD'                             => $password,
              'LINK'                                 => $link);
          $html = $this->lib_email->armar_mail($html, $campos_email);
          $this->lib_email->enviar_mail(
              $nombre_remitente, // Nombre remitente
              $this->config->item('direccion_altas'), // direccion remitente
              $this->input->post('email'), // email destinatario
              "Bienvenido a remateXremate!", // Asunto
              $html
          );

          if (!$this->_add_user_to_empresa($user_id, $this->empresa_dominio->idempresas)) {
            $this->ion_auth_model->set_error('account_creation_unsuccessful');
            redirect("auth", 'refresh');
          } else {
            $this->data['message'] = 'Genial! Ahora, en tu casilla de correo, vas a encontrar el mail con el password para poder ingresar a remateXremate! Si no te llegó dentro de 30 minutos, revisá la <strong>carpeta de spam</strong> y dale permiso para que te lleguen los mails de remateXremate!';
            $this->data['tipo_alerta'] = 'alert-success';
            $this->data['icono'] = 'fa-check';
            $this->data['title'] = 'Mensaje!';
            $this->template->auth_render('mensajes', $this->data);
          }
        } else {
          $this->ion_auth_model->set_error('account_creation_unsuccessful');
          $this->session->set_flashdata('message', $this->my_ion_auth->messages());
          redirect("auth", 'refresh');
        }
      }
      // check to see if we are creating the user
      // redirect them back to the admin page
    }
    else
    {
      // display the create user form
      // set the flash data error message if there is one
      $this->data['message'] = (validation_errors() ? validation_errors() : ($this->my_ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

      $this->data['first_name'] = array(
        'name' => 'first_name',
        'id' => 'first_name',
        'type' => 'text',
        'value' => $this->form_validation->set_value('first_name'),
      );
      $this->data['last_name'] = array(
        'name' => 'last_name',
        'id' => 'last_name',
        'type' => 'text',
        'value' => $this->form_validation->set_value('last_name'),
      );
      $this->data['email'] = array(
        'name' => 'email',
        'id' => 'email',
        'type' => 'text',
        'value' => $this->form_validation->set_value('email'),
      );
      $this->data['phone'] = array(
        'name' => 'phone',
        'id' => 'phone',
        'type' => 'text',
        'value' => $this->form_validation->set_value('phone'),
      );
      $this->data['portada']            = $this->portada;
      $this->data['foto_documento']     = $this->config->item('default_documento');
      $this->data['title'] = 'Registrate!';
      $this->template->auth_render('registro', $this->data);
    }
  }
  /**
  * Redirect a user checking if is admin
  */
  public function redirectUser(){
    if ($this->ion_auth->is_admin()){
      redirect('auth', 'refresh');
    }
    redirect('/', 'refresh');
  }

    public function validar_password()
    {
        $this->form_validation->set_rules('password', 'Password', 'required');

        if ($this->session->flashdata('user_id')) {
            $user_id = $this->session->flashdata('user_id');
        } elseif ($this->input->post('user_id')) {
            $user_id = $this->input->post('user_id');
        } else {
            redirect('/auth', 'refresh');
        }

        if ($this->session->flashdata('auth')) {
            $auth = $this->session->flashdata('auth');
        } elseif ($this->input->post('auth')) {
            $auth = $this->input->post('auth');
        } else {
            redirect('/auth', 'refresh');
        }

        if ($auth == 'ion_auth'){
          $usuario = $this->v2usuarios_model->get($user_id);
          $usuario->nombre = $usuario->first_name; /* Esteban: 02/03/17 | 17:54:07  Le adapto los datos porque antes el nombre y el apellido, en la tabla vieja, estaban en una tabla aparte (que era user_profiles). Ahora están en la misma. */
          $usuario->apellido = $usuario->last_name; /* Esteban: 02/03/17 | 17:54:07  Le adapto los datos porque antes el nombre y el apellido, en la tabla vieja, estaban en una tabla aparte (que era user_profiles). Ahora están en la misma. */
        } else {
            redirect('auth/registro', 'refresh');
        }

        if ($this->form_validation->run() == true) {
            $password = strtolower($this->input->post('password'));

            if ($auth == 'ion_auth'){
                /* Esteban: 01/03/17 | 10:09:48 Dice la ion_auth_model:296 -> * This function takes a password and validates it against an entry in the users table. */
                if (!$this->ion_auth_model->hash_password_db($this->input->post('user_id'), $this->input->post('password'))) {
                    /* Esteban: 28/02/17 | 14:28:56  Password erróneo */
                        $this->ion_auth_model->set_error('login_unsuccessful');
                }
            } else {
                redirect('auth/registro', 'refresh');
            }

            if (!$this->my_ion_auth->errors()) {
                /* Esteban: 28/02/17 | 17:25:15  Si todo salió bien hasta aquí, lo anoto en la empresa y grabo los meta datos */
                $user_id = $this->input->post('user_id');
                $this->_add_user_to_empresa($user_id, $this->empresa_dominio->idempresas);


                $this->session->set_flashdata('message', 'Ahora ya podés ingresar en ' . $this->empresa_dominio->nombre . ' Te mandamos un mail a tu casilla con las instrucciones para continuar!');
                $this->session->set_flashdata('tipo_alerta', 'alert-success');
                $this->session->set_flashdata('icono', 'fa-check');
                $this->data['title'] = 'Mensaje!';
                $this->template->auth_render("mensajes", $this->data);
            }

        }

        if ($this->form_validation->run() === false || $this->my_ion_auth->errors()) {

            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->my_ion_auth->errors() ? $this->my_ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['usuario_nombre'] = $usuario->apellido . ', ' . $usuario->nombre;
            $this->data['empresa_nombre'] = $this->empresa_dominio->nombre;

            $this->data['email'] = array(
                'name'  => 'email',
                'id'    => 'email',
                'type'  => 'hidden',
                'value' => $usuario->email,
            );

            $this->data['user_id'] = array(
                'name'  => 'user_id',
                'id'    => 'user_id',
                'type'  => 'hidden',
                'value' => $user_id,
            );

            $this->data['auth'] = array(
                'name'  => 'auth',
                'id'    => 'auth',
                'type'  => 'hidden',
                'value' => $auth,
            );

            $this->data['password'] = array(
                'name'        => 'password',
                'id'          => 'password',
                'type'        => 'password',
                'class'       => 'form-control',
                'placeholder' => 'Contraseña',
            );

            $this->data['title'] = 'Verificar Password';
            $this->template->auth_render('validar_password', $this->data);
        }
    }

  /**
   * Edit a user
   *
   * @param int|string $id
   */
  public function edit_user($id)
  {
    $this->data['title'] = $this->lang->line('edit_user_heading');

    if (!$this->ion_auth->logged_in() || (!$this->ion_auth->is_admin() && !($this->ion_auth->user()->row()->id == $id)))
    {
      redirect('auth', 'refresh');
    }

    $user = $this->ion_auth->user($id)->row();
    $groups = $this->ion_auth->groups()->result_array();
    $currentGroups = $this->ion_auth->get_users_groups($id)->result();

    // validate form input
    $this->form_validation->set_rules('first_name', $this->lang->line('edit_user_validation_fname_label'), 'trim|required');
    $this->form_validation->set_rules('last_name', $this->lang->line('edit_user_validation_lname_label'), 'trim|required');
    $this->form_validation->set_rules('phone', $this->lang->line('edit_user_validation_phone_label'), 'trim|required');
    $this->form_validation->set_rules('company', $this->lang->line('edit_user_validation_company_label'), 'trim|required');

    if (isset($_POST) && !empty($_POST))
    {
      // do we have a valid request?
      if ($this->_valid_csrf_nonce() === FALSE || $id != $this->input->post('id'))
      {
        show_error($this->lang->line('error_csrf'));
      }

      // update the password if it was posted
      if ($this->input->post('password'))
      {
        $this->form_validation->set_rules('password', $this->lang->line('edit_user_validation_password_label'), 'required|matches[password_confirm]');
        $this->form_validation->set_rules('password_confirm', $this->lang->line('edit_user_validation_password_confirm_label'), 'required');
      }

      if ($this->form_validation->run() === TRUE)
      {
        $data = array(
          'first_name' => $this->input->post('first_name'),
          'last_name' => $this->input->post('last_name'),
          'company' => $this->input->post('company'),
          'phone' => $this->input->post('phone'),
        );

        // update the password if it was posted
        if ($this->input->post('password'))
        {
          $data['password'] = $this->input->post('password');
        }

        // Only allow updating groups if user is admin
        if ($this->ion_auth->is_admin())
        {
          // Update the groups user belongs to
          
          $groupData = $this->input->post('groups');
          if (isset($groupData) && !empty($groupData))
          {
            $this->ion_auth->remove_from_group('', $id);
            foreach ($groupData as $grp)
            {
              $this->ion_auth->add_to_group($grp, $id);
            }

          }
        }

        // check to see if we are updating the user
        if ($this->ion_auth->update($user->id, $data))
        {
          // redirect them back to the admin page if admin, or to the base url if non admin
          $this->session->set_flashdata('message', $this->ion_auth->messages());
          $this->redirectUser();

        }
        else
        {
          // redirect them back to the admin page if admin, or to the base url if non admin
          $this->session->set_flashdata('message', $this->ion_auth->errors());
          $this->redirectUser();

        }

      }
    }

    // display the edit user form
    $this->data['csrf'] = $this->_get_csrf_nonce();

    // set the flash data error message if there is one
    $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

    // pass the user to the view
    $this->data['user'] = $user;
    $this->data['groups'] = $groups;
    $this->data['currentGroups'] = $currentGroups;

    $this->data['first_name'] = array(
      'name'  => 'first_name',
      'id'    => 'first_name',
      'type'  => 'text',
      'value' => $this->form_validation->set_value('first_name', $user->first_name),
    );
    $this->data['last_name'] = array(
      'name'  => 'last_name',
      'id'    => 'last_name',
      'type'  => 'text',
      'value' => $this->form_validation->set_value('last_name', $user->last_name),
    );
    $this->data['company'] = array(
      'name'  => 'company',
      'id'    => 'company',
      'type'  => 'text',
      'value' => $this->form_validation->set_value('company', $user->company),
    );
    $this->data['phone'] = array(
      'name'  => 'phone',
      'id'    => 'phone',
      'type'  => 'text',
      'value' => $this->form_validation->set_value('phone', $user->phone),
    );
    $this->data['password'] = array(
      'name' => 'password',
      'id'   => 'password',
      'type' => 'password'
    );
    $this->data['password_confirm'] = array(
      'name' => 'password_confirm',
      'id'   => 'password_confirm',
      'type' => 'password'
    );

    $this->_render_page('auth' . DIRECTORY_SEPARATOR . 'edit_user', $this->data);
  }

  /**
   * Create a new group
   */
  public function create_group()
  {
    $this->data['title'] = $this->lang->line('create_group_title');

    if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin())
    {
      redirect('auth', 'refresh');
    }

    // validate form input
    $this->form_validation->set_rules('group_name', $this->lang->line('create_group_validation_name_label'), 'trim|required|alpha_dash');

    if ($this->form_validation->run() === TRUE)
    {
      $new_group_id = $this->ion_auth->create_group($this->input->post('group_name'), $this->input->post('description'));
      if ($new_group_id)
      {
        // check to see if we are creating the group
        // redirect them back to the admin page
        $this->session->set_flashdata('message', $this->ion_auth->messages());
        redirect("auth", 'refresh');
      }
    }
    else
    {
      // display the create group form
      // set the flash data error message if there is one
      $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

      $this->data['group_name'] = array(
      'name'  => 'group_name',
      'id'    => 'group_name',
      'type'  => 'text',
      'value' => $this->form_validation->set_value('group_name'),
      );
      $this->data['description'] = array(
      'name'  => 'description',
      'id'    => 'description',
      'type'  => 'text',
      'value' => $this->form_validation->set_value('description'),
      );

      $this->_render_page('auth' . DIRECTORY_SEPARATOR . 'create_group', $this->data);
    }
  }

  /**
   * Edit a group
   *
   * @param int|string $id
   */
  public function edit_group($id)
  {
    // bail if no group id given
    if (!$id || empty($id))
    {
      redirect('auth', 'refresh');
    }

    $this->data['title'] = $this->lang->line('edit_group_title');

    if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin())
    {
      redirect('auth', 'refresh');
    }

    $group = $this->ion_auth->group($id)->row();

    // validate form input
    $this->form_validation->set_rules('group_name', $this->lang->line('edit_group_validation_name_label'), 'required|alpha_dash');

    if (isset($_POST) && !empty($_POST))
    {
      if ($this->form_validation->run() === TRUE)
      {
        $group_update = $this->ion_auth->update_group($id, $_POST['group_name'], $_POST['group_description']);

        if ($group_update)
        {
          $this->session->set_flashdata('message', $this->lang->line('edit_group_saved'));
        }
        else
        {
          $this->session->set_flashdata('message', $this->ion_auth->errors());
        }       
        redirect("auth", 'refresh');
      }
    }

    // set the flash data error message if there is one
    $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

    // pass the user to the view
    $this->data['group'] = $group;

    $readonly = $this->config->item('admin_group', 'ion_auth') === $group->name ? 'readonly' : '';
    $this->data['group_name'] = array(
      'name'    => 'group_name',
      'id'      => 'group_name',
      'type'    => 'text',
      'value'   => $this->form_validation->set_value('group_name', $group->name),
      $readonly => $readonly,
    );
    
    $this->data['group_description'] = array(
      'name'  => 'group_description',
      'id'    => 'group_description',
      'type'  => 'text',
      'value' => $this->form_validation->set_value('group_description', $group->description),
    );

    $this->_render_page('auth' . DIRECTORY_SEPARATOR . 'edit_group', $this->data);
  }

  /**
   * @return array A CSRF key-value pair
   */
  public function _get_csrf_nonce()
  {
    $this->load->helper('string');
    $key = random_string('alnum', 8);
    $value = random_string('alnum', 20);
    $this->session->set_flashdata('csrfkey', $key);
    $this->session->set_flashdata('csrfvalue', $value);

    return array($key => $value);
  }

  /**
   * @return bool Whether the posted CSRF token matches
   */
  public function _valid_csrf_nonce(){
    $csrfkey = $this->input->post($this->session->flashdata('csrfkey'));
    if ($csrfkey && $csrfkey === $this->session->flashdata('csrfvalue')){
      return TRUE;
    }
      return FALSE;
  }

  /**
   * @param string     $view
   * @param array|null $data
   * @param bool       $returnhtml
   *
   * @return mixed
   */
  public function _render_page($view, $data = NULL, $returnhtml = FALSE)//I think this makes more sense
  {

    $this->viewdata = (empty($data)) ? $this->data : $data;

    $view_html = $this->load->view($view, $this->viewdata, $returnhtml);

    // This will return html on 3rd argument being true
    if ($returnhtml)
    {
      return $view_html;
    }
  }
















    /*
    - Da de alta un usuario en una empresa.

    - Le manda el mail de bienvenida (a la empresa)
     */

    private function _add_user_to_empresa($user_id, $empresa_id)
    {
        $this->load->model('v2/v2perfiles_model');

        $perfil_comprador_id = $this->v2perfiles_model->get(array('nombre' => 'comprador'))->idperfiles;

        /**
         * Acá llamo al hook que se llama "register"
         */

        if ($this->v2usuarios_empresas_model->insert(array('user_id' => $user_id,
            'empresa_id'                                                 => $empresa_id,
            'perfil_id'                                                  => $perfil_comprador_id)) === false) {
            return false;
        }

        /* Esteban: 21/02/17 | 15:54:55  Manda el mail de bienvenida a la empresa. */

        $empresa = $this->v2empresa_model->get($empresa_id);
        $usuario = $this->v2usuarios_model->get($user_id);

        if (isset($empresa)) {
          $nombre_remitente = $empresa->nombre . ' en remateXremate';
        } else {
          $nombre_remitente = "remateXremate";
        }

        
        $data_email['nombre_empresa'] = $empresa->nombre;
        $data_email['usuario_nuevo'] = false; /* Esteban: 27/02/17 | 19:08:24 DONE: Ver de arriba cómo viene el alta. Si es nuevo o solo estoy agregándolo en una empresa */
        $html                        = $this->load->view('/email/bienvenido_empresa', $data_email, true);

        $link               = site_url();
        $link_arr           = parse_url($link);
        $link_arr['scheme'] = "http://";
        $link = $link_arr['scheme'] . trim($link_arr['host'] ? $link_arr['host'] : array_shift(explode('/', $link_arr['path'], 2)));

        $campos_email = array('NOMBRE_USUARIO' => $usuario->first_name,
            'EMPRESA'                              => $empresa->nombre,
            'LINK'                                 => $link);
        $html = $this->lib_email->armar_mail($html, $campos_email);

        $this->lib_email->enviar_mail(
            $nombre_remitente, // Nombre remitente
            $this->config->item('direccion_altas'), // direccion remitente
            $usuario->email, // email destinatario
            "Ahora podés ingresar en " . $empresa->nombre . " con remateXremate!",
            $html
        );
        if ($empresa_id == 189) {
          $this->lib_email->enviar_mail(
              $nombre_remitente, // Nombre remitente
              $this->config->item('direccion_altas'), // direccion remitente
              "informes@espinarawsonyasoc.com.ar", // email destinatario
              "Ahora podés ingresar en " . $empresa->nombre . " con remateXremate!",
              $html
          );
        }
        return true;
    }


  public function upload_foto() {
    $imagen = key($_FILES);
    switch ($imagen) {
    
      case 'documento':
        $ext = pathinfo($_FILES['documento']['name'], PATHINFO_EXTENSION);
        $_FILES['documento']['name'] = uniqid("usuario_", true) . '.' . $ext;
        $this->firebug->log('$_FILES ---> ' . var_export($_FILES, true));
        $ancho = $this->config->item('DOCUMENTO_ANCHO');
        $alto = $this->config->item('DOCUMENTO_ALTO');
        $foto_default = $this->config->item('default_documento');
        break;
      
    }

    require_once(FCPATH . 'application/libraries/UploadHandler.php');
    $upload_handler = new UploadHandler(array('max_file_size' => remates_kmg_to_bytes(ini_get('upload_max_filesize')),
                        'image_file_types' => '/\.(gif|jpe?g|png)$/i',
                        'upload_dir' => FCPATH . $this->config->item('path_imagenes_usuarios'),
                        'upload_url' => $this->config->item('path_imagenes_usuarios'),
                        'param_name' => $imagen,
                        'print_response' => false,
                        'image_versions' => array(
                          '' => array(
                          'max_width' => $ancho,
                          'max_height' => $alto,
                          'jpeg_quality' => 70,
                          'crop' => false
                          )
                          )
                        ), true, null, $imagen);

    $respuesta = array(
        "rta" => $upload_handler->get_response()[$imagen][0],
        "archivo" => $upload_handler->get_response()[$imagen][0]->name,
        "nombre" => $upload_handler->get_response()[$imagen][0]->name,
    );
    echo json_encode($respuesta);
    }












}
