<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
use Jaxon\Jaxon; //Use the jaxon core clss
use Jaxon\Response\Response; //and the Response class
use Jaxon\Request\Factory as xr;

class Empresa extends Admin_Controller {

		function __construct()
				{
				global $config;
				parent::__construct();
				$this->load->model('v2empresa_model');
        $this->load->model('v2dominios_model');
				$this->load->model('v2permisos_model');
				$this->load->model('v2opciones_model');
				$this->load->model('v2empresas_opciones_model');

				$this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'refresh'));
				$this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'agregar_empresa'));
				$this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'grabar_empresa'));

				if (substr($this->router->fetch_method(), 0, 5) == "index" || $this->router->fetch_method() == "") {
					$this->data['refresh_method'] = xr::call('refresh', null);
				}

				$this->data['MODO_DEBUG'] = true;


				$this->jaxon->processRequest();
				/* Title Page */
				$this->page_title->push("Empresa");
				$this->data['pagetitle'] = $this->page_title->show();
				$this->data['menuitem_actual'] = "Empresa";
				}


		public function refresh() {
			if ($this->v2permisos_model->verificar_permiso('miempresa', $_SESSION['user_id'])) {
				if(isset($_SESSION['error'])) {
					$this->jaxon_respuesta->dialog->error($_SESSION['error'], 'Error!');
				} elseif(isset($_SESSION['success'])) {
					$this->jaxon_respuesta->dialog->success($_SESSION['success'], 'Ok!');
				} elseif(isset($_SESSION['modal'])) {
					$botones = array(array('title' => 'Cerrar', 'class' => 'button', 'click' => 'close'));
					$this->jaxon_respuesta->dialog->modal('Atención', $_SESSION['modal'], $botones, array('id' => 'dlg_advertencia', 'size' => 'size-wide'));
				}
			} else {
				$this->jaxon_respuesta->dialog->error('No tiene permisos.', 'Error!');
			}
			return $this->jaxon_respuesta;
		}


		public function index() {
			if (!$this->v2permisos_model->verificar_permiso('miempresa', $this->session->userdata('user_id'))) {
				die ('El usuario no tiene permisos');
			}
					
			$this->data['empresa'] = $this->v2empresa_model->get($this->session->userdata('empresa_id'));
			$this->data['dominios_root'] =  $this->v2dominios_model->get_all();
			$opciones = $this->v2opciones_model->get_all();
			$opciones_editables_empresa = unserialize($this->data['empresa']->opciones_editables);
			if ($this->data['es_superadmin']) {
				$this->data["opciones_todas"] = $opciones;
				$this->data["opciones_editables"] = $opciones_editables_empresa;
			}
			if( isset($opciones) && is_array($opciones) && count($opciones) > 0) {
				foreach($opciones as $opcion) {
					if( ((is_array($opciones_editables_empresa) > 0) &&  in_array($opcion->idopciones, $opciones_editables_empresa)) || $this->data['es_superadmin']) {
						$rw = $this->v2permisos_model->verificar_permiso('Opciones empresa', $_SESSION['user_id']);
						$valor = $this->v2opciones_model->get_valor_opcion($opcion->nombre, $_SESSION['empresa_id']);
						$this->data['opciones'][] = array('opcion' => $opcion, 'html' => $this->v2opciones_model->get_opcion_html_mostrar($opcion->tipo_id, $valor, $rw, $opcion->valores, $opcion->idopciones, $opcion->class));
					}
				}
			}
			
			$this->template->admin_render('admin/empresa/index', $this->data);
		}








	public function upload_foto() {
		$imagen = key($_FILES);
		switch ($imagen) {
		
      case 'portada':
        $ancho = $this->config->item('PORTADA_ANCHO');
        $alto = $this->config->item('PORTADA_ALTO');
        $foto_default = (isset($empresa->foto_portada) && $empresa->foto_portada != $this->config->item('path_imagenes_empresa') && file_exists(FCPATH . $empresa->foto_portada)) ? $empresa->foto_portada : $this->config->item('PORTADA_DEFAULT');
        break;
      
			case 'header':
				$ancho = $this->config->item('HEADER_ANCHO');
				$alto = $this->config->item('HEADER_ALTO');
        $foto_default = (isset($empresa->foto_header) && $empresa->foto_header != $this->config->item('path_imagenes_empresa') && file_exists(FCPATH . $empresa->foto_header)) ? $empresa->foto_header : $this->config->item('HEADER_DEFAULT');
        break;
		}

		require_once(FCPATH . 'application/libraries/UploadHandler.php');
		$upload_handler = new UploadHandler(array('max_file_size' => remates_kmg_to_bytes(ini_get('upload_max_filesize')),
												'image_file_types' => '/\.(gif|jpe?g|png)$/i',
												'upload_dir' => FCPATH . $this->config->item('path_imagenes_empresa'),
												'upload_url' => $this->config->item('path_imagenes_empresa'),
												'param_name' => $imagen,
												'print_response' => false,
												'image_versions' => array(
													'' => array(
													'max_width' => $ancho,
													'max_height' => $alto,
													'jpeg_quality' => 70,
													'crop' => false
													),
													'thumbnail' => array(
														'max_width' => 80,
														'max_height' => 80,
														'crop' => false
														)
													)
												), true, null, $imagen);

		$respuesta = array(
				"rta" => $upload_handler->get_response()[$imagen][0],
				"archivo" => $upload_handler->get_response()[$imagen][0]->name,
				"nombre" => $upload_handler->get_response()[$imagen][0]->name,
        "foto_default" => $foto_default
		);
		echo json_encode($respuesta);
		}



		public function grabar_empresa() {
      $empresa_id = $this->input->post("empresa_id");
      $datos = $this->input->post("datos");
      $respuesta['error'] = false;

			if ($this->v2permisos_model->verificar_permiso('miempresa', $this->session->userdata('user_id'))) {
				$this->form_validation->set_rules('nombre', 'Nombre', 'required|trim');
				$this->form_validation->set_data($datos);
				if ($this->data['es_superadmin']) {	
					$this->form_validation->set_rules('dominio', 'Dominio', 'required|trim');
				}

				if (($this->form_validation->run() == FALSE)) {
					$respuesta['error'] = true;
          $respuesta['mensaje'] = validation_errors();
				} else {
  				$datos_para_grabar['nombre'] = $datos['nombre'];
  				$datos_para_grabar['url'] = $datos['url'];
  				if ($this->data['es_superadmin']) {
  					$datos_para_grabar['dominio'] = $datos['dominio'];
  					$datos_para_grabar['dominio_root'] = $datos['dominio_root'];
  				}
          if(isset($datos['nombre_portada']) && ($datos['nombre_portada'] != '')) {
            $datos_para_grabar['nombre_foto_portada'] = $datos['nombre_portada'];
          }
  				if(isset($datos['nombre_header']) && ($datos['nombre_header'] != '')) {
  					$datos_para_grabar['nombre_foto_header'] = $datos['nombre_header'];
  				}

          if(isset($datos['archivo_portada']) && ($datos['archivo_portada'] != '')) {
            $datos_para_grabar['foto_portada'] = $datos['archivo_portada'];
          }
  				if(isset($datos['archivo_header']) && ($datos['archivo_header'] != '')) {
  					$datos_para_grabar['foto_header'] = $datos['archivo_header'];
  				}
  				if ($this->data['es_superadmin']) {
            if (isset($datos['opciones_backend']) && is_array($datos['opciones_backend']))
	 				  $datos_para_grabar['opciones_editables'] = serialize($datos['opciones_backend']);
          }

          if (isset($empresa_id) && $empresa_id > 0) {
            /* Esteban: 09/04/18 | 18:52:18  No debo comparar con ! en los updates para saber si hubo un error, porque si los datos nuevos son iguales que los viejos, MySQL no graba, y la cuenta de "affected rows" te devuelve 0, que php confunde con un false, y te comés un error cuando no lo hubo */
            if ($this->v2empresa_model->update($datos_para_grabar, $empresa_id) === false) {
              $this->jaxon_respuesta->dialog->error('Error!', 'No se pudo grabar la empresa!');
              return $this->jaxon_respuesta;
            }
            $return_var = 0;
            // ob_start();
            // system('/home/desarrollo/generar_subdominio.sh ' . $datos_para_grabar['dominio'] . ' remates_test 2>&1', $return_var);
            // $result = ob_get_contents();
            // ob_end_clean();
            $this->firebug->log('$result ---> ' . var_export($result, true));
            file_put_contents("/var/log/creacion_empresas/subdominio_" . $datos_para_grabar['dominio'], $result, FILE_APPEND);              
          } else {
            if (($empresa_id = $this->v2empresa_model->insert($datos_para_grabar)) === false) {
              $this->jaxon_respuesta->dialog->error('Error!', 'No se pudo grabar la empresa!');
            $this->firebug->log('$result ---> ' . var_export($result, true));
            $this->firebug->log('$result ---> ' . var_export($result, true));
              return $this->jaxon_respuesta;
            }
            $return_var = 0;
            ob_start();
            system('/home/desarrollo/generar_subdominio.sh ' . $datos_para_grabar['dominio'] . ' remates_test 2>&1', $return_var);
            $result = ob_get_contents();
            ob_end_clean();
            $this->firebug->log('$result ---> ' . var_export($result, true));
            file_put_contents("/var/log/creacion_empresas/subdominio_" . $datos_para_grabar['dominio'], $result, FILE_APPEND);              
          }
				 
  
          $this->v2empresas_opciones_model->delete(array('empresa_id' => $empresa_id));

          $this->data['empresa'] =  $this->v2empresa_model->get($_SESSION['empresa_id']);

  				$respuesta['error'] = false;
  				 
        }


			} else {
				$respuesta['error'] = true;
        $respuesta['mensaje'] = 'No tiene permiso';
			}
      die(json_encode($respuesta));
		}









    public function agregar_empresa($nombre) {
      $respuesta['error'] = false;

      if ($this->data['es_superadmin']) { 
        $this->firebug->log('$nombre ---> ' . var_export($nombre, true));
        if (($empresa_id = $this->v2empresa_model->insert(array('nombre' => $nombre))) === false) {
          $this->jaxon_respuesta->dialog->error('Error!', 'No se pudo grabar la empresa!');
          return $this->jaxon_respuesta;
        } else {
          $this->jaxon_respuesta->dialog->success('Ok!', 'Termine de configurar la empresa!');
          $this->session->set_userdata('empresa_id', $empresa_id);
          $this->jaxon_respuesta->script('window.location.href="' . '/empresa' . '"');
          return $this->jaxon_respuesta;
        }
         
      } else {
        $this->jaxon_respuesta->dialog->error('Error!', 'No tiene permiso!');
        return $this->jaxon_respuesta;
      }
    }

}
?>