<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
use Jaxon\Jaxon; //Use the jaxon core clss
use Jaxon\Response\Response; //and the Response class
use Jaxon\Request\Factory as xr;

class Lotes extends Admin_Controller {
		public $vimeo;
		function __construct() {
				global $config;
				parent::__construct();
				$this->load->helper('url', 'form');
				$this->load->helper('remates');
				$this->load->library('form_validation');

				// $this->load->library('admin/lotes/lotes_jaxon');

        $this->load->model('v2empresa_model');
				$this->load->model('v2permisos_model');
				$this->load->model('v2remates_model');
        $this->load->model('v2lotes_model');
				$this->load->model('v2lotes_status_model');
				$this->load->model('v2media_lotes_model');
				$this->load->model('v2monedas_model');
				$this->load->model('v2opciones_model');

				$this->vimeo = new \Vimeo\Vimeo($this->config->item("vimeo_client_id"), $this->config->item("vimeo_client_secret"), $this->config->item("vimeo_access_token"));

				$this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'refresh'));
				$this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'eliminar_lote'));
				$this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'grabar_lote'));
				$this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'editar_lote'));
				$this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'grabar_orden_media'));
				$this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'refresh_galeria'));

				$this->data['refresh_method'] = xr::call('refresh', null);

				$this->jaxon->processRequest();
				/* Title Page */

				$this->page_title->push("Lotes");
				$this->data['pagetitle'] = $this->page_title->show();
				$this->data['menuitem_actual'] = "lotes";
				}


		public function index() {
			if (!$this->v2permisos_model->verificar_permiso('Menu_item lotes', $this->session->userdata('user_id'))) {
				die('El usuario no tiene permisos');
			} else {
				$this->template->admin_render('admin/lotes/index', $this->data);
			}
		}


		public function refresh() {
			if ($this->v2permisos_model->verificar_permiso('Refresh lote', $_SESSION['user_id'])) {
				$this->jaxon_respuesta->jquery('#tabla_lotes')->DataTable()->ajax->reload();
			} else {
				$this->jaxon_respuesta->dialog->error('No tiene permisos.', 'Error!');
			}
			return $this->jaxon_respuesta;
		}

		public function get_lotes() {
			$lotes_obj = $this->v2lotes_model;
			
			$registros_pagina = $_POST['length'];
			
			$pagina = ($_POST['start'] / $registros_pagina) + 1;

			$ordenar = array();
			$columnas = $_POST['columns'];
			if( isset($_POST['order']) && is_array($_POST['order']) && count($_POST['order']) > 0) {
				foreach($_POST['order'] as $orden){
					if(isset($columnas[$orden['column']]['campoOrden']) && !empty($columnas[$orden['column']]['campoOrden'])) {
						$ordenar[] = array($columnas[$orden['column']]['campoOrden'] => $orden['dir']);
					} else {
						$ordenar[] = array($columnas[$orden['column']]['data'] => $orden['dir']);
					}
				}
			}
					


			$campos = array("lotes.idlotes",
											"remates.nombre as remate", 
                      "lotes.titulo", 
											"lotes.base",
											"monedas.nombre as moneda", 
											"lotes_status.nombre AS estado");

			if(isset($_POST['search']) && isset($_POST['search']['value']) && !empty($_POST['search']['value'])) {
				$or = false;
				$where_ = " 1 = 1 AND (";
				foreach ($columnas as $columna) {
					if ($columna["searchable"] == 'true') {
						if ($or) { 
							$where_ .= " OR ";
						}
						$or = true;
					}
				}
				$where_ .= ") ";
			} else {
				$where_ = null;
			}
			$lotes_res = $lotes_obj->as_array()->fields($campos)->traer_paginados($registros_pagina, $pagina, $ordenar, $where_, $campos);
			$lotes = $lotes_res['result'];
			if(!isset($lotes)) {
				$lotes = array();
			}
			
			$registros_totales = $lotes_res['total_rows'];
			if(!isset($registros_totales)) {
				$registros_totales = 0;
			}

			$registros_filtrados = $lotes_res['filtered_rows'];
			if(!isset($registros_filtrados)) {
				$registros_filtrados = 0;
			}


			$permiso_modificar = $this->v2permisos_model->verificar_permiso('Edit lote', $_SESSION['user_id']);
			$permiso_borrar = $this->v2permisos_model->verificar_permiso('Del lote', $_SESSION['user_id']);  

			$resultados = array();
			if( isset($lotes) && is_array($lotes) && count($lotes) > 0) {
				foreach($lotes as &$lote){
					$lote['detalle'] = '<i class="fa fa-search-plus detalle-lote">';
					$lote['editar'] = ($permiso_modificar ? '<i class="fa fa-edit editar_lote">' : '-');
					$lote['borrar'] = ($permiso_borrar ? '<i class="fa fa-trash" onclick="jaxon_eliminar_lote(' . $lote['idlotes'] . ')">' : '');
				}
			}
			$results = array(
				"draw" => $_POST['draw'],
				"recordsTotal" => $registros_totales,
				"recordsFiltered" => $registros_filtrados,
				"data" => $lotes);

			die(json_encode($results));
		}

		public function detalles_lote() {
			$lote_id = $this->input->post('lote_id');
			if ($this->v2permisos_model->verificar_permiso('Edit lote', $_SESSION['user_id'])) {
				$lote = $this->v2lotes_model->with_moneda()->with_estado()->get($lote_id);
        $remate = $this->v2remates_model->get($lote->remate_id);
				$this->data['lote'] = $lote;
        $this->data['remate'] = $remate;

				$html = $this->load->view('admin/lotes/detalles_lote', $this->data, true);
				$respuesta = array("error" => false, "html" => $html);
				die(json_encode($respuesta));
			} else {
				die(json_encode(array("error" => true, "mensaje"=>"No tiene permiso")));
			}
		}

		public function grabar_lote($lote_id = null, $datos) {

			if ($this->v2permisos_model->verificar_permiso('Add lote', $this->session->userdata('user_id'))) {
				$this->form_validation->set_data($datos);
				$this->form_validation->set_rules('nombre', 'Nombre', 'required|trim');

				if (($this->form_validation->run() == FALSE)) {
					$this->jaxon_respuesta->dialog->error(validation_errors(), 'Error!');
					return $this->jaxon_respuesta;
				}

				$datos_para_grabar['titulo'] = $datos['nombre'];
				$datos_para_grabar['descripcion'] = $datos['descripcion'];
				$datos_para_grabar['base'] = $datos['base'];
        $datos_para_grabar['valor_aspirado'] = $datos['valor_aspirado'];
				$datos_para_grabar['moneda_id'] = $datos['moneda_id'];
				$datos_para_grabar['step'] = $datos['step'];
				$datos_para_grabar['status_id'] = 1; /* Esteban: 17/02/21 | 13:21:56  Nuevo */
        $datos_para_grabar['remate_id'] = $datos['remate_id'];
        $datos_para_grabar['status_id'] = $datos['status_id'];
        $datos_para_grabar['orden'] = $datos['orden'];
			 
				if (isset($lote_id) && $lote_id > 0) {
					$es_update = true;
					if ($this->v2lotes_model->update($datos_para_grabar, $lote_id) === false) {
						$this->jaxon_respuesta->dialog->error('No se pudo grabar el lote!', 'Error!');
						return $this->jaxon_respuesta;
					}
				} else {
					$es_update = false;
					if (($lote_id = $this->v2lotes_model->insert($datos_para_grabar)) === false) {
						$this->jaxon_respuesta->dialog->error('No se pudo grabar el lote!', 'Error!');
						return $this->jaxon_respuesta;
					}
				}
				if ($es_update) {
					$this->jaxon_respuesta->jquery('#lote_crud')->modal('hide');
				}
				$this->jaxon_respuesta->dialog->success('lote ' . $datos['nombre'] . ' grabado!', 'Ok!');
				return $this->refresh();			
			}
	
			$this->jaxon_respuesta->dialog->error('No tiene permiso', 'Error!');
			return $this->jaxon_respuesta;
		}





		public function editar_lote() {
			if ($this->v2permisos_model->verificar_permiso('Edit lote', $_SESSION['user_id'])) {
				$lote_id = $_POST['lote_id'];
				if (isset($lote_id) && $lote_id) {
					$lote = $this->v2lotes_model->get($lote_id);
					$this->data['lote'] = $lote;
				}
				$this->data['remates'] = $this->v2remates_model->as_dropdown('nombre')->get_all_pendientes($_SESSION['empresa_id']);
        $this->data['monedas'] = $this->v2monedas_model->as_dropdown('nombre')->get_all();
        $this->data['statuses'] = $this->v2lotes_status_model->as_dropdown('nombre')->get_all();

				$html = $this->load->view('admin/lotes/popup_lote', $this->data, true);
				$respuesta = array("error" => false, "html" => $html);
				die(json_encode($respuesta));
			} else {
				die(json_encode(array("error" => true, "mensaje"=>"No tiene permiso")));
			}
		}



		public function eliminar_lote($lote_id) {
			if ($this->v2permisos_model->verificar_permiso('Del lote', $_SESSION['user_id'])) {
				if (isset($lote_id)){
					$this->v2lotes_model->delete($lote_id);
					$this->jaxon_respuesta->dialog->info('lote eliminado', 'Info');
					return $this->refresh();
				} else {
					$this->jaxon_respuesta->dialog->error('No se pudo eliminar el lote!', 'Error!');
					return $this->jaxon_respuesta;
				}
			} else {
				$this->jaxon_respuesta->dialog->error('No tiene permiso', 'Error!');
				return $this->jaxon_respuesta;
			}
		}




	public function upload_imagen() {
		require_once(FCPATH . 'application/libraries/UploadHandler.php');
		$tipo_media = $_FILES['galeria_lotes_upload']['type'];
		$mime = $this->get_mime_key($tipo_media);
		
		if( $mime == 'png' || $mime == 'gif' || $mime == 'jpg' || $mime == 'jpeg' || $mime == 'png') {
			$ancho = $this->config->item('FOTOS_LOTES_ANCHO');
			$alto = $this->config->item('FOTOS_LOTES_ALTO');
			$uploadHandler = new UploadHandler([
					'param_name'          => 'galeria_lotes_upload',
					'image_file_types' => '/\.(gif|jpe?g|png|mp4|mp3)$/i',
					'upload_dir' => FCPATH . $this->config->item('path_imagenes_lotes'),
					'upload_url' => $this->config->item('path_imagenes_lotes'),
					'discard_aborted_uploads' => true, /* Esteban: 02/12/20 | 15:13:05  Set the following option to false to enable resumable uploads: */
					'image_versions' => array(
						'' => array(
						'max_width' => $ancho,
						'max_height' => $alto,
						'jpeg_quality' => 70,
						'crop' => false
						),
						'thumbnail' => array(
							'max_width' => 80,
							'max_height' => 80,
							'crop' => false
							)
						)
			], false);
			$data = $uploadHandler->post(false);
			if (isset($data['galeria_lotes_upload'][0]->error)) { 
				die(json_encode(array("error" => $data['galeria_lotes_upload'][0]->error)));
			}
      $orden = $this->v2media_lotes_model->fields(null, "MAX(orden) AS orden")->get_all();

			$datos_media = array("ruta" => $data['galeria_lotes_upload'][0]->url,
													"tamanio" => $data['galeria_lotes_upload'][0]->size,
													"tamanio_string" => $this->format_size($data['galeria_lotes_upload'][0]->size),
													"nombre" => $data['galeria_lotes_upload'][0]->name,
													"thumbnailUrl" => $data['galeria_lotes_upload'][0]->thumbnailUrl,
													"lote_id" => $_POST['lote_id'],
													"orden" => $orden[0]->orden + 1,
                          "tipo" => "imagen");
			$this->v2media_lotes_model->insert($datos_media);
		} else {
			die(json_encode(array("error" => "Tipo de archivo inválido")));
		}
		$this->data['media'] = $this->v2media_lotes_model->order_by('orden')->get_all(array('lote_id' => $_POST['lote_id']));
		$html = $this->load->view('admin/lotes/media.php', $this->data, true);
		die(json_encode(array("html" => $html), JSON_HEX_QUOT | JSON_HEX_TAG));
	}









	public function upload_vimeo() {
		$tamanio = $this->input->request_headers();
		$tamanio = $tamanio['Upload-Length'];
		// $nombre = $_POST['name'];
		// $tipo_media = "video/x-matroska";
		// $tamanio = 1520309;
		// $nombre = "vid1.mkv";
		$intentos = 0;
		
		// public function request($url, $params = array(), $method = 'GET', $json_body = true, array $headers = array()): array
		do {
			try {
				$respuesta = $this->vimeo->request('/me/videos'
					,array ("upload" => array(
										"approach" => "tus",
										"size" => $tamanio,
										),
									"privacy" => array(
											"add" => false,
											"comments" => "nobody",
											"download" => false,
											"embed" => "whitelist",
											"view" => "disable",
										),
									"review_page" => array(
											"active" => false,
											"notes" => false,
											"vimeo_logo" => false
										),
									"embed" => array(
										"buttons" => array(
											"embed" => false,
											"fullscreen" => false,
											"hd" => false,
											"like" => false,
											"scaling" => false,
											"share" => false,
											"watchlater" => false,
											),
										"color" => "#000000",
										"logos" => array(
											"custom" => array(
												"active" => true,
												"id" => 0,
												"link" => base_url(),
												"sticky" => true
												),
											"vimeo" => false
											),
										"playbar" => true,
										"title" => array(
											"name" => "hide",
											"owner" => "hide",
											"portrait" => "hide",
											),
										"volume" => true
										),
									)
					, 'POST'
					, true
					, array("Authorization" => "bearer 902debfecb789529292a9f9c963c8f03",
									"Content-Type" => "application/json",
									"Accept" => "application/vnd.vimeo.*+json;version=3.4"
									)
					);
				if ($respuesta['status'] == 200 && $respuesta['body']['upload']['approach'] == 'tus') {
					/* Esteban: 02/12/20 | 14:10:06  https://developer.vimeo.com/api/upload/videos#resumable-upload
						Make sure to check the response for the upload.approach field; the value here should be tus. 
						If it isn't, try this step again, and take extra care that you're sending a POST 
						request and that you specify tus as the approach in the request body. 
					*/
					$ruta = $respuesta['body']['link'];
					$video_id = $this->getVimeoId($ruta);
					header("Location: " . $respuesta['body']['upload']['upload_link'], true, 200);
					echo(json_encode(array(
														"upload_link" => $respuesta['body']['upload']['upload_link'],
														"ruta" => $ruta,
														"video_id" => $video_id,
														)));
					return;
					break; /* Esteban: 02/12/20 | 13:59:44  Sale del DO */
				} else {
					$errores[] = $respuesta['body']["error"] . "(" . $respuesta['body']['developer_message'] . ")";
					sleep(1);
					$intentos ++;
				}
			} catch (Exception $e){
				$errores[] = $e->getMessage();
				sleep(1);
				$intentos ++;
			}
		}while($intentos < $this->config->item('MAX_INTENTOS_POST_VIMEO'));    
		die(json_encode(array("error" => "Errores con Vimeo", "mensajes" => $errores)));
	}

	public function insert_media_sin_procesar() {
		$lote_id = $this->input->post("lote_id");
		$nombre = $this->input->post("nombre") ? $this->input->post("nombre") : '';
		$tamanio = $this->input->post("tamanio");
		$ruta = $this->input->post("ruta");
		$video_id = $this->getVimeoId($ruta);
    $orden = $this->v2media_lotes_model->fields(null, "MAX(orden) AS orden")->get_all();

		$datos_media = array("ruta" => $ruta,
												"tamanio" => $tamanio,
												"tamanio_string" => $this->format_size($tamanio),
												"nombre" => $nombre,
												"lote_id" => $lote_id,
												"tipo" => "video",
                        "orden" => $orden[0]->orden + 1,
                        "video_id" => $video_id);
    $this->v2media_lotes_model->insert($datos_media);
    $dominio_empresa = $this->v2empresa_model->get_dominio($_SESSION['empresa_id']);
    $respuesta = $this->vimeo->request('/videos/' . $video_id . "/privacy/domains/" . urlencode($dominio_empresa), null, 'PUT', true, array());
    

		$this->data['media'] = $this->v2media_lotes_model->order_by('orden')->get_all(array('lote_id' => $lote_id));
		$html = $this->load->view('/admin/lotes/media', $this->data, true);
		die(json_encode(['html' => $html, 'video_id' => $video_id], JSON_HEX_QUOT | JSON_HEX_TAG));

	}

  public function eliminar_media() {
    $media_id = $this->input->post('media_id');
    $lote_id = $this->input->post('lote_id');
    $this->v2media_lotes_model->delete(array("media_id" => $media_id));
    $this->data['media'] = $this->v2media_lotes_model->order_by('orden')->get_all(array('lote_id' => $lote_id));
    $html = $this->load->view('/admin/lotes/media', $this->data, true);
    die(json_encode($html, JSON_HEX_QUOT | JSON_HEX_TAG));

  }

		// $respuesta = $this->vimeo->request('/videos/' . $video_id . '/pictures', null, 'GET', true, array());
		// $imagenes = array();
		// foreach ($respuesta['body']['data'] as $datas) {
		// 	foreach($datas['sizes'] as $size){
		// 		if ($size['height'] > 80) {
		// 			$imagenes[] = $size['link_with_play_button'];
		// 		}
		// 	}
		// }


	private function getVimeoId($url) {
		$url_parts = explode("/", parse_url($url, PHP_URL_PATH));
		$video_id = $url_parts[count($url_parts)-1];
		return $video_id;
	}












		public function grabar_orden_media() {
      $orden_objetos = $_POST['orden_objetos'];
      if($orden_objetos && count($orden_objetos) > 0) {
        $i = 0;
        foreach ($orden_objetos as $oo) {
          $this->v2media_lotes_model->where(array('media_id' => $oo))->update(array('orden' => $i));
          $i++;
        }
			}


		}





		public function refresh_galeria() { 
			$lote_id = $_POST['lote_id'];
					// .bind('sortupdate', function(e, ui) {
					//     //ui.item contains the current dragged element.
					//     //Triggered when the user stopped sorting and the DOM position has changed.
					//     grabar_orden();
					// });
			$this->data['media'] = $this->v2media_lotes_model->order_by('orden')->get_all(array('lote_id' => $lote_id));
			$html = $this->load->view('/admin/lotes/media', $this->data, true);
			die(json_encode($html, JSON_HEX_QUOT | JSON_HEX_TAG));
		}


		public function get_mime_key($media_type) {
			$mimes = get_mimes();
			foreach ($mimes as $key => $mime) {
				if (!is_array($mime)) {
					$mime = array($mime);
				}
				if (in_array($media_type, $mime)) {
					return $key;
				}
			}
			return false;
		}




	private function format_size($bytes) {
		if (!is_numeric($bytes)) {
				return '';
		}
		if ($bytes >= 1000000000) {
				return number_format($bytes / 1000000000, 2) . 'GB';
		}
		if ($bytes >= 1000000) {
				return  number_format($bytes / 1000000, 2) . ' MB';
		}
		return  number_format($bytes / 1000, 2) . ' KB';
	}

}

?>