<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
use Jaxon\Jaxon; //Use the jaxon core clss
use Jaxon\Response\Response; //and the Response class
use Jaxon\Request\Factory as xr;

class Perfiles extends Admin_Controller {

    function __construct() {
        global $config;
        parent::__construct();
        $this->load->helper('url', 'form');
        $this->load->library('form_validation');
        // $this->load->library('admin/perfiles/perfiles_jaxon');

        $this->load->model('v2empresa_model');
        $this->load->model('v2permisos_model');
        $this->load->model('v2perfiles_model');
        $this->load->model('v2clase_items_sistema_model');
        $this->load->model('v2items_sistema_model');
        $this->load->model('v2pantallas_inicio_model');
        $this->load->model('v2opciones_model');

        $this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'refresh'));
        $this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'eliminar_perfil'));
        $this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'grabar_perfil'));
        $this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'editar_perfil'));

        $this->data['refresh_method'] = xr::call('refresh', null);

        $this->jaxon->processRequest();
        /* Title Page */

        $this->page_title->push("Perfiles");
        $this->data['pagetitle'] = $this->page_title->show();
        $this->data['menuitem_actual'] = "perfiles";
        }


    public function index() {
      if (!$this->v2permisos_model->verificar_permiso('Menu_item perfiles', $this->session->userdata('user_id'))) {
        die('El usuario no tiene permisos');
      } else {
        $this->template->admin_render('admin/perfiles/index', $this->data);
      }
    }


    public function refresh() {
      if ($this->v2permisos_model->verificar_permiso('Refresh perfil', $_SESSION['user_id'])) {
        $this->jaxon_respuesta->jquery('#tabla_perfiles')->DataTable()->ajax->reload();
      } else {
        $this->jaxon_respuesta->dialog->error('No tiene permisos.', 'Error!');
      }
      return $this->jaxon_respuesta;
    }

    public function get_perfiles() {
      $perfiles_obj = $this->v2perfiles_model;
      
      $registros_pagina = $_POST['length'];
      
      $pagina = ($_POST['start'] / $registros_pagina) + 1;

      $ordenar = array();
      $columnas = $_POST['columns'];
      if( isset($_POST['order']) && is_array($_POST['order']) && count($_POST['order']) > 0) {
        foreach($_POST['order'] as $orden){
          if(isset($columnas[$orden['column']]['campoOrden']) && !empty($columnas[$orden['column']]['campoOrden'])) {
            $ordenar[] = array($columnas[$orden['column']]['campoOrden'] => $orden['dir']);
          } else {
            $ordenar[] = array($columnas[$orden['column']]['data'] => $orden['dir']);
          }
        }
      }
          


      $campos = array("perfiles.idperfiles", 
                      "perfiles.nombre", 
                      "perfiles.rol_id", 
                      "roles.nombre as rol");

      if(isset($_POST['search']) && isset($_POST['search']['value']) && !empty($_POST['search']['value'])) {
        $or = false;
        $where_ = " 1 = 1 AND (";
        foreach ($columnas as $columna) {
          if ($columna["searchable"] == 'true') {
            if ($or) { 
              $where_ .= " OR ";
            }
            $or = true;
          }
        }
        $where_ .= ") ";
      } else {
        $where_ = null;
      }
      $perfiles_res = $perfiles_obj->as_array()->fields($campos)->traer_paginados($registros_pagina, $pagina, $ordenar, $where_, $campos);
      $perfiles = $perfiles_res['result'];
      if(!isset($perfiles)) {
        $perfiles = array();
      }
      
      $registros_totales = $perfiles_res['total_rows'];
      if(!isset($registros_totales)) {
        $registros_totales = 0;
      }

      $registros_filtrados = $perfiles_res['filtered_rows'];
      if(!isset($registros_filtrados)) {
        $registros_filtrados = 0;
      }


      $permiso_modificar = $this->v2permisos_model->verificar_permiso('Edit perfil', $_SESSION['user_id']);
      $permiso_borrar = $this->v2permisos_model->verificar_permiso('Del perfil', $_SESSION['user_id']);  

      $resultados = array();
      if( isset($perfiles) && is_array($perfiles) && count($perfiles) > 0) {
        foreach($perfiles as &$perfil){
          $perfil['detalle'] = '<i class="fa fa-search-plus detalle-perfil">';
          $perfil['editar'] = ($permiso_modificar ? '<i class="fa fa-edit editar_perfil">' : '-');
          $perfil['borrar'] = ($permiso_borrar ? '<i class="fa fa-trash" onclick="jaxon_eliminar_perfil(' . $perfil['idperfiles'] . ')">' : '');
          $perfil['play'] = '<i class="fa fa-play" onclick="jaxon_iniciar_perfil(' . $perfil['idperfiles'] . ')">';
        }
      }
      $results = array(
        "draw" => $_POST['draw'],
        "recordsTotal" => $registros_totales,
        "recordsFiltered" => $registros_filtrados,
        "data" => $perfiles);

      die(json_encode($results));
    }

    public function detalles_perfil() {
      $perfil_id = $this->input->post('perfil_id');
      if ($this->v2permisos_model->verificar_permiso('Edit perfil', $_SESSION['user_id'])) {
        $this->data['perfil'] = $this->v2perfiles_model->with_rol()->get($perfil_id);
        $this->data['permisos'] = $this->v2permisos_model->fields('item_id')->get_all(array('perfil_id' => $perfil_id));
        if ($this->data['permisos']) {
          $this->data['permisos'] = array_column($this->data['permisos'], 'item_id');
        }
        $this->data['clases_items_sistema'] = $this->v2clase_items_sistema_model->fields(array('idclase_items_sistema', 'nombre as clase_item_sistema'))->with_items_sistema(array('fields' => 'iditems_sistema AS id, nombre'))->get_all();
        $html = $this->load->view('admin/perfiles/detalles_perfil', $this->data, true);
        $respuesta = array("error" => false, "html" => $html);
        die(json_encode($respuesta));
      } else {
        die(json_encode(array("error" => true, "mensaje"=>"No tiene permiso")));
      }
    }

    public function grabar_perfil($perfil_id = null, $datos) {

      if ($this->v2permisos_model->verificar_permiso('Add perfil', $this->session->userdata('user_id'))) {
        $this->form_validation->set_data($datos);
        $this->form_validation->set_rules('nombre', 'Nombre', 'required|trim');

        if (($this->form_validation->run() == FALSE)) {
          $this->jaxon_respuesta->dialog->error(validation_errors(), 'Error!');
          return $this->jaxon_respuesta;
        }

        $datos_para_grabar['nombre'] = $datos['nombre'];
        $datos_para_grabar['rol_id'] = $datos['rol_id'];
        $datos_para_grabar['pantalla_inicio_id'] = $datos['pantalla_inicio_id'];



        if (isset($perfil_id) && $perfil_id > 0) {
          $this->v2permisos_model->delete(array('perfil_id' => $perfil_id));
          if( isset($datos['items_sistema']) && is_array($datos['items_sistema']) && count($datos['items_sistema']) > 0) {
            foreach($datos['items_sistema'] as $item){
              $this->v2permisos_model->insert(array('perfil_id' => $perfil_id, 'item_id' => $item));
            }
          }
              
        
          if ($this->v2perfiles_model->update($datos_para_grabar, $perfil_id) === false) {
            $this->jaxon_respuesta->dialog->error('No se pudo grabar el perfil!', 'Error!');
            return $this->jaxon_respuesta;
          }
        } else {
          if (($perfil_id = $this->v2perfiles_model->insert($datos_para_grabar)) === false) {
            $this->jaxon_respuesta->dialog->error('No se pudo grabar el perfil!', 'Error!');
            return $this->jaxon_respuesta;
          }
        }
  
        $this->jaxon_respuesta->jquery('#perfil_crud')->modal('hide');
        $this->jaxon_respuesta->dialog->success('perfil ' . $datos['nombre'] . ' grabado!', 'Ok!');
        return $this->refresh();      
      }
  
      $this->jaxon_respuesta->dialog->error('No tiene permiso', 'Error!');
      return $this->jaxon_respuesta;
    }





    public function editar_perfil($perfil_id = null) {
      if ($this->v2permisos_model->verificar_permiso('Edit perfil', $_SESSION['user_id'])) {
        $perfil_id = $_POST['perfil_id'];
        if (isset($perfil_id) && $perfil_id) {
          $perfil = $this->v2perfiles_model->get($perfil_id);
          $this->data['perfil'] = $perfil;
          $this->data['permisos'] = $this->v2permisos_model->fields('item_id')->get_all(array('perfil_id' => $perfil_id));
          if ($this->data['permisos']) {
            $this->data['permisos'] = array_column($this->data['permisos'], 'item_id');
          }
        }

        $this->data['roles'] = $this->v2roles_model->as_dropdown('nombre')->get_all();
        $this->data['pantallas'] = $this->v2pantallas_inicio_model->as_dropdown('nombre')->get_all();
        $this->data['clases_items_sistema'] = $this->v2clase_items_sistema_model->fields(array('idclase_items_sistema', 'nombre as clase_item_sistema'))->with_items_sistema(array('fields' => 'iditems_sistema AS id, nombre'))->get_all();

        $html = $this->load->view('admin/perfiles/popup_perfil', $this->data, true);
        $respuesta = array("error" => false, "html" => $html);
        die(json_encode($respuesta));
      } else {
        die(json_encode(array("error" => true, "mensaje"=>"No tiene permiso")));
      }
    }



    public function eliminar_perfil($perfil_id) {
      if ($this->v2permisos_model->verificar_permiso('Del perfil', $_SESSION['user_id'])) {
        if (isset($perfil_id)){
          $this->v2perfiles_model->delete($perfil_id);
          $this->jaxon_respuesta->dialog->info('Remate eliminado', 'Info');
          return $this->refresh();
        } else {
          $this->jaxon_respuesta->dialog->error('No se pudo eliminar el perfil!', 'Error!');
          return $this->jaxon_respuesta;
        }
      } else {
        $this->jaxon_respuesta->dialog->error('No tiene permiso', 'Error!');
        return $this->jaxon_respuesta;
      }
    }
}

?>