<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
// use Jaxon\Jaxon; //Use the jaxon core clss
// use Jaxon\Response\Response; //and the Response class
// use Jaxon\Request\Factory as xr;
use OpenTok\OpenTok;
use OpenTok\MediaMode;
use OpenTok\ArchiveMode;

class Remate extends Admin_Controller {

    function __construct() {
        global $config;
        parent::__construct();
        $this->load->helper('url', 'form');
        $this->load->helper('remates');
        $this->load->library('form_validation');

        $this->load->model('v2empresa_model');
        $this->load->model('v2permisos_model');
        $this->load->model('v2opciones_model');
        $this->load->model('v2usuarios_model');
        $this->load->model('v2media_lotes_model');
        $this->load->model('v2lotes_model');
        $this->load->model('v2remates_model');
        $this->load->model('v2creditos_model');
        $this->load->model('v2chat_mensajes_model');

        // $this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'cambiar_lote'));

        // $this->data['refresh_method'] = xr::call('refresh', null);

        // $this->jaxon->processRequest();
        /* Title Page */

        $this->page_title->push("Remate");
        $this->data['pagetitle'] = $this->page_title->show();
        $this->data['menuitem_actual'] = "remate";
        }


    public function index() {
      if (!$this->v2permisos_model->verificar_permiso('remate', $this->session->userdata('user_id'))) {
        die('El usuario no tiene permisos');
      } else {
        if (!isset($this->data['remate_id'])) {
          $remates_en_curso = $this->v2remates_model->get_en_curso_o_proximo($_SESSION['empresa_id']);
          $this->data['remate_id'] = $remates_en_curso[0]->idremates;    
        }
        if (isset($this->data['remate_id'])) {
          $this->data['remate'] = $this->v2remates_model->get(array('idremates' => $this->data['remate_id']));;
          $fhf = date_create_from_format('Y-m-d H:i:s', $this->data['remate']->fecha_hora_final);
          if($fhf) {
            die('El remate ya estaba finalizado');
          }
          $opentok = new OpenTok($this->config->item('vonage_api_key'), $this->config->item('vonage_api_secret'));
          $this->data['lotes'] = $this->v2lotes_model->order_by('orden')->with_moneda()->get_all(array('remate_id' => $this->data['remate_id']));
          $this->data['vonage_apiKey'] = $this->config->item('vonage_api_key');
          if (isset($this->data['remate']->vonage_sessionId)) {
            $this->data['vonage_token'] = $opentok->generateToken($this->data['remate']->vonage_sessionId);
            $this->data['vonage_sessionId'] = $this->data['remate']->vonage_sessionId;
          } else {
            $session = $opentok->createSession(['mediaMode' => MediaMode::ROUTED]);
            // Store this sessionId in the database for later use
            $sessionId = $session->getSessionId();
            $this->data['vonage_token'] = $opentok->generateToken($sessionId);
            $this->v2remates_model->where(['idremates' => $this->data['remate_id']])->update(['vonage_sessionId' => $sessionId]);
            $this->data['vonage_sessionId'] = $sessionId;
          }
          if (!$this->data['lotes']) {
            die("No hay lotes definidos para este remate");
          }
          $this->template->remate_render('remate/remate/index', $this->data);
        } else {
          die("No hay un remate definido");
        }
      }
    }


    public function traer_lote() {
      $lote_id = $this->input->post('lote_id');
      /* Esteban: 17/02/21 | 13:13:55 Paso a estado "Suspendido" el lote anterior */
      if (isset($_SESSION['lote_id'])) {
        $this->v2lotes_model->where(['idlotes' => $_SESSION['lote_id']])->where('status_id', '<>', '3')->update(['status_id' => 2]);
      }
      /* Esteban: 17/02/21 | 13:13:55 Paso a estado "En curso" el lote que pido */

      $lote = $this->v2lotes_model->with_moneda()->get(['idlotes' => $lote_id]);
      $this->v2lotes_model->where(['idlotes' => $lote_id])->update(['status_id' => 4]);
      $this->session->set_userdata('lote_id', $lote_id);
      $respuesta['lote_titulo'] = isset($lote->titulo) ? $lote->titulo : "Lote #" . $lote->idlotes;
      $respuesta['lote_base'] = $lote->moneda->simbolo . " " . ($lote->base ? $lote->base : '--');
      $respuesta['lote_valor_aspirado'] = $lote->moneda->simbolo . " " . ($lote->valor_aspirado ? $lote->valor_aspirado : '--');
      $respuesta['lote_incremento'] = $lote->moneda->simbolo . " " . ($lote->step ? $lote->step : '--');
      $respuesta['lote_moneda_simbolo'] = $lote->moneda->simbolo;
      $respuesta['lote_step_nuevo'] = ($lote->step ? $lote->step : '0');
      $respuesta['lote_descripcion'] = isset($lote->descripcion) ? $lote->descripcion : "";
      $respuesta['lote_valor_actual'] = 0;
      $respuesta['lote_oferta_maxima_actual'] = '';
      $respuesta['lote_usuario_oferente_actual'] = '';
      $respuesta['lote_usuario_oferente_actual_id'] = $lote->oferente_id;

      if (($lote->status_id == 2)||($lote->status_id == 4)) { /* Esteban: 17/02/21 | 13:30:48  Si el lote estaba suspendido o en curso (caso de un refresh) */
        $respuesta['lote_valor_actual'] = isset($lote->oferta_maxima) ? $lote->oferta_maxima : 0;
        if (isset($lote->oferente_actual_id)){
          $usuario_oferente_actual = $this->v2usuarios_model->get(['id' => $lote->oferente_actual_id]);
          $respuesta['lote_oferta_maxima_actual'] = isset($lote->oferta_maxima_actual) ? $lote->oferta_maxima_actual : 0;
          $respuesta['lote_usuario_oferente_actual'] = $usuario_oferente_actual->last_name . ', ' . $usuario_oferente_actual->first_name;
          $respuesta['lote_usuario_oferente_actual_id'] = $lote->oferente_actual_id;
        }
      }

      die(json_encode($respuesta));
    }



    public function get_user_details() {
      $user_id = $this->input->post("user_id");
      $usuario = $this->v2usuarios_model->get(array("id" => $user_id));
      $nombres = explode(" ", $usuario->first_name);
      $nombre_usuario = substr($usuario->last_name . ", " . $nombres[0], 0, 15);
      $usuario->nombre_usuario = $nombre_usuario;
      $usuario->mensajes = $this->v2chat_mensajes_model->de_usuario($user_id)->order_by("timestamp", "ASC")->get_all();
      die(json_encode($usuario));
    }

    public function detalles_cliente() {
      $user_id = $this->input->post('user_id');
      $user_historial = $this->v2lotes_model->where(['oferente_id' => $user_id, 'remate_id' => $this->data['remate_id']])->get_all();
      $this->data['user_historial'] = $user_historial;

      $html = $this->load->view('remate/remate/detalles_cliente', $this->data, true);
      $respuesta = array("error" => false, "html" => $html);
      die(json_encode($respuesta));
    }


    public function editar_credito() {
      $user_id = $_POST['user_id'];
      $this->data['saldo_actual'] = $this->v2creditos_model->get_saldo($user_id, $_SESSION['empresa_id']);
      $this->data['user_id'] = $user_id;
      $html = $this->load->view('remate/remate/popup_credito', $this->data, true);
      $respuesta = array("error" => false, "html" => $html);
      die(json_encode($respuesta));
    }



    public function grabar_credito() {
      $user_id = $_POST['user_id'];
      $credito = $_POST['credito'];
      $this->data['user_id'] = $user_id;
      if (!$this->v2creditos_model->insert(['empresa_id' => $_SESSION['empresa_id'], 'user_id' => $user_id, 'valor' => $credito, 'cargado_por' => $_SESSION['user_id']])) {
        $this->jaxon_respuesta->dialog->error('Error al intentar grabar el credito', 'Error!');
        $respuesta = array("error" => true, "mensaje" => 'Error al intentar grabar el credito');
      } else {
        $respuesta = array("error" => false);
        $respuesta['saldo_actual'] = $this->v2creditos_model->get_saldo($user_id, $_SESSION['empresa_id']);
      }
      die(json_encode($respuesta));
    }








}

?>