<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
use Jaxon\Jaxon; //Use the jaxon core clss
use Jaxon\Response\Response; //and the Response class
use Jaxon\Request\Factory as xr;

class Remates extends Admin_Controller {

		function __construct() {
				global $config;
				parent::__construct();
				$this->load->helper('url', 'form');
				$this->load->helper('remates');
				$this->load->library('form_validation');
				// $this->load->library('admin/remates/remates_jaxon');

				$this->load->model('v2empresa_model');
				$this->load->model('v2permisos_model');
				$this->load->model('v2remates_model');
        $this->load->model('v2lotes_model');
				$this->load->model('v2opciones_model');

				$this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'refresh'));
				$this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'eliminar_remate'));
				$this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'grabar_remate'));
				$this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'editar_remate'));
        $this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'iniciar_remate'));

				$this->data['refresh_method'] = xr::call('refresh', null);

				$this->jaxon->processRequest();
				/* Title Page */

				$this->page_title->push("Remates");
				$this->data['pagetitle'] = $this->page_title->show();
				$this->data['menuitem_actual'] = "remates";
				}


		public function index() {
			if (!$this->v2permisos_model->verificar_permiso('Menu_item remates', $this->session->userdata('user_id'))) {
				die('El usuario no tiene permisos');
			} else {
        $this->template->admin_render('admin/remates/index', $this->data);
      }
		}


    public function refresh() {
      if ($this->v2permisos_model->verificar_permiso('Refresh remate', $_SESSION['user_id'])) {
        $this->jaxon_respuesta->jquery('#tabla_remates')->DataTable()->ajax->reload();
      } else {
        $this->jaxon_respuesta->dialog->error('No tiene permisos.', 'Error!');
      }
      return $this->jaxon_respuesta;
    }

    public function get_remates() {
      $remates_obj = $this->v2remates_model;
      
      $registros_pagina = $_POST['length'];
      
      $pagina = ($_POST['start'] / $registros_pagina) + 1;

      $ordenar = array();
      $columnas = $_POST['columns'];
      if( isset($_POST['order']) && is_array($_POST['order']) && count($_POST['order']) > 0) {
        foreach($_POST['order'] as $orden){
          if(isset($columnas[$orden['column']]['campoOrden']) && !empty($columnas[$orden['column']]['campoOrden'])) {
            $ordenar[] = array($columnas[$orden['column']]['campoOrden'] => $orden['dir']);
          } else {
            $ordenar[] = array($columnas[$orden['column']]['data'] => $orden['dir']);
          }
        }
      }
          


      $campos = array("remates.idremates", 
                      "remates.nombre", 
                      "remates.descripcion", 
                      "DATE_FORMAT(remates.fecha_hora_inicio_programado, '%d/%m/%Y %H:%i') AS fecha_hora_inicio_programado_fmt",
                      "DATE_FORMAT(remates.fecha_hora_final_programado, '%d/%m/%Y %H:%i') AS fecha_hora_final_programado_fmt",
                      "DATE_FORMAT(remates.fecha_hora_inicio, '%d/%m/%Y %H:%i') AS fecha_hora_inicio_fmt",
                      "DATE_FORMAT(remates.fecha_hora_final, '%d/%m/%Y %H:%i') AS fecha_hora_final_fmt",
                      "remates.fecha_hora_final");

      if(isset($_POST['search']) && isset($_POST['search']['value']) && !empty($_POST['search']['value'])) {
        $or = false;
        $where_ = " 1 = 1 AND (";
        foreach ($columnas as $columna) {
          if ($columna["searchable"] == 'true') {
            if ($or) { 
              $where_ .= " OR ";
            }
            $or = true;
          }
        }
        $where_ .= ") ";
      } else {
        $where_ = null;
      }
      $remates_res = $remates_obj->as_array()->fields($campos)->traer_paginados($registros_pagina, $pagina, $ordenar, $where_, $campos);
      $remates = $remates_res['result'];
      if(!isset($remates)) {
        $remates = array();
      }
      
      $registros_totales = $remates_res['total_rows'];
      if(!isset($registros_totales)) {
        $registros_totales = 0;
      }

      $registros_filtrados = $remates_res['filtered_rows'];
      if(!isset($registros_filtrados)) {
        $registros_filtrados = 0;
      }


      $permiso_modificar = $this->v2permisos_model->verificar_permiso('Edit remate', $_SESSION['user_id']);
      $permiso_borrar = $this->v2permisos_model->verificar_permiso('Del remate', $_SESSION['user_id']);  

      $resultados = array();
      if( isset($remates) && is_array($remates) && count($remates) > 0) {
        foreach($remates as &$remate){
          $this->firebug->log('$remate ---> ' . var_export($remate, true));
          $fhf = date_create_from_format('Y-m-d H:i:s', $remate['fecha_hora_final']);
          if(!$fhf) {
            $remate['play'] = '<i class="fa fa-play" title="Iniciar remate" onclick="jaxon_iniciar_remate(' . $remate['idremates'] . ')">';
          } else {
            $remate['play'] = '';
          }

          $remate['detalle'] = '<i class="fa fa-search-plus detalle-remate">';
          $remate['editar'] = ($permiso_modificar ? '<i class="fa fa-edit editar_remate">' : '-');
          $remate['borrar'] = ($permiso_borrar ? '<i class="fa fa-trash" onclick="jaxon_eliminar_remate(' . $remate['idremates'] . ')">' : '');
        }
      }
      $results = array(
        "draw" => $_POST['draw'],
        "recordsTotal" => $registros_totales,
        "recordsFiltered" => $registros_filtrados,
        "data" => $remates);

      die(json_encode($results));
    }

    public function detalles_remate() {
      $remate_id = $this->input->post('remate_id');
      if ($this->v2permisos_model->verificar_permiso('Edit remate', $_SESSION['user_id'])) {
        $remate = $this->v2remates_model->get($remate_id);
        $lotes = $this->v2lotes_model->order_by('orden')->get_all(['remate_id' => $remate_id]);
        $this->data['remate'] = $remate;
        $this->data['lotes'] = $lotes;

        $html = $this->load->view('admin/remates/detalles_remate', $this->data, true);
        $respuesta = array("error" => false, "html" => $html);
        die(json_encode($respuesta));
      } else {
        die(json_encode(array("error" => true, "mensaje"=>"No tiene permiso")));
      }
    }

		public function grabar_remate($remate_id = null, $datos) {

			if ($this->v2permisos_model->verificar_permiso('Add remate', $this->session->userdata('user_id'))) {
				$this->form_validation->set_data($datos);
				$this->form_validation->set_rules('nombre', 'Nombre', 'required|trim');

				if (($this->form_validation->run() == FALSE)) {
					$this->jaxon_respuesta->dialog->error(validation_errors(), 'Error!');
					return $this->jaxon_respuesta;
				}

				$datos_para_grabar['nombre'] = $datos['nombre'];
        $datos_para_grabar['empresa_id'] = $_SESSION['empresa_id'];
        $datos_para_grabar['descripcion'] = $datos['descripcion'];
        $this->firebug->log('$datos[fecha_hora_inicio_programado] ---> ' . var_export($datos['fecha_hora_inicio_programado'], true));
        $this->firebug->log('$date_create_from_format("d-m-Y H:i", $datos[fecha_hora_inicio_programado]) ---> ' . var_export(date_create_from_format("d/m/Y H:i", $datos['fecha_hora_inicio_programado']), true));
				if(isset($datos['fecha_hora_inicio_programado'])) {
          $datos_para_grabar['fecha_hora_inicio_programado'] = date_create_from_format("d/m/Y H:i", $datos['fecha_hora_inicio_programado'])->format('Y-m-d H:i:s');
          $this->firebug->log('$datos_para_grabar[fecha_hora_inicio_programado] ---> ' . var_export($datos_para_grabar['fecha_hora_inicio_programado'], true));
        }
        if(isset($datos['fecha_hora_final_programado'])) {
          $datos_para_grabar['fecha_hora_final_programado'] = date_create_from_format("d/m/Y H:i", $datos['fecha_hora_final_programado'])->format('Y-m-d H:i:s');
        }

        if(isset($datos['fecha_hora_inicio'])) {
          $datos_para_grabar['fecha_hora_inicio'] = date_create_from_format("d/m/Y H:i", $datos['fecha_hora_inicio'])->format('Y-m-d H:i:s');
        }
			 
				if (isset($remate_id) && $remate_id > 0) {
					if ($this->v2remates_model->update($datos_para_grabar, $remate_id) === false) {
						$this->jaxon_respuesta->dialog->error('No se pudo grabar el remate!', 'Error!');
						return $this->jaxon_respuesta;
					}
				} else {
					if (($remate_id = $this->v2remates_model->insert($datos_para_grabar)) === false) {
						$this->jaxon_respuesta->dialog->error('No se pudo grabar el remate!', 'Error!');
						return $this->jaxon_respuesta;
					}
				}
	
				$this->jaxon_respuesta->jquery('#remate_crud')->modal('hide');
        $this->jaxon_respuesta->dialog->success('remate ' . $datos['nombre'] . ' grabado!', 'Ok!');
				return $this->refresh();			
			}
	
			$this->jaxon_respuesta->dialog->error('No tiene permiso', 'Error!');
			return $this->jaxon_respuesta;
		}





		public function editar_remate($remate_id = null) {
			if ($this->v2permisos_model->verificar_permiso('Edit remate', $_SESSION['user_id'])) {
        $remate_id = $_POST['remate_id'];
        if (isset($remate_id) && $remate_id) {
  				$remate = $this->v2remates_model->get($remate_id);
          $this->firebug->log('$remate ---> ' . var_export($remate, true));
          $this->data['remate'] = $remate;
        }

        $html = $this->load->view('admin/remates/popup_remate', $this->data, true);
        $respuesta = array("error" => false, "html" => $html);
        die(json_encode($respuesta));
      } else {
        die(json_encode(array("error" => true, "mensaje"=>"No tiene permiso")));
      }
		}



		public function eliminar_remate($remate_id) {
			if ($this->v2permisos_model->verificar_permiso('Del remate', $_SESSION['user_id'])) {
				if (isset($remate_id)){
					$this->v2remates_model->delete($remate_id);
					$this->jaxon_respuesta->dialog->info('Remate eliminado', 'Info');
					return $this->refresh();
				} else {
					$this->jaxon_respuesta->dialog->error('No se pudo eliminar el remate!', 'Error!');
					return $this->jaxon_respuesta;
				}
			} else {
				$this->jaxon_respuesta->dialog->error('No tiene permiso', 'Error!');
				return $this->jaxon_respuesta;
			}
		}


    public function iniciar_remate($remate_id) {
      if ($this->v2permisos_model->verificar_permiso('remate', $_SESSION['user_id'])) {
        if (isset($remate_id)){
          $remates_en_curso = $this->v2remates_model->get_all_en_curso($_SESSION['empresa_id']);
          $permitir = false;
          if (!$remates_en_curso) {
            $permitir = true;
          }
          if ($remates_en_curso) {
            foreach($remates_en_curso as $rc){
              if ($rc->idremates == $remate_id) {
                $permitir = true;
              }
            }                
          }
          if (!$permitir) {
            /* 06-06-2022 12:05 Esteban: Esta seguridad se la quitamos */
            // $this->jaxon_respuesta->dialog->error('Ya hay un remate en curso para esta empresa', 'Error!');
            // return $this->jaxon_respuesta;
          }

          $this->v2remates_model->update(['fecha_hora_inicio' => date('Y-m-d H:i:s')], $remate_id);
          $this->session->set_userdata('remate_id', $remate_id);
          $this->jaxon_respuesta->script('window.location.href="/remate";');
          return $this->jaxon_respuesta;
        } else {
          $this->jaxon_respuesta->dialog->error('No se pudo iniciar el remate!', 'Error!');
          return $this->jaxon_respuesta;
        }
      } else {
        $this->jaxon_respuesta->dialog->error('No tiene permiso', 'Error!');
        return $this->jaxon_respuesta;
      }
    }
}

?>