<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
use Jaxon\Jaxon; //Use the jaxon core clss
use Jaxon\Response\Response; //and the Response class
use Jaxon\Request\Factory as xr;



define('ROL_COMPRADOR', 1);


class Usuarios extends Admin_Controller {

    function __construct() {
        global $config;
        parent::__construct();
        $this->load->helper('url', 'form');
        $this->load->helper('remates');
        $this->load->library('form_validation');

        $this->load->model('v2empresa_model');
        $this->load->model('v2creditos_model');
        $this->load->model('v2permisos_model');
        $this->load->model('v2opciones_model');
        $this->load->model('v2usuarios_model');
        $this->load->model('v2perfiles_model');

        $this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'refresh'));
        $this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'eliminar_usuario'));
        $this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'grabar_usuario'));
        $this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'editar_usuario'));
        $this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'perfiles_dropdown'));
        $this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'cargar_credito'));
        $this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'anular_credito'));

        $this->data['refresh_method'] = xr::call('refresh', null);

        $this->jaxon->processRequest();
        /* Title Page */

        $this->page_title->push("Usuarios");
        $this->data['pagetitle'] = $this->page_title->show();
        $this->data['menuitem_actual'] = "usuarios";
        }


    public function index() {
      if (!$this->v2permisos_model->verificar_permiso('Menu_item usuarios', $this->session->userdata('user_id'))) {
        die('El usuario no tiene permisos');
      } else {
        $this->template->admin_render('admin/usuarios/index', $this->data);
      }
    }


    public function refresh() {
      if ($this->v2permisos_model->verificar_permiso('Refresh usuario', $_SESSION['user_id'])) {
        $this->jaxon_respuesta->jquery('#tabla_usuarios')->DataTable()->ajax->reload();
      } else {
        $this->jaxon_respuesta->dialog->error('No tiene permisos.', 'Error!');
      }
      return $this->jaxon_respuesta;
    }

    public function get_usuarios() {
      $usuarios_obj = $this->v2usuarios_model;
      
      $registros_pagina = $_POST['length'];
      
      $pagina = ($_POST['start'] / $registros_pagina) + 1;

      $ordenar = array();
      $columnas = $_POST['columns'];
      if( isset($_POST['order']) && is_array($_POST['order']) && count($_POST['order']) > 0) {
        foreach($_POST['order'] as $orden){
          if(isset($columnas[$orden['column']]['campoOrden']) && !empty($columnas[$orden['column']]['campoOrden'])) {
            $ordenar[] = array($columnas[$orden['column']]['campoOrden'] => $orden['dir']);
          } else {
            $ordenar[] = array($columnas[$orden['column']]['data'] => $orden['dir']);
          }
        }
      }
          


      $campos = array("users.id", 
                      "users.first_name", 
                      "users.last_name", 
                      "users.email",
                      "users.phone",
                      "perfiles.nombre AS perfil",
                      "roles.nombre AS rol");

      if(isset($_POST['search']) && isset($_POST['search']['value']) && !empty($_POST['search']['value'])) {
        $or = false;
        $where_ = " 1 = 1 AND (";
        foreach ($columnas as $columna) {
          if ($columna["searchable"] == 'true') {
            if ($or) { 
              $where_ .= " OR ";
            }
            if ($columna["data"] == 'nombre') { /* Esteban: 21/06/18 | 15:12:04  Tengo que desambiguar porque el query hace un join con perfiles, que también tiene un campo nombre */
              $where_ .= 'LOWER(usuarios.first_name)' . " like '%" . strtolower($_POST['search']['value']) . "%' ";
            } else {
              $where_ .= "LOWER(" . $columna["data"] . ") like '%" . strtolower($_POST['search']['value']) . "%' ";
            }
            $or = true;
          }
        }
        $where_ .= ") ";
      } else {
        $where_ = null;
      }
      $usuarios_res = $usuarios_obj->as_array()->fields($campos)->traer_paginados($registros_pagina, $pagina, $ordenar, $where_, $campos);
      $usuarios = $usuarios_res['result'];
      if(!isset($usuarios)) {
        $usuarios = array();
      }

      $registros_totales = $usuarios_res['total_rows'];
      if(!isset($registros_totales)) {
        $registros_totales = 0;
      }

      $registros_filtrados = $usuarios_res['filtered_rows'];
      if(!isset($registros_filtrados)) {
        $registros_filtrados = 0;
      }


      $permiso_modificar = $this->v2permisos_model->verificar_permiso('Edit usuario', $_SESSION['user_id']);
      $permiso_borrar = $this->v2permisos_model->verificar_permiso('Del usuario', $_SESSION['user_id']);  

      $resultados = array();
      if( isset($usuarios) && is_array($usuarios) && count($usuarios) > 0) {
        foreach($usuarios as &$usuario){
          $usuario['detalle'] = '<i class="fa fa-search-plus detalle-usuario">';
          $usuario['editar'] = ($permiso_modificar ? '<i class="fa fa-edit editar_usuario">' : '-');
          $usuario['borrar'] = ($permiso_borrar ? '<i class="fa fa-trash" onclick="jaxon_eliminar_usuario(' . $usuario['id'] . ')">' : '');
        }
      }
      $results = array(
        "draw" => $_POST['draw'],
        "recordsTotal" => $registros_totales,
        "recordsFiltered" => $registros_filtrados,
        "data" => $usuarios);

      die(json_encode($results));
    }

    public function detalles_usuario() {
      $usuario_id = $this->input->post('usuario_id');
      if ($this->v2permisos_model->verificar_permiso('Edit usuario', $_SESSION['user_id'])) {
        $usuario = $this->v2usuarios_model
                            ->get($usuario_id);
        $this->data['usuario'] = $usuario;

        $perfil = $this->v2usuarios_empresas_model->with_perfil()->get(['user_id' => $usuario_id, 'empresa_id' => $_SESSION['empresa_id']]);
        $usuario->rol_id = $perfil->perfil->rol_id;
        $usuario->perfil_id= $perfil->perfil_id;
        $this->data['rol_comprador'] = ($usuario->rol_id == ROL_COMPRADOR);
        $this->data['permiso_credito'] = $this->v2permisos_model->verificar_permiso('Add credito', $_SESSION['user_id']);

        $this->data['usuario_foto'] = 'assets/images/usuarios/foto_default.jpg';
        if(isset($usuario->foto_documento) && !empty($usuario->foto_documento) && file_exists(FCPATH . $this->config->item('path_imagenes_usuarios') . $usuario->foto_documento)) {
          $this->data['usuario_foto'] = $this->config->item('path_imagenes_usuarios') . $usuario->foto_documento;
        }
        $html = $this->load->view('admin/usuarios/detalles_usuario', $this->data, true);
        $respuesta = array("error" => false, "html" => $html);
        die(json_encode($respuesta));
      } else {
        die(json_encode(array("error" => true, "mensaje"=>"No tiene permiso")));
      }
    }

    public function grabar_usuario($usuario_id = null, $datos) {

      if ($this->v2permisos_model->verificar_permiso('Add usuario', $this->session->userdata('user_id'))) {
        $this->form_validation->set_data($datos);
        $this->form_validation->set_rules('first_name', 'Nombre', 'required|trim');
        $this->form_validation->set_rules('last_name', 'Apellido', 'required|trim');
        $this->form_validation->set_rules('email', 'email', 'required|valid_email|strtolower|trim');

        if (($this->form_validation->run() == FALSE)) {
          $this->jaxon_respuesta->dialog->error(validation_errors(), 'Error!');
          return $this->jaxon_respuesta;
        }

        $datos_para_grabar['first_name'] = $datos['first_name'];
        $datos_para_grabar['last_name'] = $datos['last_name'];
        $datos_para_grabar['empresa_id'] = $_SESSION['empresa_id'];
        $datos_para_grabar['phone'] = $datos['phone'];

        if (isset($usuario_id) && $usuario_id > 0) {
          if ($this->v2usuarios_model->update($datos_para_grabar, $usuario_id) === false) {
            $this->jaxon_respuesta->dialog->error('No se pudo grabar el usuario!', 'Error!');
            return $this->jaxon_respuesta;
          }
          $this->v2usuarios_empresas_model->where(['user_id' => $usuario_id, 'empresa_id' => $_SESSION['empresa_id']])->update(['perfil_id' => $datos['perfil_id']]);
        } else {
          // if (($usuario_id = $this->v2usuarios_model->insert($datos_para_grabar)) === false) {
          //   $this->jaxon_respuesta->dialog->error('No se pudo grabar el usuario!', 'Error!');
          //   return $this->jaxon_respuesta;
          // }
        }

        $this->jaxon_respuesta->jquery('#usuario_crud')->modal('hide');
        $this->jaxon_respuesta->dialog->success('usuario ' . $datos['last_name'] . ', ' . $datos['first_name'] . ' grabado!', 'Ok!');
        return $this->refresh();      
      }
  
      $this->jaxon_respuesta->dialog->error('No tiene permiso', 'Error!');
      return $this->jaxon_respuesta;
    }





    public function editar_usuario($usuario_id = null) {
      if ($this->v2permisos_model->verificar_permiso('Edit usuario', $_SESSION['user_id'])) {
        $usuario_id = $_POST['usuario_id'];
        if (isset($usuario_id) && $usuario_id) {
          $usuario = $this->v2usuarios_model
                            ->get($usuario_id);
          $perfil = $this->v2usuarios_empresas_model->with_perfil()->get(['user_id' => $usuario_id, 'empresa_id' => $_SESSION['empresa_id']]);
          $usuario->rol_id = $perfil->perfil->rol_id;
          $usuario->perfil_id= $perfil->perfil_id;
          $this->data['usuario'] = $usuario;
        }
        $this->data['roles'] = $this->v2roles_model->as_dropdown('nombre')->get_all();
        $html = $this->load->view('admin/usuarios/popup_usuario', $this->data, true);
        $respuesta = array("error" => false, "html" => $html);
        die(json_encode($respuesta));
      } else {
        die(json_encode(array("error" => true, "mensaje"=>"No tiene permiso")));
      }
    }



    public function eliminar_usuario($usuario_id) {
      if ($this->v2permisos_model->verificar_permiso('Del usuario', $_SESSION['user_id'])) {
        if (isset($usuario_id)){
          if($this->v2usuarios_empresas_model->delete(array('user_id' => $usuario_id, 'empresa_id' => $_SESSION['empresa_id']))) {
            $this->jaxon_respuesta->dialog->info('Usuario eliminado', 'Info');
            return $this->refresh();
          } else {
            $this->jaxon_respuesta->dialog->error('No se pudo eliminar el cliente!', 'Error!');
            return $this->jaxon_respuesta;
          }
        } else {
          $this->jaxon_respuesta->dialog->error('No tiene permiso', 'Error!');
          return $this->jaxon_respuesta;
        }
      } else {
        $this->jaxon_respuesta->dialog->error('No tiene permiso', 'Error!');
        return $this->jaxon_respuesta;
      }
    }

    public function perfiles_dropdown($rol_id, $perfil_id = null) {
      $perfiles_dropdown_str = $this->v2perfiles_model->as_dropdown('nombre')->get_all(array('rol_id' => $rol_id));
      $this->jaxon_respuesta->assign('perfiles_dropdown', 'innerHTML', form_dropdown('perfil_id', $perfiles_dropdown_str, $perfil_id, 'id="perfil_id" class="form-control"'));
      return $this->jaxon_respuesta;
    }





    public function historial_creditos_usuario() {
      /* Esteban: 13/05/20 | 16:27:55  Estoy duplicando un poco de código respecto de la tabla de créditos de la pantalla de créditos, pero es que estoy trayendo otros campos y buscando por otros campos */
      $usuarios_obj = $this->v2usuarios_model;
      $user_id = $this->input->post('user_id');
      $registros_pagina = $_POST['length'];
      

      
      $registros_pagina = $_POST['length'];
      
      $pagina = ($_POST['start'] / $registros_pagina) + 1;

      $ordenar = array();
      $columnas = $_POST['columns'];
      if( isset($_POST['order']) && is_array($_POST['order']) && count($_POST['order']) > 0) {
        foreach($_POST['order'] as $orden){
          if(isset($columnas[$orden['column']]['campoOrden']) && !empty($columnas[$orden['column']]['campoOrden'])) {
            $ordenar[] = array($columnas[$orden['column']]['campoOrden'] => $orden['dir']);
          } else {
            $ordenar[] = array($columnas[$orden['column']]['data'] => $orden['dir']);
          }
        }
      }
          

      $campos = array("DATE_FORMAT(creditos.created_at, '%d/%m/%Y') as created_at_fmt", 
                      "creditos.idcreditos", 
                      "creditos.anulado", 
                      "creditos.valor",
                      "CONCAT(users.last_name, ', ', users.first_name) AS cargado_por");

      if(isset($_POST['search']) && isset($_POST['search']['value']) && !empty($_POST['search']['value'])) {
        $where_ = " 1 = 1 AND (";
        foreach ($columnas as $columna) {
          if ($columna["searchable"] == 'true') {
            $where_ .= 'LOWER(' . $columna["data"] . ") like '%" . strtolower($_POST['search']['value']) . "%' ";
            $where_ .= ") ";
          }
        }
      } else {
        $where_ = null;
      }

      $creditos_res = $usuarios_obj->as_array()->fields($campos)->traer_creditos_paginados($_SESSION['empresa_id'], $user_id, $registros_pagina, $pagina, $where_, $ordenar);
      $creditos = $creditos_res['result'];
      if(!isset($creditos)) {
        $creditos = array();
      }
      
      $registros_totales = $creditos_res['total_rows'];
      if(!isset($registros_totales)) {
        $registros_totales = 0;
      }

      $registros_filtrados = $creditos_res['filtered_rows'];
      if(!isset($registros_filtrados)) {
        $registros_filtrados = 0;
      }

      $permiso_borrar = $this->v2permisos_model->verificar_permiso('Del credito', $_SESSION['user_id']);  

      $resultados = array();
      if( isset($creditos) && is_array($creditos) && count($creditos) > 0) {
        foreach($creditos as &$credito){
          $credito['borrar'] = (($permiso_borrar && $credito['anulado'] != 1) ? '<i class="fa fa-trash" onclick="jaxon_anular_credito(' . $credito['idcreditos'] . ')">' : '');
        }
      }
      $results = array(
        "draw" => $_POST['draw'],
        "recordsTotal" => $registros_totales,
        "recordsFiltered" => $registros_filtrados,
        "data" => $creditos);

      die(json_encode($results));
    }



  public function anular_credito($credito_id) {
    if ($this->v2permisos_model->verificar_permiso('Del credito', $_SESSION['user_id'])) {
      if(intval($credito_id) > 0) {
        if (!$this->v2creditos_model->update(array('anulado' => 1), $credito_id)) {
          $this->jaxon_respuesta->dialog->error('Error al intentar anular el credito', 'Error!');
          return $this->jaxon_respuesta;
        } else {
          $this->jaxon_respuesta->dialog->success('Crédito anulado!', 'Hecho!');
          $this->jaxon_respuesta->script("$('#historial-creditos').DataTable().ajax.reload();");
          return $this->jaxon_respuesta;
        }
      } else {        
        $this->jaxon_respuesta->dialog->error('ID de crédito inválido!', 'Error!');
        return $this->jaxon_respuesta;
      }
    } else {
      $this->jaxon_respuesta->dialog->error('No tiene permiso!', 'Error!');
      return $this->jaxon_respuesta;
    }
  }

  public function cargar_credito($user_id, $valor) {
    if ($this->v2permisos_model->verificar_permiso('Add credito', $_SESSION['user_id'])) {
      sleep(1);
      $this->jaxon_respuesta->script('throb.stop()');
      if(intval($user_id) > 0) {
        if (!$this->v2creditos_model->insert(['empresa_id' => $_SESSION['empresa_id'], 'user_id' => $user_id, 'valor' => $valor, 'cargado_por' => $_SESSION['user_id']])) {
          $this->jaxon_respuesta->dialog->error('Error al intentar grabar el credito', 'Error!');
          $this->jaxon_respuesta->script('throb.stop()');
          return $this->jaxon_respuesta;
        } else {
          $this->jaxon_respuesta->dialog->success('Crédito asignado!', 'Hecho!');
          $this->jaxon_respuesta->script("$('#historial-creditos').DataTable().ajax.reload();");
          return $this->jaxon_respuesta;
        }
      } else {        
        $this->jaxon_respuesta->dialog->error('ID de usuario inválido!', 'Error!');
        return $this->jaxon_respuesta;
      }
    } else {
      $this->jaxon_respuesta->dialog->error('No tiene permiso!', 'Error!');
      return $this->jaxon_respuesta;
    }
  }




}

?>