<?php
defined('BASEPATH') OR exit('No direct script access allowed');
use Jaxon\Jaxon; //Use the jaxon core clss
use Jaxon\Response\Response; //and the Response class


class MY_Controller extends CI_Controller
{
  public $jaxon = null;
  public $jaxon_respuesta;
  public $firebug;
  public $empresa;
	public function __construct()
	{
		
        parent::__construct();

        $this->firebug = new fb();
        if(!defined('STDOUT')) define('STDOUT', fopen('php://stdout', 'wb'));

        /* COMMON :: ADMIN & PUBLIC */
        /* Load */
        $this->load->database();
        $this->load->library(array('form_validation', 'my_ion_auth', 'template', 'common/mobile_detect'));
        $this->load->model('v2empresa_model');
        $this->load->library('session');

        $this->data['empresa'] =  $this->v2empresa_model->get($this->session->userdata('empresa_id'));
        $this->empresa =  $this->v2empresa_model->get($this->session->userdata('empresa_id'));
        fwrite(STDOUT, "Empresa en MY_Controller... " . var_export($this->session->userdata('empresa_id'), 1));
        /* Data */
        $this->data['lang'] = element($this->config->item('language'), $this->config->item('language_abbr'));
        $this->data['charset'] = $this->config->item('charset');
        $this->data['frameworks_dir'] = $this->config->item('frameworks_dir');
        $this->data['plugins_dir'] = $this->config->item('plugins_dir');
        $this->data['avatar_dir'] = $this->config->item('avatar_dir');

        /* Any mobile device (phones or tablets) */
        if ($this->mobile_detect->isMobile())
        {
            $this->data['mobile'] = TRUE;

            if ($this->mobile_detect->isiOS()){
                $this->data['ios'] = TRUE;
                $this->data['android'] = FALSE;
            }
            elseif ($this->mobile_detect->isAndroidOS())
            {
                $this->data['ios'] = FALSE;
                $this->data['android'] = TRUE;
            }
            else
            {
                $this->data['ios'] = FALSE;
                $this->data['android'] = FALSE;
            }

            if ($this->mobile_detect->getBrowsers('IE')){
                $this->data['mobile_ie'] = TRUE;
            }
            else
            {
                $this->data['mobile_ie'] = FALSE;
            }
        }
        else
        {
            $this->data['mobile'] = FALSE;
            $this->data['ios'] = FALSE;
            $this->data['android'] = FALSE;
            $this->data['mobile_ie'] = FALSE;
        }
	}
}

class Comprador_Controller extends MY_Controller
{
  public function __construct()
  {
    parent::__construct();
    $this->load->model("v2remates_model");

    if (!$this->my_ion_auth->logged_in()) {
        redirect('auth/login', 'refresh');
    }


    $this->data['empresa'] =  $this->v2empresa_model->get($_SESSION['empresa_id']);
    $this->empresa =  $this->v2empresa_model->get($_SESSION['empresa_id']);
    $this->data['user'] = $this->v2usuarios_model->get($_SESSION['user_id']);
    if (!isset($this->data['remate_id'])) {
      $remates_en_curso = $this->v2remates_model->get_en_curso_o_proximo($_SESSION['empresa_id']);
      if (!$remates_en_curso) {
        $this->data['remate_id'] = 0;
        $this->data['remate_comenzado'] = false;
      } else {
        $this->data['remate_id'] = $remates_en_curso[0]->idremates;    
        $this->data['remate_comenzado'] = (isset($remates_en_curso[0]->fecha_hora_inicio) &&  ($remates_en_curso[0]->fecha_hora_inicio > 0));
      }
    }
  }
}


class Asistente_Controller extends MY_Controller
{
  public function __construct()
  {
    parent::__construct();
    $this->load->model("v2remates_model");
    if (!$this->my_ion_auth->logged_in()) {
        redirect('auth/login', 'refresh');
    }
    $this->data['empresa'] =  $this->v2empresa_model->get($_SESSION['empresa_id']);
    $this->empresa =  $this->v2empresa_model->get($_SESSION['empresa_id']);
    $this->data['user'] = $this->v2usuarios_model->get($_SESSION['user_id']);
    if (!isset($this->data['remate_id'])) {
      $remates_en_curso = $this->v2remates_model->get_en_curso_o_proximo($_SESSION['empresa_id']);
      if (!$remates_en_curso) {
        $this->data['remate_id'] = 0;
      } else {
        $this->data['remate_id'] = $remates_en_curso[0]->idremates;    
      }
    }
    $this->data['title']       = $this->config->item('title');
    $this->data['title_lg']    = $this->config->item('title_lg');
    $this->data['title_mini']  = $this->config->item('title_mini');
    $this->data['admin_prefs'] = $this->prefs_model->admin_prefs();
    $this->data['admin'] = $this->v2usuarios_model->get($_SESSION['user_id']);
    $this->data['remate'] = $this->v2remates_model->get(array('idremates' => $this->data['remate_id']));;
  }
}
class Admin_Controller extends MY_Controller
{
	public function __construct()
	{
		parent::__construct();

        if (!$this->my_ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        if( $this->my_ion_auth->is_admin()) {
          /* Load */
          $this->load->config('admin/dp_config');
          $this->load->library('admin/page_title');

          $this->load->model('v2opciones_model');
          $this->load->model('v2empresas_opciones_model');
          $this->load->helper('menu');
          $this->lang->load(array('admin/main_header', 'admin/main_sidebar', 'admin/footer', 'admin/actions'));


          /* Data */
          $this->data['title']       = $this->config->item('title');
          $this->data['title_lg']    = $this->config->item('title_lg');
          $this->data['title_mini']  = $this->config->item('title_mini');
          $this->data['admin_prefs'] = $this->prefs_model->admin_prefs();
        } else {
          die('No tiene acceso a la sección admin');
        }


    $this->jaxon = jaxon();
    $this->jaxon_respuesta = new Response();
    $this->jaxon->readPhpConfigFile(BASEPATH . '../application/config/jaxon.php');



        if ($_SESSION['cache_permisos'] == "SUPERADMIN" ) { /* Esteban: 24/04/18 | 20:30:44  Superadmin */
          $this->data['empresas'] = $this->v2empresa_model->order_by('nombre')->get_all();
          if(!isset($_SESSION['empresa_id'])) {
            $this->session->set_userdata('empresa_id', $this->data['empresas'][0]->idempresas);
          }
        }
        $this->data['empresa'] =  $this->v2empresa_model->get($_SESSION['empresa_id']);
        $this->empresa =  $this->v2empresa_model->get($_SESSION['empresa_id']);

        fwrite(STDOUT, "Empresa en Admin_Controller... " . var_export($this->session->userdata('empresa_id'), 1));

        if($_SESSION['cache_permisos'] == 'SUPERADMIN') {
          $this->data['es_superadmin'] = true;
        } else {
          $this->data['es_superadmin'] = false;
        }

        $this->data['admin'] = $this->v2usuarios_model->get($_SESSION['user_id']);

      if($_SESSION['cache_permisos'] == "SUPERADMIN") { /* Esteban: 24/04/18 | 21:52:12  Superadmin */
        $this->data['lista_empresas'] = $this->v2empresa_model->get_all();
      } else {
        if (!in_array($this->data['empresa']->idempresas, $_SESSION['empresas'])) {
          $this->session->set_flashdata('message', 'Usted no se encuentra registrado en esta empresa');
          $logout = $this->my_ion_auth->logout();     
          redirect('auth/login', 'refresh');
        }
      }
  
    $this->jaxon->register(Jaxon::USER_FUNCTION, array($this, 'cambiar_empresa'));
	}

  public function cambiar_empresa($empresa_id) {
    $this->session->set_userdata('empresa_id', $empresa_id);
    unset($_SESSION['sucursal_actual']);
    $this->jaxon_respuesta->script('location.reload(true)');
    return $this->jaxon_respuesta;
  }


}
