<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Namespaces
use Ratchet\Http\HttpServer;
use Ratchet\Server\IoServer;
use Ratchet\WebSocket\WsServer;
use Gumlet\ImageResize;

use Ratchet\ConnectionInterface;
use Ratchet\Wamp\WampServerInterface;

/**
 * @package   CodeIgniter Ratchet WebSocket Library: Main class
 * @category  Libraries
 * @author    Taki Elias <taki.elias@gmail.com>
 * @license   http://opensource.org/licenses/MIT > MIT License
 * @link      https://github.com/takielias
 *
 * CodeIgniter WebSocket library. It allows you to make powerfull realtime applications by using Ratchet Websocket technology
 */

/**
 * Inspired By
 * Ratchet Websocket Library: helper file
 * @author Romain GALLIEN <romaingallien.rg@gmail.com>
 */

class Wamp_library
{
  /**
   * CI Super Instance
   * @var array
   */
  private $CI;

	/**
	 * Default host var
	 * @var string
	 */
	public $host = null;

	/**
	 * Default host var
	 * @var string
	 */
	public $port = null;

	/**
	 * Default auth var
	 * @var bool
	 */
	public $auth = false;

	/**
	 * Default Timer Interval var
	 * @var bool
	 */
	public $timer_interval = 1;

	/**
	 * Default debug var
	 * @var bool
	 */
	public $debug = false;

	/**
	 * Auth callback informations
	 * @var array
	 */
	public $callback = array();

	/**
	 * Config vars
	 * @var array
	 */
	protected $config = array();

	/**
	 * Define allowed callbacks
	 * @var array
	 */
	protected $callback_type = array('auth', 'event', 'close', 'citimer', 'roomjoin', 'roomleave', 'roomchat', 'vimeo_uploaded');


  private $ioserver = null;
  private $wampServer = null;
  protected $loop;
  protected $timer = 'off';


  private $vimeo;
	/**
	 * Class Constructor
	 * @method __construct
	 * @param array $config Configuration
	 * @return void
	 */
	public function __construct(array $config = array())
	{
		// Load the CI instance
		$this->CI = &get_instance();

		// Load the class helper
		$this->CI->load->helper('codeigniter_websocket');
		$this->CI->load->helper('jwt');
		$this->CI->load->helper('authorization');
    

		// Define the config vars
		$this->config = (!empty($config)) ? $config : array();
    $this->vimeo = new Vimeo\Vimeo($this->CI->config->item("vimeo_client_id"), $this->CI->config->item("vimeo_client_secret"), $this->CI->config->item("vimeo_access_token"));
    // $this->vimeo = $vimeo;

		// Config file verification
		if (empty($this->config)) {
			output('fatal', 'The configuration file does not exist');
		}

		// Assign HOST value to class var
		$this->host = (!empty($this->config['wamp_server']['host'])) ? $this->config['wamp_server']['host'] : '';
    output('info', var_export($this->host, 1));

		// Assign PORT value to class var
		$this->port = (!empty($this->config['wamp_server']['port'])) ? $this->config['wamp_server']['port'] : '';

		// Assign AUTH value to class var
		$this->auth = (!empty($this->config['wamp_server']['auth'] && $this->config['wamp_server']['auth'])) ? true : false;

		// Assign DEBUG value to class var
		$this->debug = (!empty($this->config['wamp_server']['debug'] && $this->config['wamp_server']['debug'])) ? true : false;

		// Assign Timer value to class var
		$this->timer = (!empty($this->config['wamp_server']['timer_enabled'] && $this->config['wamp_server']['timer_enabled'])) ? true : false;

		// Assign Timer Interval value to class var
		$this->timer_interval = (!empty($this->config['wamp_server']['timer_interval'])) ? $this->config['wamp_server']['timer_interval'] : 1;

	}

	/**
	 * Launch the server
	 * @method run
	 * @return string
	 */
	public function start_server()
	{
    if(empty($this->ioserver)){

      // An event loop
      $this->loop  = \React\EventLoop\Factory::create();

      // An object that will handle the WampServer events through its methods
      $pusher = new Pusher(array($this,'stopServerCallback'));

      // Set up a WebSocket server to handle the websocket(for clients wanting real-time updates)
      output('info', 'Dirección: ' . $this->host . ':' .  $this->port . "\r\n");
      $webSock = new \React\Socket\Server( $this->host . ':' .  $this->port, $this->loop);
      // $webSock->listen($this->bindPort, $this->bindIp);

      // Set up a Wamp server object to handle subscriptions
      $this->wampServer = new \Ratchet\Wamp\WampServer(
          $pusher
      );

      // Set up an I/O server to handle the low level events (read/write) of a socket
      $this->ioserver = new \Ratchet\Server\IoServer(
          new \Ratchet\Http\HttpServer(
              new \Ratchet\WebSocket\WsServer(
                  $this->wampServer
              )
          ),
          $webSock,
          $this->loop
      );

      // Add a timer to server's event loop
      $this->loop->addPeriodicTimer(10, function() use ($pusher) {
      $videos_pendientes = $this->CI->v2media_lotes_model->get_all_pendientes();
      if( isset($videos_pendientes) && $videos_pendientes) {
        foreach($videos_pendientes as $video_pendiente){      
          try {
            $respuesta = $this->vimeo->request('/videos/' . $video_pendiente->video_id, null, 'GET', true, array());
            $data = array();
            $data['category'] = $video_pendiente->video_id;

            if ($respuesta['status'] == 200) {
              $data['about'] = 'transcoding_status';
              switch($respuesta['body']['transcode']['status']) {
                case 'in_progress':
                  $data['transcode_status'] = 'En proceso de transcoding... ';
                  break;
                case 'complete':
                  $data['transcode_status'] = $texto = $video_pendiente->nombre .' (' . $video_pendiente->tamanio_string . ')';
                  break;
                case 'error':
                  $data['transcode_status'] = "ERROR... ";
                  break;
              }
              $data['is_playable'] = $respuesta['body']['is_playable'];
              
              /* Esteban: 24/01/21 | 12:43:47  Grabar en la DB*/
              $this->CI->v2media_lotes_model->where(['video_id' => $video_pendiente->video_id])->update(["estado_transcoding" => $respuesta['body']['transcode']['status']]);
              

              if ($respuesta['body']['is_playable']) {
                /* Esteban: 24/01/21 | 16:37:33  Pedir el thumbnail */
                $respuesta = $this->vimeo->request('/videos/' . $video_pendiente->video_id . '/pictures', null, 'GET', true, array());
                if ($respuesta['status'] == 200) {
                  $thumbnail = $respuesta['body']['data'][0]['sizes'][3]['link_with_play_button'];

                  /* Esteban: 26/01/21 | 15:12:24  Bajar imagen y guardarla localmente */
                  $file = file_get_contents($thumbnail);
                  $nombre_file_orig = FCPATH . "/assets/images/lotes/vid_orig_" . $video_pendiente->video_id . '.jpg';
                  $myfile = fopen($nombre_file_orig, "w");
                  fwrite($myfile, $file);
                  fclose($myfile);
                  /* Esteban: 26/01/21 | 15:54:14  Cambiarle el tamaño */

                  $ancho = $this->CI->config->item('FOTOS_LOTES_ANCHO');
                  $alto = $this->CI->config->item('FOTOS_LOTES_ALTO');

                  $nombre_file_thumbnail = "/assets/images/lotes/thumbnail/" . $video_pendiente->video_id;
                  $image = new ImageResize($nombre_file_orig);
                  $image->resizeToBestFit(80, 80);
                  $image->save(FCPATH . $nombre_file_thumbnail, IMAGETYPE_PNG);
                  // output('info', var_export($thumbnailUrl = $respuesta['body']['data'][0]));
                  $this->CI->v2media_lotes_model->where(['video_id' => $video_pendiente->video_id])->update(["thumbnailUrl" => $nombre_file_thumbnail]);
                  $data['thumbnailUrl'] = $nombre_file_thumbnail ;
                } else {
                  $errores[] = $respuesta['body']["error"];
                  $data['about'] = 'errores';
                  $data['errores'] = $errores;
                }
              }

            } else {
              $errores[] = $respuesta['body']["error"];
              $data['about'] = 'errores';
              $data['errores'] = $errores;
            }
          } catch (Exception $e){
              $data['about'] = 'errores';
              $data['errores'] = $e->getMessage();
          }
          $message = json_encode($data);
          $pusher->onMessageToPush($message);
        }
      }
      });
      output('info', "Iniciando el server WAMP...");
      $this->ioserver->run();  // Equals to $loop->run();
    }
  }
}


/**
 * A class that implements the WAMP server functionality by implementing the
 * WampServerInterface.
 *
 * @author Alexandros Gougousis
 */
class Pusher implements WampServerInterface {

    protected $total_subscribers = 0;
    protected $subscribedTopics = array();


    /**
     * To be called by clients to subscribe for a topic
     *
     * @param ConnectionInterface $conn
     * @param Topic $topic
     */
    public function onSubscribe(ConnectionInterface $conn, $topic) {

        // Update the number of total subscribers
        $this->total_subscribers++;

        // Add the new subscriber to the list of this topic's subscribers
        $this->subscribedTopics[$topic->getId()] = $topic;

        // Inform the subscribers of this topic about the number of total subscribers
        $messageData = array(
            'about' => 'subscribers',
            'subscribers' => $this->total_subscribers,
            'when'     => date('H:i:s')
        );
        $topic->broadcast($messageData);

    }

    /**
     * To be called by clients to unsubscribe for a topic
     *
     * @param ConnectionInterface $conn
     * @param Topic $topic
     */
    public function onUnSubscribe(ConnectionInterface $conn, $topic) {

        // Update the number of total subscribers
        $this->total_subscribers--;

        // Inform the subscribers of this topic about the number of total subscribers
        $messageData = array(
            'about' => 'subscribers',
            'subscribers' => $this->total_subscribers,
            'when'     => date('H:i:s')
        );
        $topic->broadcast($messageData);

    }

    /**
     * Executes when a client has initiated a connection
     *
     * @param ConnectionInterface $conn
     */
    public function onOpen(ConnectionInterface $conn) {
    }

    /**
     * Executes when a client has closed its connection
     *
     * @param ConnectionInterface $conn
     */
    public function onClose(ConnectionInterface $conn) {

        foreach($this->subscribedTopics as $topic){
            if($topic->has($conn)){
                $topic->remove($conn);
                $this->onUnSubscribe($conn, $topic);
                break;
            }
        }

        if($this->total_subscribers == 0){
            $this->close();
        }

    }

    /**
     * Used when a client sends data
     *
     * @param ConnectionInterface $conn
     * @param string $id
     * @param Topic $topic
     * @param array $params
     */
    public function onCall(ConnectionInterface $conn, $id, $topic, array $params) {
        // In this application if clients send data it's because the user hacked around in console
        $conn->callError($id, $topic, 'You are not allowed to make calls')->close();
    }

    /**
     * This method will be called when a new message arrives through an established websocket.
     * So, it will be used by clients to publish messages to a topic.
     *
     * @param ConnectionInterface $conn
     * @param Topic $topic
     * @param string $payload
     * @param array $exclude
     * @param array $eligible
     */
    public function onPublish(ConnectionInterface $conn, $topic, $payload, array $exclude, array $eligible) {
        // Inform the subscribers of this topic about the published message
        $messageData = array(
            'about' => 'publishing',
            'message' => $payload,
            'when'     => date('H:i:s')
        );
        $topic->broadcast($messageData);
    }

    public function onError(ConnectionInterface $conn, \Exception $e) {
    }

    /**
     * Publish a new message to a topic's subscribers. The topic name is
     * included in the message itself. In this application, we call this method
     * periodically through the periodic timer that we have added to the loop.
     *
     * @param string $message
     */
    public function onMessageToPush($message){

        $messageData = json_decode($message, true);

        // If the lookup topic object isn't set there is no one to publish to
        if (!array_key_exists($messageData['category'], $this->subscribedTopics)) {
            return;
        }

        $topic = $this->subscribedTopics[$messageData['category']];

        // re-send the data to all the clients subscribed to that topic
        $topic->broadcast($messageData);

    }

}










/**
 * A demo wrapper class for a WAMP server based on Ratchet PHP
 *
 * The purpose of  this class is to allow us manage the starting up and
 * shutting down of the WAMP server through another PHP script.
 *
 * @author Alexandros Gougousis
 */
class LoopController {


    /**
     * Creates and activates a WAMP server
     */
    public function startServer(){

    }


}
