<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class V2lotes_model extends MY_Model
{

    public $table       = "lotes";
    public $primary_key = "idlotes";



    public function __construct()
    {
      $this->has_one['moneda'] = array('foreign_model' => 'v2monedas_model', 'foreign_key' => 'idmonedas', 'local_key' => 'moneda_id');
      $this->has_one['estado'] = array('foreign_model' => 'v2lotes_status_model', 'foreign_key' => 'idlotes_status', 'local_key' => 'status_id');
      parent::__construct();
    }


    public function traer_paginados($registros_pagina, $pagina, $orden, $where, $campos) {
    $this->_database->from('lotes');
    $this->_database->join('remates', 'remates.idremates = lotes.remate_id', "LEFT");
    $this->_database->join('monedas', 'monedas.idmonedas = lotes.moneda_id', "INNER");
    $this->_database->join('lotes_status', 'lotes_status.idlotes_status = lotes.status_id', "INNER");
    $this->_database->join('users', 'users.id = lotes.oferente_id', "LEFT");
    $this->_database->group_by('idlotes');

    $this->_database->where('remates.empresa_id', $_SESSION['empresa_id']);
    $this->_database->select('lotes.idlotes');
    $registros = $this->_database->count_all_results();
    $total_rows = $registros;

    
    $this->_database->from('lotes');
    if( isset($where) && !empty($where)) {
      $this->_database->having($where);
    }
    $this->_database->join('remates', 'remates.idremates = lotes.remate_id', "LEFT");
    $this->_database->join('monedas', 'monedas.idmonedas = lotes.moneda_id', "INNER");
    $this->_database->join('lotes_status', 'lotes_status.idlotes_status = lotes.status_id', "INNER");
    $this->_database->join('users', 'users.id = lotes.oferente_id', "LEFT");
    $this->_database->group_by('idlotes');
    $this->_database->where('remates.empresa_id', $_SESSION['empresa_id']);
    $this->_database->select($campos);
    $registros = $this->_database->count_all_results();
    $filtered_rows = $registros;


    $this->_database->limit($registros_pagina, (($pagina-1) * $registros_pagina));
    if( isset($orden) && is_array($orden) && count($orden) > 0) {
      foreach($orden as $o){
        $this->_database->order_by(key($o), $o[key($o)]);
      }
    }
    $this->_database->order_by('orden');
    if( isset($where) && !empty($where)) {
      $this->_database->having($where);
    }
    $this->_database->join('remates', 'remates.idremates = lotes.remate_id', "LEFT");
    $this->_database->join('monedas', 'monedas.idmonedas = lotes.moneda_id', "INNER");
    $this->_database->join('lotes_status', 'lotes_status.idlotes_status = lotes.status_id', "INNER");
    $this->_database->join('users', 'users.id = lotes.oferente_id', "LEFT");
    $this->_database->group_by('idlotes');
    $this->_database->where('remates.empresa_id', $_SESSION['empresa_id']);
    $this->_database->select($campos);
    $result = $this->_database->get('lotes')->result_array();
    if($result) {
      return array(
          'filtered_rows' => $filtered_rows,
          'total_rows' => $total_rows,
          'result'     => $result,
      ); // Return this back to the controller.
    } else {
        return FALSE;
    }
  }




  public function get_maxima_oferta($lote_id) {
    $this->_database->where('idlotes = ' . $lote_id);    
    $result = parent::get();
    return $result;
  }

  public function set_maxima_oferta($lote_id, $oferta_maxima_actual, $user_id) {
    $this->_database->where('idlotes = ' . $lote_id);    
    return parent::update(['oferta_maxima_actual' => $oferta_maxima_actual, 'oferente_actual_id' => $user_id]);
  }

  public function set_maxima_oferta_aceptada($lote_id, $oferta_maxima_actual, $user_id) {
    $this->_database->where('idlotes = ' . $lote_id);    
    return parent::update(['oferta_maxima' => $oferta_maxima_actual, 'oferente_id' => $user_id]);
  }










}
