<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class V2permisos_model extends MY_Model
{


	public $table = "permisos";
	public $primary_key = "idpermisos";

	public function __construct(){
		$this->has_one['item_sistema'] = array('foreign_model' => 'v2items_sistema_model', 'foreign_key' => 'iditems_sistema', 'local_key' => 'item_id');
		parent::__construct();
	}

		/* Esteban: 07/03/17 | 13:42:56  Te verifica el permiso por nombre, pero depende de que v2usuarios_model->cargar_permiso se haya ejecutado previamente para llenar el cache_permisos en la session */
		function verificar_permiso($item, $user_id) {
			if ($_SESSION['cache_permisos'] == 'SUPERADMIN') {
				return true;
			}
			if (is_array($item)) {
				foreach($item as $i) {
					if (in_array(strtolower($i), $_SESSION['cache_permisos'])) {
						return true;
					}
				}
			} else {
				if (in_array(strtolower($item), $_SESSION['cache_permisos'])) {
					return true;
				}
			}
			return false;
		}

}