<?php if (!defined('BASEPATH')) {
		exit('No direct script access allowed');
}

class V2remates_model extends MY_Model
{

		public $table       = "remates";
		public $primary_key = "idremates";



		public function __construct()
		{
				// $this->has_many_pivot['martilleros_asignados'] = array('foreign_model' => 'v2remates_martilleros_model', 'foreign_key' => 'remate_id', 'local_key' => 'idremates');
				parent::__construct();
		}


    public function traer_paginados($registros_pagina, $pagina, $orden, $where, $campos) {
    $this->_database->from('remates');
    // $this->_database->join('remates_martilleros', 'remates.idremates = remates_martilleros.remate_id', "INNER");
    // $this->_database->join('users AS martilleros_asignados', 'martilleros_asignados.id = remates_martilleros.user_id', "INNER");
    // $this->_database->join('users AS asignado_por', 'asignado_por.id = remates_martilleros.asignado_por_user_id', "INNER");
    $this->_database->group_by('idremates');
    $this->_database->where('remates.empresa_id', $_SESSION['empresa_id']);
    $this->_database->select('remates.idremates');

    $registros = $this->_database->count_all_results();
    $total_rows = $registros;

    
    $this->_database->from('remates');
    if( isset($where) && !empty($where)) {
      $this->_database->having($where);
    }
    // $this->_database->join('remates_martilleros', 'remates.idremates = remates_martilleros.remate_id', "INNER");
    // $this->_database->join('users AS martilleros_asignados', 'martilleros_asignados.id = remates_martilleros.user_id', "INNER");
    // $this->_database->join('users AS asignado_por', 'asignado_por.id = remates_martilleros.asignado_por_user_id', "INNER");
    $this->_database->group_by('idremates');
    $this->_database->where('remates.empresa_id', $_SESSION['empresa_id']);
    $this->_database->select($campos);
    $registros = $this->_database->count_all_results();
    $filtered_rows = $registros;

    $this->_database->limit($registros_pagina, (($pagina-1) * $registros_pagina));
    if( isset($orden) && is_array($orden) && count($orden) > 0) {
      foreach($orden as $o){
        $this->_database->order_by(key($o), $o[key($o)]);
      }
    }
    if( isset($where) && !empty($where)) {
      $this->_database->having($where);
    }
    // $this->_database->join('remates_martilleros', 'remates.idremates = remates_martilleros.remate_id', "INNER");
    // $this->_database->join('users AS martilleros_asignados', 'martilleros_asignados.id = remates_martilleros.user_id', "INNER");
    // $this->_database->join('users AS asignado_por', 'asignado_por.id = remates_martilleros.asignado_por_user_id', "INNER");
    $this->_database->where('remates.empresa_id', $_SESSION['empresa_id']);
    $this->_database->select($campos);
    $this->_database->group_by('idremates');
    $result = $this->_database->get('remates')->result_array();
    if($result) {
      return array(
          'filtered_rows' => $filtered_rows,
          'total_rows' => $total_rows,
          'result'     => $result,
      ); // Return this back to the controller.
    } else {
        return FALSE;
    }
  }


  public function get_all_pendientes($empresa_id) {
    $this->_database->where('fecha_hora_final');
    $this->_database->where('empresa_id', $empresa_id);
    return parent::get_all('remates');
  }

  public function get_all_en_curso($empresa_id) {
    $this->_database->where('fecha_hora_inicio IS NOT null');
    $this->_database->where('fecha_hora_final IS NULL');
    $this->_database->where('empresa_id', $empresa_id);
    $this->_database->order_by('fecha_hora_inicio', 'desc');

    return parent::get_all('remates');
  }

  public function get_en_curso_o_proximo($empresa_id) {
    $en_curso = $this->get_all_en_curso($empresa_id);
    if (!$en_curso) {
      $proxima_media_hora = new Datetime();
      $this->_database->where("fecha_hora_inicio_programado >= '" . date('Y-m-d') . " 00:00:00" . "' AND fecha_hora_inicio_programado <= '" . (date('Y-m-d H:i:s', $proxima_media_hora->getTimestamp() + 1800)) . "'"); // /* Esteban: 01/03/21 | 16:54:59  Le muestra el remate que está programado para dentro de media hora */
      $this->_database->where('fecha_hora_inicio IS null');
      $this->_database->where('fecha_hora_final IS NULL');
      $this->_database->where('empresa_id', $empresa_id);
      $this->_database->order_by('fecha_hora_inicio', 'desc');
      return parent::get_all('remates');
    } else {
      return $en_curso;
    }
  }
}
