<?php if( isset($media) && $media) : ?>
    <ul id="sortable_list" style="padding: 0;">
<?php foreach ($media as $el): ?>
<?php if ($el->tipo == 'video') {
  $enlace = $el->ruta;
  $thumbnail = $el->thumbnailUrl;
  $estado_transcoding = $el->estado_transcoding;
} else {
  $thumbnail = base_url($el->thumbnailUrl);
  $enlace = base_url($el->ruta);
}
$texto = $el->nombre .' (' . $el->tamanio_string . ')';
$nombre = $el->nombre;
?>

      <li class="list-group-item" data-media_id="<?php echo $el->media_id; ?>" >
        <div class="row row-eq-height">
          <div class="col-xs-2" style="padding:0; text-align: center;">
            <a class="thumbnail" target="_blank" href="<?php echo $enlace; ?>">
              <div class="vertical_helper_frame">
              <span class="vertical_helper"></span><img src="<?php echo ($thumbnail ? $thumbnail : 'assets/images/vimeo_coding_80x80.png'); ?>" class="galeria_multimedia_thumb">
              </div>
            </a>
          </div>
          <div class="col-xs-8">
              <p class="status_">
              <?php 
                if (isset($estado_transcoding)) {
                  switch ($estado_transcoding) {
                    case 'in_progress':
                      echo 'En proceso de transcoding... (' . date('d/m/Y H:i:s') . ')';
                      break;
                    case 'complete':
                      echo $texto . "<br />";
                      break;
                    case 'error':
                      echo '<span class="text-danger"> Error de transcoding</span><br />';
                      break; 
                  }
                } else {
                  if ($el->tipo == 'video') {
                    echo 'En proceso de transcoding... (' . date('d/m/Y H:i:s') . ')';
                  } else {
                    echo $texto . "<br />";
                  }
                } ?>
              </p>
          </div>
          <div class="col-xs-2">
            <p style="text-align: center;">
              <i class="fa fa-times-circle btn_eliminar_media" data-nombre="<?php echo isset($nombre) ? $nombre : 'in-progress'; ?>" style="font-size: 24px; color:red; cursor:pointer;" title="Eliminar elemento"></i>
            </p>
          </div>
        </div>
      </li>

<?php endforeach ?>
    </ul>
<?php endif ?>