var slideWrapper = $(".main-slider"),
  iframes = slideWrapper.find('.embed-player'),
  lazyImages = slideWrapper.find('.slide-image'),
  lazyCounter = 0;

// POST commands to YouTube or Vimeo API
function postMessageToPlayer(player, command){
  if (player == null || command == null) return;
  player.contentWindow.postMessage(JSON.stringify(command), "*");
}


// When the slide is changing
function playPauseVideo(slick, control){
  var currentSlide, startTime, player;

  currentSlide = slick.find(".slick-current");
  player = currentSlide.find("iframe").get(0);
  startTime = currentSlide.data("video-start");
  console.log(player);
  switch (control) {
    case "play":
      console.log("play");
      if ((startTime != null && startTime > 0 ) && !currentSlide.hasClass('started')) {
        currentSlide.addClass('started');
        postMessageToPlayer(player, {
          "method": "setCurrentTime",
          "value" : startTime
        });
      }
      postMessageToPlayer(player, {
        "method": "play",
        "value" : 1
      });
      break;
    case "pause":
      console.log("pause");
      postMessageToPlayer(player, {
        "method": "pause",
        "value": 1
      });
      break;
  }
}

// Resize player
function resizePlayer(iframes, ratio) {
  if (!iframes[0]) return;
  var win = $(".main-slider"),
      width = win.width(),
      playerWidth,
      height = win.height(),
      playerHeight,
      ratio = ratio || 16/9;

  iframes.each(function(){
    var current = $(this);
    if (width / ratio < height) {
      playerWidth = Math.ceil(height * ratio);
      current.width(playerWidth).height(height).css({
        left: (width - playerWidth) / 2,
         top: 0
        });
    } else {
      playerHeight = Math.ceil(width / ratio);
      current.width(width).height(playerHeight).css({
        left: 0,
        top: (height - playerHeight) / 2
      });
    }
  });
}

// DOM Ready
$(document).ready(function(){
  // Initialize
  slideWrapper.on("init", function(slick){
    slick = $(slick.currentTarget);
    setTimeout(function(){
      playPauseVideo(slick,"play");
    }, 1000);
    resizePlayer(iframes, 16/9);
  });
  slideWrapper.on("beforeChange", function(event, slick) {
    slick = $(slick.$slider);
    playPauseVideo(slick,"pause");
  });
  slideWrapper.on("afterChange", function(event, slick) {
    slick = $(slick.$slider);
    playPauseVideo(slick,"play");
  });
  slideWrapper.on("lazyLoaded", function(event, slick, image, imageSource) {
    lazyImages.addClass('show');
    slideWrapper.slick("slickPlay");
  });


  $('#main-slider').slick({
    slidesToShow: 1,
    slidesToScroll: 1,
    arrows: true,
    fade: true,
    dots: true,
    autoplay: true,
    autoplaySpeed: 1000,
    adaptiveHeight: true,
    pauseOnHover:false,
    cssEase: 'linear',
    lazyLoad: 'progressive'
  });
    

});

// Resize event
$(window).on("resize.slickVideoPlayer", function(){  
  resizePlayer(iframes, 16/9);
});










  // var video = $('#main-slider .slick-active').find('iframe').get(0).play();

  // $('#main-slider').on('afterChange', function(event, slick, currentSlide, nextSlide){
  //   $('#main-slider .slick-slide').find('video').get(0).pause();
  //   var video = $('#main-slider .slick-active').find('video').get(0).play();
  // });  


