var wampHostname = RematesCONFIG.wampHost;
var wampPort = RematesCONFIG.wampPort;
var useSecure = RematesCONFIG.secure;

var chatHost = RematesCONFIG.chatHost;
var chatPort = RematesCONFIG.chatPort;

if (useSecure) {
    var protocolScheme = 'wss://';
} else {
    var protocolScheme = 'ws://';
}

    var conn = new WebSocket(protocolScheme + chatHost + (chatPort != '' ? ':' + chatPort : ''));
    var client = {
        user_id: $("#logged_user_id").val(),
        remate_id: $("#remate_id").val(),
        empresa_id: $("#empresa_id").val(),
        rematador: $("#rematador").val(),
        type: 'socket',
        token: null,
        message: null
    };

    conn.onopen = function (e) {
        conn.send(JSON.stringify(client));
    };

    conn.onclose = function (e) {
        // window.location.href = "/asistente";
    };

    conn.onmessage = function (e) {
        var data = JSON.parse(e.data);
        switch(data.type) {
          case 'token':
            $('#token').val('JWT Token : ' + data.token);
            client.token = $('#token').val().split(': ')[1];
            client.type = 'roomjoin';
            conn.send(JSON.stringify(client));
            break;
          case 'joined_room':
            $(".side-one .row.sideBar").append(
             "<div class='row sideBar-body usuario_" + data.user_id + "' data-user_id = '" + data.user_id +"'> \
                <div class='col-sm-3 col-xs-3 sideBar-avatar'> \
                  <div class='avatar-icon'> \
                    <canvas width='49' height='49' id='avatar_" + data.user_id + "' data-nombre='" + data.usuario + "'></canvas> \
                  </div> \
                </div> \
                <div class='col-sm-9 col-xs-9 sideBar-main'> \
                  <div class='row'> \
                    <div class='col-xs-12 sideBar-name'> \
                      <span class='name-meta'>" + data.usuario + " \
                      </span> \
                    </div> \
                  </div> \
                </div> \
              </div>");
            $("#cnt_compradores").text($(".row.sideBar-body").length);
            get_avatar("avatar_" + data.user_id);
            break;
          case 'disconnect':
            console.log("Usuario %d desconectado", data.user_id);
            if ($(".sideBar-body.usuario_" + data.user_id).hasClass('active')) {
              if ($(".sideBar-body.usuario_" + data.user_id).next().length > 0) {
                $(".sideBar-body.usuario_" + data.user_id).next().click();
              } else {
                ($(".sideBar-body.usuario_" + data.user_id).prev().click());
              }
            }
            $("#cnt_compradores").text($(".row.sideBar-body").length);
            $(".sideBar-body.usuario_" + data.user_id).remove();
            break;

          case 'chat':
            if (data.message) {
              active_user = $(".sideBar-body.active").data('user_id');
              if (data.user_id == active_user) {
                var currentdate = new Date();
                html_mensaje = "<div class='row message-body'> \
                                  <div class='col-sm-12 message-main-receiver'> \
                                    <div class='receiver'> \
                                      <div class='message-text'> \
                                      " + data.message + " \
                                      </div> \
                                      <span class='message-time pull-right'> \
                                        " + pad(currentdate.getHours(), 2, "0") + ": \
                                        " + pad(currentdate.getMinutes(), 2, "0") + " \
                                      </span> \
                                    </div>\
                                  </div>\
                                </div>";
                $('#txt_mensaje').val('');
                $("#conversation").append(html_mensaje);
                $('#conversation').animate({scrollTop: $('#conversation').prop("scrollHeight")}, 500);
              } else {
                $(".sideBar-body.usuario_" + data.user_id).addClass("mensaje_nuevo");
              }
            }
            break;

          case 'ofertar':
            for (var i = 0; i < 3; i++ ) {
              $("#oferta")
                .animate( { backgroundColor: "#FF9F1A" }, 100 )
                .animate( { backgroundColor: "transparent" }, 200 );
            }

            if (data.message) {
              active_user = $(".sideBar-body.active").data('user_id');
              $("#oferente").html('<a href="#" id="link_oferente">' + data.usuario + '</a>');
              $("#oferta_actual").text(data.message);
              $("#oferta_actual_val").val(data.message);
              $("#oferente_user_id").val(data.user_id);
            }
            break;

          case 'incremento':
            valor_actual = Number($('#lote_valor_actual').val());
            incremento = Number(data.message);
            $("#lote_incremento").val(incremento);
            $("#valor_a_ofertar").html("<div style='display: inline;' class='importe'>" + $("#lote_moneda_simbolo").val() + (valor_actual + incremento) + "</div>");
            $("#lote_oferta").val(valor_actual + incremento);

            var oferta_nueva = parseInt($("#lote_oferta").val()) + parseInt($("#lote_incremento").val());
            $("#valor_a_ofertar").html("<div style='display: inline;' class='importe'>" + $("#lote_moneda_simbolo").val() + (parseInt($("#lote_oferta").val()) ) + "</div>");
            $("#lote_oferta").val(oferta_nueva);  
            break;

          case 'base':
            base = Number(data.message);
            $("#lote_base").text($("#lote_moneda_simbolo").val() + " " + data.message);
            $('#lote_valor_actual').val(base);
            incremento = Number($("#lote_incremento").val());
            valor_actual = Number($('#lote_valor_actual').val());
            $("#valor_a_ofertar").html("<div style='display: inline;' class='importe'>" + $("#lote_moneda_simbolo").val() + (valor_actual + incremento) + "</div>");
            $("#lote_oferta").val(valor_actual + incremento);

            var oferta_nueva = parseInt($("#lote_oferta").val()) + parseInt($("#lote_incremento").val());
            $("#valor_a_ofertar").html("<div style='display: inline;' class='importe'>" + $("#lote_moneda_simbolo").val() + (parseInt($("#lote_oferta").val()) ) + "</div>");
            $("#lote_oferta").val(oferta_nueva);  
            break;
    
          case 'cambio_lote':
            // console.log("data.message: ", data.message);
            $(slideWrapper).slick('slickRemove', null, null, true);
            if (data.message) {
              actualizar_lote(data.message, $("#logged_user_id").val());
            } else {
              $("#lote_id").text('');
              $("#lote_titulo").text('');
              $("#lote_base").text('');
              $("#valor_actual").html('');
              $("#valor_a_ofertar").html('');
              $("#lote_descripcion").text('');
              $("#lote_incremento").val(0);
              // $("#media_gallery").html('');
            }
            break;

          case 'oferta_aceptada':
            $("#lote_valor_actual").val(data.valor_actual);
            $("#lote_oferta").val(parseInt(data.valor_actual) + parseInt($("#lote_incremento").val()));
            $("#valor_actual").html("<div style='display: inline;' class='importe'>" + $("#lote_moneda_simbolo").val() + parseInt(data.valor_actual) + '</div>');
            $("#valor_a_ofertar").html("<div style='display: inline;' class='importe'>" + $("#lote_moneda_simbolo").val() + (parseInt(data.valor_actual) + parseInt($("#lote_incremento").val())) + '</div>');
            if (data.ganador === true) {
              $(".ganador.comprador").css('visibility', 'visible');
            } else {
              $(".ganador.comprador").css('visibility', 'hidden');
            }
            break;

          case 'credito':
            var oferta_nueva = parseInt($("#lote_oferta").val()) + parseInt($("#lote_incremento").val());
            $("#valor_a_ofertar").html("<div style='display: inline;' class='importe'>" + $("#lote_moneda_simbolo").val() + (parseInt($("#lote_oferta").val()) ) + "</div>");
            $("#lote_oferta").val(oferta_nueva);  
            break;
        }
    };





    $('#submit_mensaje').click(function () {
        client.message = $('#txt_mensaje').val();
        if(client.message == "") {
          return false;
        }
        client.token = $('#token').val().split(': ')[1];
        client.type = 'chat';
        if (client.rematador) {
          var recipient_id = $(".sideBar-body.active").data("user_id");
          if (recipient_id) {
            client.recipient_id = recipient_id;
          } else {
            return false;
          }
        }
        var currentdate = new Date();
        conn.send(JSON.stringify(client));
        html_mensaje = "<div class='row message-body'> \
                          <div class='col-sm-12 message-main-sender'> \
                            <div class='sender'> \
                              <div class='message-text'> \
                              " + $('#txt_mensaje').val() + " \
                              </div> \
                              <span class='message-time pull-right'> \
                                " + pad(currentdate.getHours(), 2, "0") + ": \
                                " + pad(currentdate.getMinutes(), 2, "0") + " \
                              </span> \
                            </div>\
                          </div>\
                        </div>";
        $('#txt_mensaje').val('');
        $("#conversation").append(html_mensaje);
        $('#conversation').animate({scrollTop: $('#conversation').prop("scrollHeight")}, 500);
    });


    $('#broadcast_mensaje').click(function () {
    toastr.warning("<button type='button' id='confirmationRevertYes' style='color: black;' class='btn clear'>Si</button>",'Seguro que desea enviar el mensaje a TODOS los usuarios presentes?',
      {
      closeButton: true,
      allowHtml: true,
      onShown: function (toast) {
          $("#confirmationRevertYes").click(function(){
            client.message = $('#txt_mensaje').val();
            if(client.message == "") {
              return false;
            }
            client.token = $('#token').val().split(': ')[1];
            client.type = 'chat';
            if (client.rematador) {
              client.recipient_id = 0;
            }
            var currentdate = new Date();
            conn.send(JSON.stringify(client));
            html_mensaje = "<div class='row message-body'> \
                              <div class='col-sm-12 message-main-sender'> \
                                <div class='sender'> \
                                  <div class='message-text'> \
                                  " + $('#txt_mensaje').val() + " \
                                  </div> \
                                  <span class='message-time pull-right'> \
                                    " + pad(currentdate.getHours(), 2, "0") + ": \
                                    " + pad(currentdate.getMinutes(), 2, "0") + " \
                                  </span> \
                                </div>\
                              </div>\
                            </div>";
            $('#txt_mensaje').val('');
            $("#conversation").append(html_mensaje);
            $('#conversation').animate({scrollTop: $('#conversation').prop("scrollHeight")}, 500);
            toastr.success("El mensaje fue enviado",'',
            {
              allowHtml: false,
            });
          });
        }
      });
    });



  function render_detalle_cliente ( user_id ) {
    var div = $('<div/>')
      // .addClass( 'loading' )
      .addClass( 'detail-slider' );
      // .text( 'Loading...' );
    $.ajax( {
      url: '/asistente/detalles_cliente',
      type: "post",
      data: {
          user_id: user_id
      },
      dataType: 'json',
      success: function ( json ) {
        if (json.error) {
          div
            .html( json.mensaje )
        } else {
          div
            .html( json.html );
          div.slideDown(400);

        }
      }
    });
    return div;
  }

function grabar_credito() {
    if ($("#credito_add").val() == 0) {
      return false;
    }
    var user_id = $(".sideBar-body.active").data('user_id');
    $.ajax( {
      url: '/asistente/grabar_credito',
      type: "post",
      data: {
          user_id: user_id,
          credito: $("#credito_add").val()
      },
      dataType: 'json',
      success: function ( json ) {
        if (json.error == false) {
          $("#credito_add_frm .modal-body").html('');
          $("#credito_add_frm").modal('hide');
          toastr.info('Crédito agregado!<br /> Crédito actual: ' + json.saldo_actual);

          client.message = json.saldo_actual;
          client.token = $('#token').val().split(': ')[1];
          client.type = 'credito';
          client.recipient_id = user_id;
          conn.send(JSON.stringify(client));
        } else {
          toastr.error('Error al agregar crédito!');
        }
      }
    });
  }


$(function(){

    $(document).on("keypress","#txt_mensaje",function(event) {
      var keyCode = event.which || event.keyCode;
      if (keyCode == 13) {
          $("#submit_mensaje").click();
          return false;
      }
    });

    $(document).on('click', ".sideBar-body", function() {
      $(".sideBar-body").removeClass('active');
      var elemento_clickeado = $(this);
      $(elemento_clickeado).removeClass("mensaje_nuevo");
      var user_id = $(this).data('user_id');
      elemento_clickeado.addClass('active');
      $.ajax( {
        url: '/asistente/get_user_details',
        data: {
          user_id: user_id,
        },
        dataType: 'json',
        type: 'POST',
        success: function (respuesta) {
          $("#nombre_interlocutor").text(respuesta.nombre_usuario);
          $("#canvas_interlocutor").attr('data-nombre', respuesta.nombre_usuario);
          get_avatar("canvas_interlocutor");

          $("#conversation").html("");
          $(respuesta.mensajes).each(function(i,e) {
            var msgdate = new Date(e.timestamp);
            if (e.user_id_from == user_id) {
              html_mensaje = "<div class='row message-body'> \
                              <div class='col-sm-12 message-main-receiver'> \
                                <div class='receiver'> \
                                  <div class='message-text'> \
                                  " + e.mensaje + " \
                                  </div> \
                                  <span class='message-time pull-right'> \
                                    " + msgdate.getDate() + "/" + (msgdate.getMonth() + 1) + " " + pad(msgdate.getHours(), 2, "0") + ": \
                                    " + pad(msgdate.getMinutes(), 2, "0") + " \
                                  </span> \
                                </div>\
                              </div>\
                            </div>";
            } else {
              html_mensaje = "<div class='row message-body'> \
                              <div class='col-sm-12 message-main-sender'> \
                                <div class='sender'> \
                                  <div class='message-text'> \
                                  " + e.mensaje + " \
                                  </div> \
                                  <span class='message-time pull-right'> \
                                    " + msgdate.getDate() + "/" + (msgdate.getMonth() + 1) + " "  + pad(msgdate.getHours(), 2, "0") + ": \
                                    " + pad(msgdate.getMinutes(), 2, "0") + " \
                                  </span> \
                                </div>\
                              </div>\
                            </div>";
            }
            $("#conversation").append(html_mensaje);
          });
          $('#conversation').animate({scrollTop: $('#conversation').prop("scrollHeight")}, 500);
          console.log($(".sideBar-body.active").length);
          if ($(".sideBar-body.active").length == 0) { 
            $("#detalle-cliente").hide();
            $("#credito-cliente").hide();
          } else {
            $("#detalle-cliente").show();
            $("#credito-cliente").show();
          }















        }
      });
    });




  $(document).on('click', '#detalle-cliente', function () {
      var user_id = $(".sideBar-body.active").data('user_id');
      if ($(this).hasClass('fa-search-plus')) {
        $(this).removeClass('fa-search-plus').addClass('fa-search-minus');
        render_detalle_cliente(user_id).insertAfter(".conversation .row.heading").show();
      } else {
        $(this).removeClass('fa-search-minus').addClass('fa-search-plus');
        $(".detail-slider").remove();
      }
      // $('div.detail-slider', row.child()).slideDown(2500, 'linear');
    });


  $(document).on('click', '#credito-cliente', function () {
    var user_id = $(".sideBar-body.active").data('user_id');
    $.ajax( {
      url: '/asistente/editar_credito',
      type: "post",
      data: {
          user_id: user_id
      },
      dataType: 'json',
      success: function ( json ) {
        $("#credito_add_frm .modal-body").html(json.html);
        $("#credito_add_frm").modal('show');
      }
    });
  });





    $(".heading-compose").click(function() {
      $(".side-two").css({
        "left": "0"
      });
    });

    $(".newMessage-back").click(function() {
      $(".side-two").css({
        "left": "-100%"
      });
    });


  $(document).on('keypress', '#credito_add', function(e) {
    if(e.key === "Enter") {
      grabar_credito();
      $("#credito_add_frm").modal('hide');
      return false;
    }
  });
  // $(".avatar-icon, .heading-avatar-icon").each(function(i, e) {
  //   get_avatar($(e).find("canvas").prop("id"));
  // });
}) 























































/* Esteban: 22/12/20 | 08:39:19  https://codepen.io/leecrossley/pen/CBHca */

function get_avatar(canvas_id) {
  console.log("canvas_id", canvas_id);
  elemento_canvas = document.getElementById(canvas_id);
  var nombre = $("#" + canvas_id).data('nombre');
  console.log("nombre", nombre);
  var colours = ["#1abc9c", "#2ecc71", "#3498db", "#9b59b6", "#34495e", "#16a085", "#27ae60", "#2980b9", "#8e44ad", "#2c3e50", "#f1c40f", "#e67e22", "#e74c3c", "#95a5a6", "#f39c12", "#d35400", "#c0392b", "#bdc3c7", "#7f8c8d"];

  var nameSplit = nombre.split(" "),
      initials = nameSplit[0].charAt(0).toUpperCase() + "" + nameSplit[1].charAt(0).toUpperCase();

  var charIndex = initials.charCodeAt(0) - 65,
      colourIndex = charIndex % 19;

  var context = elemento_canvas.getContext("2d");

  var canvasWidth = $(elemento_canvas).attr("width"),
      canvasHeight = $(elemento_canvas).attr("height"),
      canvasCssWidth = canvasWidth,
      canvasCssHeight = canvasHeight,
      fontSize = (canvasWidth < canvasHeight ? canvasWidth : canvasHeight) * .5;

  if (window.devicePixelRatio) {
      $(elemento_canvas).attr("width", canvasWidth * window.devicePixelRatio);
      $(elemento_canvas).attr("height", canvasHeight * window.devicePixelRatio);
      $(elemento_canvas).css("width", canvasCssWidth);
      $(elemento_canvas).css("height", canvasCssHeight);
      $(elemento_canvas).css("border-radius", "50%");
      context.scale(window.devicePixelRatio, window.devicePixelRatio);
  }

  context.fillStyle = colours[colourIndex];
  context.fillRect (0, 0, elemento_canvas.width, elemento_canvas.height);
  context.font = fontSize + "px Arial";
  context.textAlign = "center";
  // context.textBaseline = "middle";
  context.fillStyle = "#FFF";
  context.fillText(initials, canvasCssWidth / 2, canvasCssHeight / 1.5);
}


function pad(n, width, z) {
  z = z || '0';
  n = n + '';
  return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
}