var wampHostname = RematesCONFIG.wampHost;
var wampPort = RematesCONFIG.wampPort;
var useSecure = RematesCONFIG.secure;

var chatHost = RematesCONFIG.chatHost;
var chatPort = RematesCONFIG.chatPort;

if (useSecure) {
    var protocolScheme = 'wss://';
} else {
    var protocolScheme = 'ws://';
}

var form_validator;

var conn = new WebSocket(protocolScheme + chatHost + (chatPort != '' ? ':' + chatPort : ''));
var client = {
    user_id: $("#logged_user_id").val(),
    remate_id: null,
    empresa_id: null,
    rematador: null,
    type: 'socket',
    token: null,
    message: null
};
conn.onopen = function (e) {
    conn.send(JSON.stringify(client));
};

conn.onmessage = function (e) {
    var data = JSON.parse(e.data);
    if (data.type === 'token') {
      client.token = data.token;
    }

    switch(data.type) {
      case 'vimeo_transcoding':
        console.log("vimeo_transcoding");
        break;

    }
  }


function cancelar_lote(){
	return false;
}


function grabar_lote(){
	if($("#frm_datos").valid()) {
		var datos = new Object();
		datos = {
			nombre: $("#nombre").val(),
			descripcion: $("#descripcion").val(),
      orden: $("#orden").val(),
			base: $("#base").val(),
      valor_aspirado: $("#valor_aspirado").val(),
      moneda_id: $("#moneda_id").val(),
      step: $("#step").val(),
      status_id: $("#status_id").val(),
      remate_id: $("#remate_id").val(),
		}
		jaxon_grabar_lote($("#lote_id").val(), datos);
	} else {
		form_validator.focusInvalid();
	}
}









	function render_detalle_lote ( lote_id ) {
		var div = $('<div/>')
			// .addClass( 'loading' )
			.addClass( 'detail-slider' );
			// .text( 'Loading...' );
		$.ajax( {
			url: '/lotes/detalles_lote',
			type: "post",
			data: {
					lote_id: lote_id
			},
			dataType: 'json',
			success: function ( json ) {
				if (json.error) {
					div
						.html( json.mensaje )
				} else {
					div
						.html( json.html );
					div.slideDown(400);

				}
			}
		});
		return div;
	}





jQuery(document).ready(function($){



var tabla_lotes = $('#tabla_lotes').DataTable({
		"processing": true,
		"serverSide": true,
		"responsive": true,
		"autoWidth": false,
		"deferLoading": 0,
		"lengthChange": false,
		"order": [[0, "asc"]],
		"mark": {element: 'marca'},
		"language": {
			"url": "/assets/plugins/datatables.net/es_es.json"
		},
		"ajax": {
				url :"lotes/get_lotes", // json datasource
				type: "post",  // type of method  , by default would be get
				error: function(){  // error handling code
					$("#tabla_lotes_processing").css("display","none");
				}
			},
			"createdRow": function( row, data, dataIndex){
				$(row).attr('data-lote_id', data['idlotes']);
			},
			"fnServerParams": function ( aoData ) {
					var data_columna = [];
					$.each(tabla_lotes.columns().header(), function(i, e) {
						data_columna[i] = $(e).data();
					});
					$(aoData.columns).each(function (i, e) {
						e.campoOrden = data_columna[i].campoOrden;
					});
					// aoData.push( { "name": "campoFecha", "value": this } );
			}
	});


  // $(document).on('click', '#wamp', function () {
  //   $.ajax({
  //     url: '/lotes/arrancar_server_wamp',
  //     type: "post",
  //     data: {
  //     },
  //     dataType: 'json',
  //     success: function ( data ) {
  //       connectToService(data.video_id);
  //     },
  //     error: function (jqXHR, textStatus, errorThrown) {
  //       console.log(data.details);
  //     }
  //   });
  // });


  $(document).on('click', '.detalle-lote', function () {
		var tr = $(this).closest('tr');
		var row = tabla_lotes.row( tr );
		if ($(this).parents('table tr').hasClass('shown')) {
			$(this).removeClass('fa-search-minus').addClass('fa-search-plus');
			$('div.detail-slider', row.child()).slideUp( function () {
				row.child.hide();
				tr.removeClass('shown');
			} );
			// if ($.fn.dataTable.isDataTable("#historial-creditos")) {
				// tabla_lote_creditos.destroy();
			// }
			// if ($.fn.dataTable.isDataTable("#historial-reservas")) {
				// tabla_lote_reservas.destroy();
			// }    
		} else {
			$(this).parents('table').find('tr').removeClass('shown');
			tabla_lotes.rows().every( function ( rowIdx, tableLoop, rowLoop ) {
				this.child.hide();
			} );
			$(this).parents('table').find('tr .detalle-lote').removeClass('fa-search-minus').addClass('fa-search-plus');
			$(this).removeClass('fa-search-plus').addClass('fa-search-minus');
			tr.addClass('shown');    
			row.child( render_detalle_lote(tr.data('lote_id')), "tr_detalle_lote" ).show();
			// $('div.detail-slider', row.child()).slideDown(2500, 'linear');
		}
	});

});





function init_sortable() {
  console.log("init_sortable");
  $('#sortable_list').sortable({
    update: function(event, ui) {
      console.log("Update");
      var orden_objetos=[];
      $("li.ui-sortable-handle").each(function(i, e) {
        console.log($(e).attr("data-media_id"));
        orden_objetos.push($(e).attr("data-media_id"));
      });
      $.ajax({
        url: '/lotes/grabar_orden_media',
        data: {
          orden_objetos: orden_objetos,
        },
        dataType: 'json',
        type: 'POST',
        // success: function (respuesta) {
        // }
      });
    }
  });
}







function connectToService(video_id) {

  var wamp_conn; // The websocket wamp_connection variable
  console.log(video_id);

  var onOpenWebsocketCallback = function () {
    // Subscribe for 'newsTopic' topic. We pass a callback function
    // to be executed when a message is broadcasted to this websocket
    wamp_conn.subscribe(video_id, function (topic, data) {
      // Check the message content to see what this message is about
      if (data.about == 'transcoding_status') {
        $('ul li.list-group-item[data-media_id="' + "VID#" + video_id + '"]').find('p.status_').text(data.transcode_status);
        $('ul li.list-group-item[data-media_id="' + "VID#" + video_id + '"]').find('p.status_').append("<span> (" + moment(new Date()).format("DD/MM/YYYY HH:mm:ss") + ")</span>");
        if (data.is_playable) {
          if (data.thumbnailUrl !== undefined) {
            console.log(".thumbnailUrl", data.thumbnailUrl);
            $('ul li.list-group-item[data-media_id="' + "VID#" + video_id + '"]').find('img').attr('src', data.thumbnailUrl);
          }
          $('ul li.list-group-item[data-media_id="' + "VID#" + video_id + '"]').find('p.status_').append('<i class="fa fa-check" style="color: green;"></i>');
        }
      } else if (data.about == 'errores') {
        $('ul li.list-group-item[data-media_id="' + "VID#" + video_id + '"]').find('p.status_').text(data.errores);
        $('ul li.list-group-item[data-media_id="' + "VID#" + video_id + '"]').find('p.status_').append("<span> (" + moment(new Date()).format("DD/MM/YYYY HH:mm:ss") + ")</span>");
      } else {
          console.log('New post for "' + topic + '" (' + data.when + '): ' + data.subscribers);
      }
    });

  }

  var onCloseWebsocketCallback = function () {
      console.warn('WebSocket wamp_connection closed');
  };

  // We open a websocket to service's <IP>:<port> and when the wamp_connection
  // is established we subscribe through the callback function
  var wamp_conn = new ab.Session(protocolScheme + wampHostname + (wampPort != '' ? ':' + wampPort : ''),
      onOpenWebsocketCallback,
      onCloseWebsocketCallback,
      {'skipSubprotocolCheck': true, 'verify_peer': false}
  );
}
