var form_validator;
toastr.options = {
  "debug": false,
  "positionClass": "toast-bottom-full-width",
  "onclick": null,
  "fadeIn": 300,
  "fadeOut": 1000,
  "timeOut": 5000,
  "extendedTimeOut": 1000
}

var actualizar_lote = function (callback) {
    $.ajax( {
      url: '/remate/traer_lote',
      type: "post",
      data: {
        lote_id: $("select#lote_rematado_id").val()
      },
      dataType: 'json',
      success: function ( json ) {
        $("#lote_titulo").text(json.lote_titulo);
        $("#lote_base").text(json.lote_base);
        $("#lote_valor_aspirado").text(json.lote_valor_aspirado);
        $("#lote_incremento").text(json.lote_incremento);
        $("#lote_moneda_simbolo").val(json.lote_moneda_simbolo);
        $("#lote_step_nuevo").text(json.lote_step_nuevo);
        $("#lote_descripcion").text(json.lote_descripcion);
        $("#oferente").html('<a href="#" id="link_oferente">' + json.lote_usuario_oferente_actual + '</a>');
        $("#oferta_actual").text(json.lote_oferta_maxima_actual);
        $("#valor_actual").text(json.lote_valor_actual);
        $("#oferta_actual_val").val(json.lote_oferta_maxima_actual);
        $("#oferente_user_id").val(json.lote_usuario_oferente_actual_id);
        client.message = $("select#lote_rematado_id").val();
        client.token = $('#token').val().split(': ')[1];
        client.type = 'cambio_lote';
        conn.send(JSON.stringify(client));
      }
    });
  }

jQuery(document).ready(function($){

    $(document).on("keypress","#lote_step_nuevo",function(event) {

      var keyCode = event.which || event.keyCode;
      var step = Number($("#lote_step_nuevo").val());

      if (keyCode == 13) {
        if (Number.isNaN(step)) {
          $("#lote_step_nuevo").addClass("error");
        } else {
          $("#lote_incremento").text($("#lote_moneda_simbolo").val() + " " + step);
          $("#lote_step_nuevo").removeClass("error");

          client.message = step;
          client.lote_id = $("select#lote_rematado_id").val();
          client.token = $('#token').val().split(': ')[1];
          client.type = 'incremento';

          conn.send(JSON.stringify(client));
          $('#lote_step_nuevo').val('');
        }
        return false;
      }

    });

    $(document).on("keypress","#lote_base_nuevo",function(event) {

      var keyCode = event.which || event.keyCode;
      var base = Number($("#lote_base_nuevo").val());

      if (keyCode == 13) {
        if (Number.isNaN(base)) {
          $("#lote_base_nuevo").addClass("error");
        } else {
          $("#lote_base").text($("#lote_moneda_simbolo").val() + " " + base);
          $("#lote_base_nuevo").removeClass("error");

          client.message = base;
          client.lote_id = $("select#lote_rematado_id").val();
          client.token = $('#token').val().split(': ')[1];
          client.type = 'base';

          conn.send(JSON.stringify(client));
          $('#lote_base_nuevo').val('');
        }
        return false;
      }

    });

    $("span#iniciar_lote i").addClass("lote_no_iniciado");

    $("#lote_rematado_id").on('change', function() {
      $("span#iniciar_lote i").addClass("lote_no_iniciado");
    });

    $(document).on("click","#iniciar_lote", function() {
      $("span#iniciar_lote i").removeClass("lote_no_iniciado");
      actualizar_lote();
    });
    





    $('#btn-aceptar_oferta').click(function () {
      client.token = $('#token').val().split(': ')[1];
      client.type = 'oferta_aceptada';
      conn.send(JSON.stringify(client));
    });


    $('#btn-finalizar_lote').click(function () {
      client.token = $('#token').val().split(': ')[1];
      client.type = 'lote_finalizado';
      client.message = $("#lote_rematado_id").val();
      conn.send(JSON.stringify(client));
      $("#lote_rematado_id").find('option[value="' + $("#lote_rematado_id").val() + '"]').addClass('lote_finalizado');
      if ($("#lote_rematado_id option").not(".lote_finalizado").length == 1) { /* Esteban: 17/02/21 | 16:20:55  Es el último lote */
        toastr.error('Último lote!');
      } else if($("#lote_rematado_id option").not(".lote_finalizado").length == 0) {
        $(".botonera_lote").hide();
        $("#boton_fin_remate").show();
      }
      $("span#iniciar_lote i").addClass("lote_no_iniciado");
    });


    $('#btn-finalizar_remate').click(function () {
      client.token = $('#token').val().split(': ')[1];
      client.type = 'remate_finalizado';
      client.message = $("#remate_id").val();
      conn.send(JSON.stringify(client));
      window.location.href="/remates";
    });



        
});
