var form_validator;

function cancelar_remate(){
	return false;
}

function grabar_remate(){
	if($("#frm_datos").valid()) {
		var datos = new Object();
		datos = {
			nombre: $("#nombre").val(),
			descripcion: $("#descripcion").val(),
			fecha_hora_inicio_programado: $("#edit_fecha_hora_inicio_programado").val(),
			fecha_hora_final_programado: $("#edit_fecha_hora_final_programado").val(),
		}
		jaxon_grabar_remate($("#remate_id").val(), datos);
	} else {
		form_validator.focusInvalid();
	}
}









	function render_detalle_remate ( remate_id ) {
		var div = $('<div/>')
			// .addClass( 'loading' )
			.addClass( 'detail-slider' );
			// .text( 'Loading...' );
		$.ajax( {
			url: '/remates/detalles_remate',
			type: "post",
			data: {
					remate_id: remate_id
			},
			dataType: 'json',
			success: function ( json ) {
	 			if (json.error) {
					div
						.html( json.mensaje )
				} else {
					div
						.html( json.html );
					div.slideDown(400);

				}
			}
		});
		return div;
	}





jQuery(document).ready(function($){




var tabla_remates = $('#tabla_remates').DataTable({
		"processing": true,
		"serverSide": true,
		"responsive": true,
		"autoWidth": false,
		"deferLoading": 0,
		"lengthChange": false,
		"order": [[1, "asc"]],
		"mark": {element: 'marca'},
		"language": {
			"url": "/assets/plugins/datatables.net/es_es.json"
		},
		"ajax": {
				url :"remates/get_remates", // json datasource
				type: "post",  // type of method  , by default would be get
				error: function(){  // error handling code
					$("#tabla_remates_processing").css("display","none");
				}
			},
			"createdRow": function( row, data, dataIndex){
				$(row).attr('data-remate_id', data['idremates']);
			},
			"fnServerParams": function ( aoData ) {
					var data_columna = [];
					$.each(tabla_remates.columns().header(), function(i, e) {
						data_columna[i] = $(e).data();
					});
					$(aoData.columns).each(function (i, e) {
						e.campoOrden = data_columna[i].campoOrden;
					});
					// aoData.push( { "name": "campoFecha", "value": this } );
			}
	});


	$(document).on('click', '.detalle-remate', function () {
		var tr = $(this).closest('tr');
		var row = tabla_remates.row( tr );
		if ($(this).parents('table tr').hasClass('shown')) {
			$(this).removeClass('fa-search-minus').addClass('fa-search-plus');
			$('div.detail-slider', row.child()).slideUp( function () {
				row.child.hide();
				tr.removeClass('shown');
			} );
			// if ($.fn.dataTable.isDataTable("#historial-creditos")) {
				// tabla_remate_creditos.destroy();
			// }
			// if ($.fn.dataTable.isDataTable("#historial-reservas")) {
				// tabla_remate_reservas.destroy();
			// }    
		} else {
			$(this).parents('table').find('tr').removeClass('shown');
			tabla_remates.rows().every( function ( rowIdx, tableLoop, rowLoop ) {
				this.child.hide();
			} );
			$(this).parents('table').find('tr .detalle-remate').removeClass('fa-search-minus').addClass('fa-search-plus');
			$(this).removeClass('fa-search-plus').addClass('fa-search-minus');
			tr.addClass('shown');    
			row.child( render_detalle_remate(tr.data('remate_id')), "tr_detalle_remate" ).show();
			// $('div.detail-slider', row.child()).slideDown(2500, 'linear');
		}
	});



	$(document).on('click', "#btn_nuevo, .editar_remate", function() {
		var remate_id;
		if ($(this).hasClass("editar_remate")) {
			remate_id = $(this).parents("tr").data("remate_id");
		} else {
			remate_id = null
		}
    console.log(remate_id);
		$.ajax( {
			url: '/remates/editar_remate',
			type: "post",
			data: {
				remate_id: remate_id
			},
			dataType: 'json',
			success: function ( json ) {
				if (json.error) {
					$("#remate_crud .modal-body").html( json.mensaje );
				} else {
					$("#remate_crud .modal-body").html( json.html );
					$("#remate_crud .modal-body").find("input[type='checkbox']").bootstrapToggle();
				
					$('.datetimepicker').datetimepicker({
						locale: 'es'
					});


					form_validator = $("#frm_datos").validate({
							errorPlacement: function(label, element) {
								label.addClass('error_form');
								label.insertAfter(element);
							},
							focusInvalid: true,

							rules: {
								nombre: {required : true},
							},
						});


				}
				$("#remate_crud").modal('show');
			}
		});		
	});
});