var medidor;
var upload;
var opts = {
  angle: 0.5, // The span of the gauge arc
  lineWidth: 0.1, // The line thickness
  radiusScale: 1, // Relative radius
  pointer: {
    length: 0.6, // // Relative to gauge radius
    strokeWidth: 0.035, // The thickness
    color: '#000000' // Fill color
  },
  limitMax: false,     // If false, max value increases automatically if value > maxValue
  limitMin: false,     // If true, the min value of the gauge will be fixed
  colorStart: '#6F6EA0',   // Colors
  colorStop: '#8FC0DA',    // just experiment with them
  strokeColor: '#E0E0E0',  // to see which ones work best for you
  generateGradient: true,
  highDpiSupport: true,     // High resolution support
  
};

// Open a dialog box to the user where they can select whether they want to resume an upload
// or instead create a new one.
function askToResumeUpload(previousUploads) {
  if (previousUploads.length === 0) return null;

  var text = "You tried to upload this file previously at these times:\n\n";
  console.log(text);
  previousUploads.forEach((previousUpload, index) => {
    text += "[" + index + "] " + previousUpload.creationTime + "\n";
  });
  text += "\nEnter the corresponding number to resume an upload or press Cancel to start a new upload";
  console.log(text);
  var answer = prompt(text);
  var index = parseInt(answer, 10);

  if (!isNaN(index) && previousUploads[index]) {
    return previousUploads[index];
  }
}



function format_size(bytes) {
  if (typeof bytes !== 'number') {
      return '';
  }
  if (bytes >= 1000000000) {
      return (bytes / 1000000000).toFixed(2) + ' GB';
  }
  if (bytes >= 1000000) {
      return (bytes / 1000000).toFixed(2) + ' MB';
  }
  return (bytes / 1000).toFixed(2) + ' KB';
}



function render_percent(gauge) {
   percentage = gauge.displayedValue / gauge.maxValue
   this.el.innerHTML = (percentage * 100).toFixed(0) + "%"  
}

var throb = Throbber({
    color: 'blue',
    padding: 10,
    size: 20,
    fade: 200,
    clockwise: false
    });

jQuery(document).ready(function($){

  $(document).on('click', '.btn_eliminar_media', function () {
    conn.send($(this).data('nombre'));
    console.log("Enviando ", $(this).data('nombre'));
  });


  $(document).on('click', "#btn_nuevo, .editar_lote", function() {
    var lote_id;
    if ($(this).hasClass("editar_lote")) {
      lote_id = $(this).parents("tr").data("lote_id");
    } else {
      lote_id = null
    }
    $.ajax( {
      url: '/lotes/editar_lote',
      type: "post",
      data: {
        lote_id: lote_id
      },
      dataType: 'json',
      success: function ( json ) {
        if (json.error) {
          $("#lote_crud .modal-body").html( json.mensaje );
        } else {
          $("#lote_crud .modal-body").html( json.html );
          $("#lote_crud .modal-body").find("input[type='checkbox']").bootstrapToggle();
        
          form_validator = $("#frm_datos").validate({
              errorPlacement: function(label, element) {
                label.addClass('error_form');
                label.insertAfter(element);
              },
              focusInvalid: true,

              rules: {
                nombre: {required : true},
              },
            });


        }
        $("#lote_crud").modal('show');

        setup_file_upload();

        if (lote_id > 0) {
          $.post( "/lotes/refresh_galeria", 
            {lote_id : lote_id},
            function (data) {
              $("#galeria_multimedia").html($.parseJSON(data));
              $("#galeria_container").show();
              $('.sortable_list').sortable().disableSelection();
            });
        } else {
          $("#galeria_container").hide();
        }
      }
    });   
  });

});


function setup_file_upload () {

  $('#upload').fileupload({
    url: 'lotes/upload_imagen',
    dataType: 'json',
    autoUpload: false,
    disableImageResize: true
  })
  .on('fileuploadadd', function (e, data) {
    console.log("fileuploadadd");
    throb.appendTo( document.getElementById( 'lbl_galeria' ) );
    throb.start();

    var file_cliente = data.files[0];
    if( data.files[0].type == 'image/png' ||
      data.files[0].type == 'image/gif' ||
      data.files[0].type == 'image/jpg' ||
      data.files[0].type == 'image/jpeg' ||
      data.files[0].type == 'image/png') {
      data.submit();

    } else {
      console.log("Vimeo");
      upload = new tus.Upload(file_cliente, {
        retryDelays: [0, 1000, 3000, 5000, 20000],
        onError: function(error) {
          $("#status_" + data.video_id).text("Transferencia fallida: " + error);
        },
        // Callback for reporting upload progress
        onProgress: function(bytesUploaded, bytesTotal) {
            var percentage = (bytesUploaded / bytesTotal * 100).toFixed(0);
            console.log("percentage", percentage);
            // console.log("data.video_id", data.video_id);
            // medidor.set(percentage);
            // $("#status_" + data.video_id).text("Transfiriendo...");
        },
        onAfterResponse: function (req, res) {
          if (req._xhr.status == 200 && req._method == 'POST' && req._url == "/lotes/upload_vimeo") {
            respuesta = JSON.parse(req._xhr.response);
            $("#galeria_multimedia ul").prepend(respuesta.slot);
            var canvas_medidor = document.getElementById("canvas_");
            medidor = new Donut(canvas_medidor).setOptions(opts);
            medidor.maxValue = 100;
            medidor.setMinValue(0);
            medidor.animationSpeed = 70;
            medidor.set(0);
            var textRenderer = new TextRenderer(document.getElementById("texto_" + respuesta.video_id))
            textRenderer.render = render_percent;
            medidor.setTextField(textRenderer);
            $("#status_" + respuesta.video_id).text("Iniciando transferencia...");
            
          }
        },
        onSuccess: function() {
          $("#status_" + data.video_id).text("Codificando...");
          $.ajax({
            url: "/lotes/insert_media",
            method: "POST",
            context: document.body,
            data:{
              lote_id: $("#lote_id").val(),
              nombre: upload.file.name,
              tamanio : upload.file.size,
              ruta: data.ruta,
              thumbnail: data.thumbnail_1
            },
            success: function(respuesta) {
              console.log("post success: ", respuesta);
              $("#galeria_multimedia").html($.parseJSON(respuesta));
              $("#galeria_container").show();
              $('.sortable_list').sortable().disableSelection();
            }
          });

          console.log("after");
        },
        // _onUploadUrlAvailable: function(data) {
        // }
      });

      throb.stop();
      // $(document).on("click", ".media_upload_pausa", function(){
      //   $btn_pausa = $(this);
      //   upload.abort().then(function() {
      //     $btn_pausa.removeClass("fa-pause").addClass("fa-play");
      //     $btn_pausa.removeClass("media_upload_pausa").addClass("media_upload_reanudar");
      //   });
      // });

      // $(document).on("click", ".media_upload_reanudar", function(){
      //   $btn_pausa = $(this);
      //   console.log($btn_pausa.data('video_id'));
      //   $btn_pausa.removeClass("fa-pause").addClass("fa-play");
      //   $btn_pausa.removeClass("media_upload_pausa").addClass("media_upload_reanudar");
      // });


      // upload.findPreviousUploads().then((previousUploads) => {
          // previousUploads is an array containing details about the previously started uploads.
          // The objects in the array have following properties:
          // - size: The upload's size in bytes
          // - metadata: The metadata associated with the upload during its creation
          // - creationTime: The timestamp when the upload was created
          // We ask the end user if they want to resume one of those uploads or start a new one.


          // var chosenUpload = askToResumeUpload(previousUploads);

          // If an upload has been chosen to be resumed, instruct the upload object to do so.
          // if(chosenUpload) {
          //     upload.resumeFromPreviousUpload(chosenUpload);
          // }

          // Finally start the upload requests.
          // upload.start();
      // });
      // upload.findPreviousUploads().then((previousUploads) => {
      //   if (previousUploads.length > 0) {
      //     upload.resumeFromPreviousUpload(previousUploads[0])
      //   }
      //   console.log("Upload Start()");
      //   upload.start()
      // });
      upload.options.endpoint = "/lotes/upload_vimeo";
      upload.start();

    }
  })

  .on('fileuploaddone', function (e, data) {
    throb.stop();
    if (data.result.error !== undefined) {
      alert(data.result.error);
    } else {
      $("#galeria_multimedia").html(data.result.html);
      $('.sortable_list').sortable().disableSelection();
    }
  });



$('#upload').bind('fileuploadsubmit', function (e, data) {
    data.formData = {lote_id: $('#lote_id').val()};
  });


};




