<?php
defined('BASEPATH') OR exit('No direct script access allowed');

// Namespaces
use Ratchet\Http\HttpServer;
use Ratchet\Server\IoServer;
use Ratchet\WebSocket\WsServer;
use Ratchet\ConnectionInterface;
use Ratchet\MessageComponentInterface;

/**
 * @package   CodeIgniter Ratchet WebSocket Library: Main class
 * @category  Libraries
 * @author    Taki Elias <taki.elias@gmail.com>
 * @license   http://opensource.org/licenses/MIT > MIT License
 * @link      https://github.com/takielias
 *
 * CodeIgniter WebSocket library. It allows you to make powerfull realtime applications by using Ratchet Websocket technology
 */

/**
 * Inspired By
 * Ratchet Websocket Library: helper file
 * @author Romain GALLIEN <romaingallien.rg@gmail.com>
 */

class Codeigniter_websocket
{
  /**
	 * CI Super Instance
	 * @var array
	 */
  private $CI;

  /**
	 * Default host var
	 * @var string
	 */
  public $host = null;

  /**
	 * Default host var
	 * @var string
	 */
  public $port = null;

  /**
	 * Default auth var
	 * @var bool
	 */
  public $auth = false;

  /**
	 * Default Timer Interval var
	 * @var bool
	 */
  public $timer_interval = 1;

  /**
	 * Default debug var
	 * @var bool
	 */
  public $debug = false;

  /**
	 * Auth callback informations
	 * @var array
	 */
  public $callback = array();

  /**
	 * Config vars
	 * @var array
	 */
  protected $config = array();

  /**
	 * Define allowed callbacks
	 * @var array
	 */
  protected $callback_type = array('auth', 'event', 'close', 'citimer', 'roomjoin', 'roomleave', 'roomchat');

  /**
	 * Class Constructor
	 * @method __construct
	 * @param array $config Configuration
	 * @return void
	 */
  public function __construct(array $config = array())
  {
    // Load the CI instance
    $this->CI = &get_instance();

    // Load the class helper
    $this->CI->load->helper('codeigniter_websocket');
    $this->CI->load->helper('jwt');
    $this->CI->load->helper('authorization');

    // Define the config vars
    $this->config = (!empty($config)) ? $config : array();

    // Config file verification
    if (empty($this->config)) {
      output('fatal', 'The configuration file does not exist');
    }

    // Assign HOST value to class var
    $this->host = (!empty($this->config['codeigniter_websocket']['host'])) ? $this->config['codeigniter_websocket']['host'] : '';

    // Assign PORT value to class var
    $this->port = (!empty($this->config['codeigniter_websocket']['port'])) ? $this->config['codeigniter_websocket']['port'] : '';

    // Assign AUTH value to class var
    $this->auth = (!empty($this->config['codeigniter_websocket']['auth'] && $this->config['codeigniter_websocket']['auth'])) ? true : false;

    // Assign DEBUG value to class var
    $this->debug = (!empty($this->config['codeigniter_websocket']['debug'] && $this->config['codeigniter_websocket']['debug'])) ? true : false;

    // Assign Timer value to class var
    $this->timer = (!empty($this->config['codeigniter_websocket']['timer_enabled'] && $this->config['codeigniter_websocket']['timer_enabled'])) ? true : false;

    // Assign Timer Interval value to class var
    $this->timer_interval = (!empty($this->config['codeigniter_websocket']['timer_interval'])) ? $this->config['codeigniter_websocket']['timer_interval'] : 1;
  }

  /**
	 * Launch the server
	 * @method run
	 * @return string
	 */
  public function run()
  {
    // Initiliaze all the necessary class
    $server = IoServer::factory(
      new HttpServer(
        new WsServer(
          new Server()
        )
      ),
      $this->port,
      $this->host
    );

    //If you want to use timer
    if ($this->timer != false) {
      $server->loop->addPeriodicTimer($this->timer_interval, function () {
        if (!empty($this->callback['citimer'])) {
          call_user_func_array($this->callback['citimer'], array(date('d-m-Y h:i:s a', time())));
        }
      });

    }

    // Run the socket connection !
    $server->run();
  }

  /**
	 * Define a callback to use auth or event callback
	 * @method set_callback
	 * @param array $callback
	 * @return void
	 */
  public function set_callback($type = null, array $callback = array())
  {
    // Check if we have an authorized callback given
    if (!empty($type) && in_array($type, $this->callback_type)) {

      // Verify if the method does really exists
      if (is_callable($callback)) {

        // Register callback as class var
        $this->callback[$type] = $callback;
      } else {
        output('fatal', 'Method ' . $callback[1] . ' is not defined');
      }
    }
  }
}

/**
 * @package   CodeIgniter WebSocket Library: Server class
 * @category  Libraries
 * @author    Taki Elias <taki.elias@gmail.com>
 * @license   http://opensource.org/licenses/MIT > MIT License
 * @link      https://github.com/takielias
 *
 * CodeIgniter WebSocket library. It allows you to make powerfull realtime applications by using Ratchet Websocket technology
 */
class Server implements MessageComponentInterface
{
  /**
	 * List of connected clients
	 * @var array
	 */
  public $clients;

  /**
	 * List of subscribers (associative array)
	 * @var array
	 */
  protected $subscribers = array();

  /**
	 * Class constructor
	 * @method __construct
	 */
  public function __construct()
  {
    // Load the CI instance
    $this->CI = &get_instance();

    // Initialize object as SplObjectStorage (see PHP doc)
    $this->clients = new SplObjectStorage;

    // // Check if auth is required
    if ($this->CI->codeigniter_websocket->auth && empty($this->CI->codeigniter_websocket->callback['auth'])) {
      output('fatal', 'Authentication callback is required, you must set it before run server, aborting..');
    }

    // Output
    if ($this->CI->codeigniter_websocket->debug) {
      output('success',
        'Running server on host ' . $this->CI->codeigniter_websocket->host . ':' . $this->CI->codeigniter_websocket->port);
    }

    // Output
    if (!empty($this->CI->codeigniter_websocket->callback['auth']) && $this->CI->codeigniter_websocket->debug) {
      output('success', 'Authentication activated');
    }

    // Output
    if (!empty($this->CI->codeigniter_websocket->callback['close']) && $this->CI->codeigniter_websocket->debug) {
      output('success', 'Close activated');
    }

  }

  /**
	 * Event trigerred on new client event connection
	 * @method onOpen
	 * @param ConnectionInterface $connection
	 * @return string
	 */
  public function onOpen(ConnectionInterface $connection)
  {
    // output('debug', var_dump($connection, 1));

    // Add client to global clients object
    $this->clients->attach($connection);

    // Output
    if ($this->CI->codeigniter_websocket->debug) {
      output('info', 'New client connected as (' . $connection->resourceId . ')');
    }
  }

  /**
	 * Event trigerred on new message sent from client
	 * @method onMessage
	 * @param ConnectionInterface $client
	 * @param string $message
	 * @return string
	 */
  public function onMessage(ConnectionInterface $client, $message)
  {
    // Broadcast var
    $broadcast = false;

    // Check if received var is json format
    if (valid_json($message)) {
      // If true, we have to decode it
      $datas = json_decode($message);
      $remate_id = explode("#", $datas->remate_id);
      $remate_id = $remate_id[1];


      // Once we decoded it, we check look for global broadcast
      $broadcast = (!empty($datas->broadcast) and $datas->broadcast == true) ? true : false;

      // Count real clients numbers (-1 for server)
      $clients = count($this->clients) - 1;

      // Here we have to reassign the client ressource ID, this will allow us to send message to specified client.

      if (!empty($datas->type)) {
        switch ($datas->type) {
          case 'socket' :
            if (!empty($this->CI->codeigniter_websocket->callback['auth'])) {

              // Call user personnal callback
              $auth = call_user_func_array($this->CI->codeigniter_websocket->callback['auth'],
                array($datas));

              // Verify authentication

              if (empty($auth) or !is_integer($auth)) {
                output('error', 'Client (' . $client->resourceId . ') authentication failure');
                $client->send(json_encode(array("type" => "error", "msg" => 'Invalid ID or Password.')));
                // Closing client connexion with error code "CLOSE_ABNORMAL"
                $client->close(1006);
                return;
              }

              // Add UID to associative array of subscribers
              $client->subscriber_id = $auth;
              $this->subscribers[$client->subscriber_id] = $client;
              output('info', "Elemento nuevo en suscribers() " . var_export($client->subscriber_id, 1));

              if ($this->CI->codeigniter_websocket->auth) {
                $data = json_encode(array("type" => "token", "token" => AUTHORIZATION::generateToken($client->resourceId)));
                $this->send_message($client, $data, $client);
              }

              // Output
              if ($this->CI->codeigniter_websocket->debug) {
                output('success', 'Client (' . $client->resourceId . ') authentication success');
                output('success', 'Token : ' . AUTHORIZATION::generateToken($client->resourceId));
              }
            }
            break;


          case 'roomjoin':
            if (isset($datas->token) && (valid_jwt($datas->token) != false)) {
          
              if (!empty($this->CI->codeigniter_websocket->callback['roomjoin'])) {

                // Call user personnal callback
                $resultado = call_user_func_array($this->CI->codeigniter_websocket->callback['roomjoin'],
                  array($datas, $client));
                if (!$resultado) return;
              }



              $usuario_existia_en_chat = $this->CI->v2chat_model->get(array("user_id" => $datas->user_id));
              $usuario = $this->CI->v2usuarios_model->get(array("id" => $datas->user_id)); /* Esteban: 26/12/20 | 15:45:03  El usuario que se está incorporando al room  */

              $nombres = explode(" ", $usuario->first_name);
              $nombre_usuario = substr($usuario->last_name . ", " . $nombres[0], 0, 15);
              $message = json_encode(array("type" => "joined_room", "usuario" => $nombre_usuario, "user_id" => $usuario->id) );
                  
              /* Esteban: 26/12/20 | 15:16:59  Distribuimos el mensaje de join room

                El del admin se broadcastea a todos y el de un user se manda solo a los admines presentes en el room

              */

              /* Esteban: 26/12/20 | 16:25:37 Si el usuario no existia en el chat, lo agrego a la db */
              if (!$usuario_existia_en_chat) {
                $perfil = $this->CI->v2usuarios_empresas_model->get(array("user_id" => $datas->user_id, "empresa_id" => $datas->empresa_id));

                output('info', "Lo anotamos en db a " . $usuario->email . " con perfil de " . $perfil->perfil_id . " en " . $datas->empresa_id);

                $this->CI->v2chat_model->insert(array(
                                    "user_id" => $datas->user_id, 
                                    "martillero" => ($perfil->perfil_id != 2 ? 1:0),
                                    "remate_id" => $remate_id, 
                                    "join_timestamp" => date('Y-m-d H:i:s'),
                                    ));
              } else {
                output('info', var_export($usuario_existia_en_chat, 1));
              }


              $usuarios_en_el_chat = $this->CI->v2chat_model->get_all_in_chat($remate_id, false); /* Traigo a los chateantes que no sean admin */
              if($usuarios_en_el_chat) {
                $usuarios_en_el_chat_array = array_column($usuarios_en_el_chat, "user_id");
              } else {
                $usuarios_en_el_chat_array = array();
              }

              output('info', "Usuarios en el chat: " . var_export($usuarios_en_el_chat_array, 1) . "\r\n");
              $admines_en_el_chat = $this->CI->v2chat_model->get_all_in_chat($remate_id, true); /* Traigo a los chateantes que sean admin */
              if($admines_en_el_chat) {
                $admines_en_el_chat = array_column($admines_en_el_chat, "user_id");
              } else {
                $admines_en_el_chat = array();
              }

              output('info', "Admines en el chat: " . var_export($admines_en_el_chat, 1));
              if($datas->rematador == 1) {
                /* Esteban: 26/12/20 | 15:23:49  Si el que se está uniendo al room es un rematador */
                foreach($this->clients as $user) {
                  if ((in_array($user->subscriber_id, $usuarios_en_el_chat_array)) && ($user->subscriber_id != $datas->user_id)) {
                    /* Esteban: 26/12/20 | 15:48:31 Le mando el mensaje a TODOS los que estén en el chat */
                    if (!$usuario_existia_en_chat) {
                      $user->send($message);
                      // Output
                      if ($this->CI->codeigniter_websocket->debug) {
                        output('info', 'Sent \'' . $message . '\' to (' . $user->resourceId . ')');
                      }
                    }
                  }
                }
          
                /* Esteban: 26/12/20 | 17:06:18  Como es ADMIN el que se está uniendo al chat, le paso la lista de todos los usuarios que están logueados actualmente */
                if (is_array($usuarios_en_el_chat)){
                  output('info', "usuarios_en_el_chat: " . var_export($usuarios_en_el_chat, 1));
                  foreach ($usuarios_en_el_chat as $usuario_c) {
                    if ($usuario_c->user_id != $datas->user_id) {
                      output('info', "USER_ID" . $usuario_c->user_id);
                      $usuario = $this->CI->v2usuarios_model->get(array("id" => $usuario_c->user_id));
                      $nombres = explode(" ", $usuario->first_name);
                      $nombre_usuario = substr($usuario->last_name . ", " . $nombres[0], 0, 15);
                      $message = json_encode(array("type" => "joined_room", "usuario" => $nombre_usuario, "user_id" => $usuario->id) );
                      $this->subscribers[$datas->user_id]->send($message); // Le mando un mensaje al admin que se está incorporando al chat, con todos los usuarios que están en el room
                    }
                  }
                }
              } else { /* Esteban: 26/12/20 | 15:49:08   Si el que se está uniendo NO ES REMATADOR (o sea, es un usuario común */
                if (!$usuario_existia_en_chat) {
                  foreach($this->clients as $user) {
                    if (in_array($user->subscriber_id, $admines_en_el_chat) && ($user->subscriber_id != $datas->user_id)) {
                      /* Esteban: 26/12/20 | 15:48:31 Le mando el mensaje solo a los ADMIN que estén en el chat */
                      $user->send($message);
                      // Output
                      if ($this->CI->codeigniter_websocket->debug) {
                        output('info', 'Sent \'' . $message . '\' to (' . $user->resourceId . ')');
                      }
                    }
                  }
                }
              }
            } else {

              $client->send(json_encode(array("type" => "error", "msg" => 'Invalid Token.')));
            }
            break;
          case 'roomleave':
            if (valid_jwt($datas->token) != false) {

              if (!empty($this->CI->codeigniter_websocket->callback['roomleave'])) {

                // Call user personnal callback
                call_user_func_array($this->CI->codeigniter_websocket->callback['roomleave'],
                  array($datas, $client));

              }


            } else {

              $client->send(json_encode(array("type" => "error", "msg" => 'Invalid Token.')));
            }

            break;


           case 'roomchat':

            if (valid_jwt($datas->token) != false) {

              if (!empty($this->CI->codeigniter_websocket->callback['roomchat'])) {

                // Call user personnal callback
                call_user_func_array($this->CI->codeigniter_websocket->callback['roomchat'],
                  array($datas, $client));

              }


            } else {

              $client->send(json_encode(array("type" => "error", "msg" => 'Invalid Token.')));
            }
            break;

      // Now this is the management of messages destinations, at this moment, 4 possibilities :
      // 1 - Message is not an array OR message has no destination (broadcast to everybody except us)
      // 2 - Message is an array and have destination (broadcast to single user)
      // 3 - Message is an array and don't have specified destination (broadcast to everybody except us)
      // 4 - Message is an array and we wan't to broadcast to ourselves too (broadcast to everybody)

          case 'chat':

            $pass = true;

            if ($this->CI->codeigniter_websocket->auth) {

              if (!valid_jwt($datas->token)) {
                output('error', 'Client (' . $client->resourceId . ') authentication failure. Invalid Token');
                $client->send(json_encode(array("type" => "error", "msg" => 'Invalid Token.')));
                // Closing client connexion with error code "CLOSE_ABNORMAL"
                $client->close(1006);
                $pass = false;
              }
            }

            if ($pass) {
              if (!empty($message)) {
                $remate_id = explode("#", $datas->remate_id);
                $remate_id = $remate_id[1];
                $usuarios_chat = $this->CI->v2chat_model->get_all(array("remate_id" => $remate_id));
                if($usuarios_chat) {
                  $usuarios_chat = array_column($usuarios_chat, 'user_id');
                  $admines = $this->CI->v2usuarios_empresas_model->get_admines_en_chat($datas->empresa_id, implode(",", $usuarios_chat));
                  if($admines) {
                    $admines = array_column($admines, 'user_id');

                    // We look arround all clients
                    foreach ($this->clients as $user) {

                      // Broadcast to single user 
                      /* Esteban: 22/12/20 | 13:32:09 En remates, el único que puede hacer un broadcast es el admin. */
                      if (!empty($datas->recipient_id)) {
                        if ($user->subscriber_id == $datas->recipient_id) {
                          $this->CI->v2chat_mensajes_model->insert(array(
                            "remate_id" => $datas->remate_id,
                            "user_id_to" => $user->subscriber_id,
                            "user_id_from" => $client->subscriber_id,
                            "mensaje" => $datas->message
                          ));
                          $this->send_message($user, $message, $client);
                          break;
                        }
                      } else {
                        if (in_array($user->subscriber_id, $admines)) {
                          $this->CI->v2chat_mensajes_model->insert(array(
                            "remate_id" => $datas->remate_id,
                            "user_id_to" => $user->subscriber_id,
                            "user_id_from" => $client->subscriber_id,
                            "mensaje" => $datas->message
                          ));
                          $this->send_message($user, $message, $client);
                          break;
                        }
                      }
                    }
                  }
                }
              }
            }
            break;

          case 'incremento':
            output('info', "Incremento: " . var_export($datas->message));
            $remate_id = explode("#", $datas->remate_id);
            $remate_id = $remate_id[1];
            $usuarios_en_el_chat = $this->CI->v2chat_model->get_all_in_chat($remate_id, false); /* Traigo a los chateantes que no sean admin */
            if ($usuarios_en_el_chat) {
              $usuarios_en_el_chat_array = array_column($usuarios_en_el_chat, "user_id");
            } else {
              output('error', 'Sala vacía');
            }

            $this->CI->v2chat_mensajes_model->insert(array(
              "remate_id" => $datas->remate_id,
              "user_id_from" => $client->subscriber_id,
              "accion" => "incremento: " . $datas->message
            ));
            foreach ($usuarios_en_el_chat_array as $usuario) {
              output('info', "Enviado a : " . var_export($usuario));
              $this->send_message($this->subscribers[$usuario], $message, $client);
            }
            break;
        }
      }

    } else {
      output('error', 'Client (' . $client->resourceId . ') Invalid json.');
      // Closing client connexion with error code "CLOSE_ABNORMAL"
      $client->close(1006);
    }

  }

  /**
	 * Event triggered when connection is closed (or user disconnected)
	 * @method onClose
	 * @param ConnectionInterface $connection
	 * @return string
	 */
  public function onClose(ConnectionInterface $connection)
  {
    // Output
    if ($this->CI->codeigniter_websocket->debug) {
      output('info', 'Client (' . $connection->resourceId . ') disconnected');
    }


    if (!empty($this->CI->codeigniter_websocket->callback['close'])) {
      call_user_func_array($this->CI->codeigniter_websocket->callback['close'], array($connection));
    }


    $message = json_encode(array("type" => "disconnect", "user_id" => $connection->subscriber_id) );
          
    /* Esteban: 26/12/20 | 15:16:59  Distribuimos el mensaje de join room

      El del admin se broadcastea a todos y el de un user se manda solo a los admines presentes en el room

    */


    $usuario = $this->CI->v2chat_model->get(array("user_id" => $connection->subscriber_id));
    $remate_id = $usuario->remate_id;
 
    output('info', "Borramos de la db a " . $usuario->user_id);
    $this->CI->v2chat_model->delete(array("user_id" => $connection->subscriber_id));

    
    $usuarios_en_el_chat = $this->CI->v2chat_model->get_all_in_chat($remate_id, false); /* Traigo a los chateantes que no sean admin */
    if ($usuarios_en_el_chat) {
      $usuarios_en_el_chat_array = array_column($usuarios_en_el_chat, "user_id");
    } else {
      $usuarios_en_el_chat_array = array();
    }

    output('info', "Usuarios en el chat: " . var_export($usuarios_en_el_chat_array, 1) . "\r\n");
    $admines_en_el_chat = $this->CI->v2chat_model->get_all_in_chat($remate_id, true); /* Traigo a los chateantes que sean admin */
    if ($admines_en_el_chat) {
      $admines_en_el_chat = array_column($admines_en_el_chat, "user_id");
    } else {
      $admines_en_el_chat = array();
    }

    output('info', "Admines en el chat: " . var_export($admines_en_el_chat, 1));
    if($usuario->martillero == 1) {
      /* Esteban: 26/12/20 | 15:23:49  Si el que se está uniendo al room es un rematador */
      foreach($this->clients as $user) {
        if ((in_array($user->subscriber_id, $usuarios_en_el_chat_array)) && ($user->subscriber_id != $usuario->user_id)) {
          /* Esteban: 26/12/20 | 15:48:31 Le mando el mensaje a TODOS los que estén en el chat */
          $user->send($message);
          // Output
          if ($this->CI->codeigniter_websocket->debug) {
            output('info', 'Sent \'' . $message . '\' to (' . $user->resourceId . ')');
          }
        }
      }
    } else { /* Esteban: 26/12/20 | 15:49:08   Si el que se está uniendo NO ES REMATADOR (o sea, es un usuario común */
      foreach($this->clients as $user) {
        if (in_array($user->subscriber_id, $admines_en_el_chat) && ($user->subscriber_id != $usuario->user_id)) {
          /* Esteban: 26/12/20 | 15:48:31 Le mando el mensaje solo a los ADMIN que estén en el chat */
          $user->send($message);
          // Output
          if ($this->CI->codeigniter_websocket->debug) {
            output('info', 'Sent \'' . $message . '\' to (' . $user->resourceId . ')');
          }
        }
      }
    }

    // Detach client from SplObjectStorage
    $this->subscribers[$connection->subscriber_id] = null;
    $this->clients->detach($connection);
  }

  /**
	 * Event trigerred when error occured
	 * @method onError
	 * @param ConnectionInterface $connection
	 * @param Exception $e
	 * @return string
	 */
  public function onError(ConnectionInterface $connection, \Exception $e)
  {
    // Output
    if ($this->CI->codeigniter_websocket->debug) {
      output('fatal', 'An error has occurred: ' . $e->getMessage());
    }

    // We close this connection
    $connection->close();
  }

  /**
	 * Function to send the message
	 * @method send_message
	 * @param array $user User to send
	 * @param array $message Message
	 * @param array $client Sender
	 * @return string
	 */
  protected function send_message($user = array(), $message = array(), $client = array())
  {
    // Send the message
    $user->send($message);

    // We have to check if event callback must be called
    if (!empty($this->CI->codeigniter_websocket->callback['event'])) {

      // At this moment we have to check if we have authent callback defined
      call_user_func_array($this->CI->codeigniter_websocket->callback['event'],
        array((valid_json($message) ? json_decode($message) : $message)));

      // Output
      if ($this->CI->codeigniter_websocket->debug) {
        output('info', 'Callback event "' . $this->CI->codeigniter_websocket->callback['event'][1] . '" called');
      }
    }

    // Output
    if ($this->CI->codeigniter_websocket->debug) {
      output('info',
        'Client (' . $client->resourceId . ') send \'' . $message . '\' to (' . $user->resourceId . ')');
    }
  }

}
