<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
use OpenTok\OpenTok;
use OpenTok\MediaMode;
use OpenTok\ArchiveMode;

class Comprador extends Comprador_Controller {

    function __construct() {
        global $config;
        parent::__construct();
        $this->load->helper('url', 'form');
        $this->load->helper('remates');
        $this->load->library('form_validation');

        $this->load->model('v2empresa_model');
        $this->load->model('v2permisos_model');
        $this->load->model('v2opciones_model');
        $this->load->model('v2usuarios_model');
        $this->load->model('v2media_lotes_model');
        $this->load->model('v2lotes_model');
        $this->load->model('v2remates_model');
        $this->load->model('v2creditos_model');

        /* Title Page */

        // $this->page_title->push("Comprador");
        // $this->data['pagetitle'] = $this->page_title->show();
        }


    public function index() {
      if (!$this->v2permisos_model->verificar_permiso('comprador', $this->session->userdata('user_id'))) {
        die('El usuario no tiene permisos');
      } else {
        $this->template->comprador_render('comprador/comprador/index', $this->data);
      }
    }


    public function traer_lote() {
      $user_id = $this->input->post('user_id');
      $lote_id = $this->input->post('lote_id');
      $lote = $this->v2lotes_model->with_moneda()->get(['idlotes' => $lote_id]);
      $respuesta['lote_finalizado'] = $lote->status_id == 3;
      $respuesta['lote_titulo'] = isset($lote->titulo) ? $lote->titulo : "Lote #" . $lote->idlotes;
      $respuesta['lote_descripcion'] = isset($lote->descripcion) ? $lote->descripcion : "";
      $respuesta['lote_base'] = $lote->moneda->simbolo . " " . ($lote->base ? $lote->base : '--');
      $respuesta['lote_incremento'] = $lote->step;
      $respuesta['lote_moneda_simbolo'] = $lote->moneda->simbolo;
      $respuesta['valor_actual'] = isset($lote->oferta_maxima) ? $lote->oferta_maxima : $lote->base;
      $respuesta['oferta_maxima_actual'] = $lote->oferta_maxima_actual;
      $ancho = $this->config->item('FOTOS_LOTES_ANCHO');
      $alto = $this->config->item('FOTOS_LOTES_ALTO');
      $media_lote = $this->v2media_lotes_model->order_by('orden')->get_all(array('lote_id' => $lote_id));
      // $html = $this->load->view('/comprador/comprador/media_gallery', $this->data, true);

      if( isset($media_lote) && is_array($media_lote) && count($media_lote) > 0) {
        $html_arr = Array();
        foreach ($media_lote as $media){
          $html = "";
          if ($media->tipo == 'imagen') {
            $html = "
              <div class='image-wrapper slide-image'>
                <img src='" . $media->ruta . "'>
              </div>";
          }

          if ($media->tipo == 'video') {
            $html = "<div class='video-wrapper'>";
            
              $media_id = $media->media_id;
              $media_id = explode('#', $media_id);
              $video_id = $media_id[1];
           
            $html .="<iframe class='embed-player' src='https://player.vimeo.com/video/" . $video_id . "?api=1&byline=0&portrait=0&title=0&height=304&background=1&mute=1&loop=0&autoplay=0&id=" . $video_id . "' height='" . $alto . "' frameborder='0' allow='autoplay; fullscreen' frameborder='0' webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>
            </div>";
          }
     
          if (!empty($html)) {
            $html_arr[] = $html;
          }
        }
      }
      
      $respuesta['media_gallery'] = json_encode($html_arr, JSON_HEX_QUOT | JSON_HEX_TAG);
      if ($user_id == $lote->oferente_id) {
        $respuesta['ganador'] = true;
      } else {
        $respuesta['ganador'] = false;        
      }
      die(json_encode($respuesta));
    }


    public function pedir_video() {
      $remate_id = explode("#", $this->input->post("remate_id"));
      $remate_id = $remate_id[1];

      $opentok = new OpenTok($this->config->item('vonage_api_key'), $this->config->item('vonage_api_secret'));
      $remate = $this->v2remates_model->get(['idremates' => $remate_id]);
      $respuesta['video_iniciado'] = false;
      if (isset($remate->vonage_sessionId)) {
        try{
          $respuesta['vonage_token'] = $opentok->generateToken($remate->vonage_sessionId);
          $respuesta['video_iniciado'] = true;
          $respuesta['vonage_apiKey'] = $this->config->item('vonage_api_key');
          $respuesta['vonage_sessionId'] = $remate->vonage_sessionId;
        } catch(Exception $e){
          $respuesta['error'] = $e->getMessage();
          // $this->v2remates_model->where(['idremates' => $remate_id])->update(['vonage_sessionId' => NULL]);
        }
      }

      die(json_encode($respuesta));
    }

    public function status_remate() {
      $remates_en_curso = $this->v2remates_model->get_en_curso_o_proximo($_SESSION['empresa_id']);
      if (!$remates_en_curso) {
        $respuesta['remate_id'] = 0;
        $respuesta['remate_comenzado'] = false;
      } else {
        $respuesta['remate_id'] = $remates_en_curso[0]->idremates;    
        $remate_en_curso = $remates_en_curso[0];
        $respuesta['remate_comenzado'] = (isset($remate_en_curso->fecha_hora_inicio) &&  ($remate_en_curso->fecha_hora_inicio > 0));
        if ($respuesta['remate_comenzado'] == false) {
          $this->data['remate_programado'] = $remate_en_curso;
          $this->data['remate_programado']->fecha_hora_inicio_programado = date_create_from_format('Y-m-d H:i:s', $this->data['remate_programado']->fecha_hora_inicio_programado)->format('d/m/Y H:i:s');
          $this->data['lotes_remate_programado'] = $this->v2lotes_model->where(['remate_id' => $this->data['remate_programado']->idremates ])->get_all();
          $respuesta['datos_remate'] = $this->load->view('/comprador/comprador/datos_remate', $this->data, true);
        }
      }


      die(json_encode($respuesta));
    }

    public function chequear_credito() {
      $user_id = $_POST['user_id'];
      $respuesta['credito'] = $this->v2creditos_model->get_saldo($user_id, $_SESSION['empresa_id']);
      die(json_encode($respuesta));
    }

    public function detalles_cliente() {
      $user_id = $this->input->post('user_id');
      $remate_id = $this->input->post('remate_id');
      $remate_id = explode('#', $remate_id)[1];
      $user_historial = $this->v2lotes_model->where(['oferente_id' => $user_id, 'remate_id' => $remate_id])->get_all();
      $this->data['user_saldo'] = $this->v2creditos_model->get_saldo($user_id, $_SESSION['empresa_id']);
      $this->data['user_historial'] = $user_historial;

      $html = $this->load->view('comprador/comprador/detalles_cliente', $this->data, true);
      $respuesta = array("error" => false, "html" => $html);
      die(json_encode($respuesta));
    }



}

?>