<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Chat extends MY_Controller
{

    function __construct() {
        // Load package path
        global $config;
        parent::__construct();
        $this->load->library('Chat_library');
        $this->load->model('v2usuarios_model');
        $this->load->model('v2usuarios_empresas_model');
        $this->load->model('v2lotes_model');
        $this->load->model('v2remates_model');
        $this->load->model('v2chat_model');
        $this->load->model('v2chat_mensajes_model');
        }


    public function index()
    {
        // Run server
        $this->chat_library->set_callback('auth', array($this, '_auth'));
        $this->chat_library->set_callback('event', array($this, '_event'));
        $this->chat_library->set_callback('roomjoin', array($this, '_roomjoin'));
        $this->chat_library->auth = true;
        $this->chat_library->run();
    }


    public function _auth($datas = null)
    {
        // Here you can verify everything you want to perform user login.
        return (!empty($datas->user_id)) ? (int)$datas->user_id : false;
    }

    public function _event($message = null)
    {
        // Here you can verify everything you want to perform user login.
        fwrite(STDOUT, "Mensaje: " . var_export($message, true) . "\r\n");
        return (!empty($datas->user_id)) ? (int)$datas->user_id : false;
    }

    public function _roomjoin($datas = null, $client = null)
    {

      if (!isset($datas->user_id)) {
        output('error', 'user_id vacío');
        $client->send(json_encode(array("type" => "error", "msg" => 'user_id vacío')));
        // Closing client connexion with error code "CLOSE_ABNORMAL"
        $client->close(1006);
        return false;
      } 

      if (!isset($datas->remate_id)) {
        output('error', 'remate_id vacío');
        $client->send(json_encode(array("type" => "error", "msg" => 'remate_id vacío')));
        // Closing client connexion with error code "CLOSE_ABNORMAL"
        $client->close(1006);
        return false;
      }
      
      return true;
    }
}


/* Esteban: 21/12/20 | 19:08:47 
 http://www.inanzzz.com/index.php/post/axh1/monitoring-a-php-process-example-with-supervisor
 http://www.inanzzz.com/index.php/post/axh1/monitoring-a-php-process-example-with-supervisor
 http://www.inanzzz.com/index.php/post/axh1/monitoring-a-php-process-example-with-supervisor
 http://www.inanzzz.com/index.php/post/axh1/monitoring-a-php-process-example-with-supervisor
 http://www.inanzzz.com/index.php/post/axh1/monitoring-a-php-process-example-with-supervisor
*/