<?php if (!defined('BASEPATH')) {
		exit('No direct script access allowed');
}

/**
 * Acá en esta lib tengo funciones que se aplican como hooks en la Ion Auth.
Si agrego otras formas de autenticación del usuario, las puedo agregar como funciones acá y como hooks en /controllers/Auth.php
 */

require_once APPPATH . 'libraries/phpass-0.5/PasswordHash.php';
class Auth_hooks
{
		private $ci;

		/**
		 * __construct
		 *
		 * @return void
		 **/
		public function __construct()
		{
				$this->ci = &get_instance();

				$this->ci->load->model('v2usuarios_model');
				$this->ci->load->model('v2grupos_model');
				$this->ci->load->model('v2permisos_model');

		}

		public function set_session_extra()
		{
				$user_id = $this->ci->session->userdata('user_id');
				$usuario = $this->ci->v2usuarios_model->with_empresas()->get($user_id);
				$data['empresas'] = array();
				if (isset($usuario->empresas)) {
					foreach ($usuario->empresas as $empresa) {
						$data['empresas'][] = $empresa->idempresas;
					}
				}

				$data["usuario_nombre"]   = $usuario->first_name;
				$data["usuario_apellido"] = $usuario->last_name;
				// $data["usuario_foto"]     = $usuario->foto;

				$this->ci->session->set_userdata($data);
				return;
		}

}
