<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class V2empresa_model extends MY_Model
{


  public $table = "empresas";
  public $primary_key = "idempresas";


  public function __construct(){
    $this->has_one['dominio_root'] = array('foreign_model' => 'v2dominios_model', 'foreign_key' => 'iddominios', 'local_key' => 'dominio_root_id');


    parent::__construct();
  }

  public function get($where = null) {
    $res = parent::get($where);
    foreach(array('foto_header', 'foto_portada', 'foto_superior') as $campo) {
      $partes = pathinfo($res->{$campo});
      if (!isset($partes['dirname']) || ($partes['dirname'] == '.')) {
        $res->{$campo} = $this->config->item('path_imagenes_empresa') . $res->{$campo};
      }
    }

    return $res;
  }


  /*
  * Busca una empresa por el dominio que le paso como parámetro ($url).
  * Para eso, primero descompone el dominio para saber cuál es el dominio raíz y cuál el subdominio, y después la busca por ese subdominio.
  * Suena más fácil de lo que es. En realidad, el split del dominio debe hacerse contra la tabla de dominios y de atrás para adelante, porque las variantes son muchas para solo separar por el '.'
  * Por ejemplo, podría ser sarasa.turnocheck.com, o sarasa.turnocheck.com.ar, o sarasa.turnocheck.ar o www.sarasa.turnocheck.com.ar, etc
  */
  public function get_x_dominio($url) {
    $partes = $this->v2dominios_model->split_dominio($url);

    $this->_database->where('empresas.dominio', $partes['subdominio']); // Puede ser blanco
    $this->_database->where('dominios.dominio', $partes['dominio']);
    $this->_database->join('dominios', 'dominios.iddominios = empresas.dominio_root_id', 'INNER');
    $query = $this->_database->get('empresas');

    if ($this->_database->error()['code'] !==0) {
      turnup_log_error($this->_database->error()['message'] . '   QUERY: ' .$this->_database->last_query(), __FILE__, __FUNCTION__);
      return false;
    } else {
      $res = $query->result();
      if (is_array($res) && count($res) > 0) {
        return $res[0];
      } else {
        return false;
      }
    }
  }



  public function get_dominio($empresa_id) {
    
    $this->_database->select('empresas.dominio AS subdominio, dominios.dominio as dominio');
    $this->_database->where('empresas.idempresas', $empresa_id);
    $this->_database->join('dominios', 'dominios.iddominios = empresas.dominio_root_id', 'INNER');
    $query = $this->_database->get('empresas');

    if ($this->_database->error()['code'] !==0) {
      turnup_log_error($this->_database->error()['message'] . '   QUERY: ' .$this->_database->last_query(), __FILE__, __FUNCTION__);
      return false;
    } else {
      $res = $query->result();
      return $res[0]->subdominio . '.' . $res[0]->dominio;
    }
  }
}