<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class V2opciones_model extends MY_Model
{


	public $table = "opciones";
	public $primary_key = "idopciones";

	public function __construct(){
		parent::__construct();
	}

	/*
	* Te devuelve el valor de una opción que le pasás como parámetro ($opcion_nommbre), seǵun lo que tenga seteado la empresa que también le pasás como parámetro.
	* Si la empresa no tiene seteado nada, te trae el valor por defaul de la opción de la tabla opciones (gracias al coalesce que se ve ahí en el query)
	*/

    function get_valor_opcion($opcion_nombre, $empresa_id)
        {
        $query_str = 'SELECT 
                      COALESCE(e.valor, o.valor, \'\') AS valor';
        
        $query_str .= ' FROM opciones AS o';
        $query_str .= ' LEFT JOIN empresas_opciones AS e ON (e.opcion_id = o.idopciones AND e.empresa_id ' . (isset($empresa_id) ? " = " . $empresa_id : 'IS NULL') . ") ";
        $query_str .= ' WHERE nombre = \'' . strtolower($opcion_nombre) . '\' ';
            
        $query = $this->_database->query($query_str);
        if ($this->_database->error()['code'] !==0) {
            log_message('error', $this->_database->error()['message'] . '   QUERY: ' .$this->_database->last_query() . "\r\n" . __FILE__ . ' - ' . __FUNCTION__);
            return false;
        }
        
        if ($query->num_rows() != 1)
            return false;
                
        $res = $query->row();
        return $res->valor;
        }

    function get_all($where = NULL) {
    	$res = parent::get_all($where);
    	if( isset($res) && is_array($res) && count($res) > 0) {
    		foreach($res as &$registro){
    			$registro->valores = unserialize($registro->valores);
    		}
    	}
			
			return $res;    			
    }


		function get_opcion_html_mostrar($tipo_id, $valor, $rw = false, $valores = null, $id, $clase = null) {
			switch($tipo_id) {
				case TIPO_VALOR_CHECKBOX: {
					if ($rw) {
						$input_campo = '<input class="opcion ' . ((isset($clase) && $clase != "") ? $clase : '') . ' form-control" type="checkbox" id="opcion_' . $id . '" data-opcion-id="' . $id . '" ' . ($valor == 1 ? 'checked="checked"' : '') . ' data-toggle="toggle" data-on="Si" data-off="No" />';
					} else {
						return ($valor ? "SI" : "NO" );
					}
					break;
				}
				case TIPO_VALOR_DROPDOWN:{
					if ($rw) {
						$input_campo = '<select class="form-control select2 opcion ' . ((isset($clase) && $clase != "") ? $clase : '') . '" id="opcion_' . $id . '" data-opcion-id="' . $id . '" >';
						foreach($valores as $opcion_id => $opcion){
							$input_campo .= '<option value="' . $opcion_id . '" ' . ($opcion_id == $valor ? 'selected' : '') . ' >' . $opcion . '</option>';
						}
						$input_campo .= '</select>';
					} else {
						return $valores[$valor];
					}
					break;
				}
				case TIPO_VALOR_TEXTO:
				case TIPO_VALOR_NUMERO:
				case TIPO_VALOR_DATE: {
					if ($rw) {
						$input_campo = '<input class="form-control opcion ' . ((isset($clase) && $clase != "") ? $clase : '') . '" type="text" id="opcion_' . $id . '" data-opcion-id="' . $id . '" value="' . $valor . '"/>';
					} else {
						return $valor;
					}
					break;
				}

				case TIPO_VALOR_TEXTAREA: {
					if ($rw) {
						$input_campo = '<textarea class="form-control opcion ' . ((isset($clase) && $clase != "") ? $clase : '') . '" id="opcion_' . $id . '" data-opcion-id="' . $id . '" cols="90" rows="6" >' . $valor . '</textarea>';
					} else {
						return $valor;
					}
					break;
				}
			}
			return $input_campo;
		}



}