<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class V2Perfiles_model extends MY_Model
{


	public $table = "perfiles";
	public $primary_key = "idperfiles";

	public function __construct(){
		$this->has_one['rol'] = array('foreign_model' => 'v2roles_model', 'foreign_key' => 'idroles', 'local_key' => 'rol_id');
    $this->has_one['pantalla_inicio'] = array('foreign_model' => 'v2pantallas_inicio_model', 'foreign_key' => 'idpantallas_inicio', 'local_key' => 'pantalla_inicio_id');
		parent::__construct();
	}

    public function traer_paginados($registros_pagina, $pagina, $orden, $where, $campos) {
    $this->_database->from('perfiles');
    $this->_database->join('roles', 'perfiles.rol_id = roles.idroles', "INNER");
    $this->_database->group_by('idperfiles');
    $this->_database->select('perfiles.idperfiles');
    $registros = $this->_database->count_all_results();
    $total_rows = $registros;

    
    $this->_database->from('perfiles');
    if( isset($where) && !empty($where)) {
      $this->_database->having($where);
    }
    $this->_database->join('roles', 'perfiles.rol_id = roles.idroles', "INNER");
    $this->_database->group_by('idperfiles');
    $this->_database->select($campos);
    $registros = $this->_database->count_all_results();
    $filtered_rows = $registros;

    $this->_database->limit($registros_pagina, (($pagina-1) * $registros_pagina));
    if( isset($orden) && is_array($orden) && count($orden) > 0) {
      foreach($orden as $o){
        $this->_database->order_by(key($o), $o[key($o)]);
      }
    }
    if( isset($where) && !empty($where)) {
      $this->_database->having($where);
    }
    $this->_database->join('roles', 'perfiles.rol_id = roles.idroles', "INNER");
    $this->_database->select($campos);
    $this->_database->group_by('idperfiles');
    $result = $this->_database->get('perfiles')->result_array();
    if($result) {
      return array(
          'filtered_rows' => $filtered_rows,
          'total_rows' => $total_rows,
          'result'     => $result,
      ); // Return this back to the controller.
    } else {
        return FALSE;
    }
  }
}