<?php if (!defined('BASEPATH')) {
		exit('No direct script access allowed');
}

class V2Usuarios_model extends MY_Model
{

		public $table       = "users";
		public $primary_key = "id";

		public function __construct()
		{
				$this->load->model('v2empresa_model');
				$this->load->model('v2grupos_model');

				$this->has_many_pivot['empresas'] = array(
						'foreign_model'     => 'v2empresa_model',
						'foreign_table'     => 'empresas',
						'foreign_key'       => 'idempresas',
						'pivot_table'       => 'usuarios_empresas',
						'local_key'         => 'id',
						'pivot_local_key'   => 'user_id',
						'pivot_foreign_key' => 'empresa_id',
						'get_relate'        => false,
				);
				parent::__construct();
		}

		public function cargar_permisos($user_id, $empresa_id = null)
		{
				if(!isset($empresa_id)) { /* Esteban: 25/04/18 | 11:39:14  para el superadmin */
					$empresa_id = -1;
				}

				$perfil       = $this->v2usuarios_empresas_model->with_perfil()->get(array('user_id' => $user_id, 'empresa_id' => $empresa_id));
				if (!isset($perfil) || $perfil === false) { /* Esteban: 20/03/18 | 16:02:33  Puede pasar si el usuario todavía no está inscripto en la empresa pero existe en TurnoCheck */
					return false;
				}
				$cp = $this->session->userdata('cache_permisos');
        if (!isset($cp)) {
        	if(strtolower($perfil->perfil->nombre) == 'superadmin') { /* Esteban: 25/03/18 | 15:21:31  Es superadmin? Cargo TODOS los permisos */
						$this->session->set_userdata('cache_permisos', "SUPERADMIN");
						return true;
        	} else {
						$permisos     = $this->v2permisos_model->with_item_sistema()->get_all(array('perfil_id' => $perfil->perfil_id));
					}

					$permisos_arr = array();

					if (!isset($permisos) || empty($permisos)) { /* Esteban: 20/03/18 | 16:02:33  Puede pasar si el usuario todavía no está inscripto en la empresa pero existe en TurnoCheck */
              /* Esteban: 13/11/20 | 15:21:56  También pasa si las tablas de clases de items del sistema y de items del sistema están vacías */
						return false;
					}
					
					foreach ($permisos as $permiso) {
            if(isset($permiso->item_sistema) && $permiso->item_sistema) {
						  $permisos_arr[] = strtolower($permiso->item_sistema->nombre);
            }
					}
					$this->session->set_userdata('cache_permisos', $permisos_arr);
        	
        }

				return true;
		}







		 function procesar_upload_foto($archivo) {
			if (NULL !== $this->session->userdata('foto_foto')) {
				@unlink( BASEPATH . '../' . $this->session->userdata('foto_foto'));
				$this->session->unset_userdata('foto_foto');
				$this->session->unset_userdata('nombre_foto');
			}

			$extension = pathinfo($archivo['name'], PATHINFO_EXTENSION);
			$archivo_nuevo = BASEPATH . '../assets/images/usuarios' . "/" . hash('sha512', rand(0, 1000000) . date(FORMATO_FECHA_HORA_TURNOCHECK) . 'foto') . "." . $extension;
			if (!move_uploaded_file($archivo['tmp_name'], $archivo_nuevo)) {
				return FALSE;
			}

			$config['image_library']    = 'gd2';
			$config['source_image']     = $archivo_nuevo;
			$config['width']            = $this->config->item('FOTO_USUARIO_ANCHO');
			$config['height']           = $this->config->item('FOTO_USUARIO_ALTO');
			$config['maintain_ratio']   = FALSE;

			$this->load->library('image_lib', $config);

			if (!$this->image_lib->resize()) {
				return FALSE;
			}

			$filename_archivo_nuevo = pathinfo($archivo_nuevo, PATHINFO_FILENAME);
			$url_archivo_nuevo = '/assets/images/usuarios/' . $filename_archivo_nuevo . '.' . $extension;
			return $url_archivo_nuevo;
		}

    public function get_x_rol($rol) {
      $this->_database->join('usuarios_empresas', 'usuarios_empresas.user_id = users.id AND usuarios_empresas.empresa_id = ' . $_SESSION['empresa_id'] , 'INNER');
      $this->_database->join('perfiles', 'perfiles.idperfiles = usuarios_empresas.perfil_id', 'INNER');
      $this->_database->join('roles', 'perfiles.rol_id = roles.idroles', 'INNER');
      $this->_database->where('roles.nombre', $rol);
      return $this->get_all();
    }


    public function traer_paginados($registros_pagina, $pagina, $orden, $where) {
    
    $this->_database->from('users');
    $this->_database->start_cache();
    $this->_database->join('usuarios_empresas', 'usuarios_empresas.user_id = users.id AND usuarios_empresas.empresa_id = ' . $_SESSION['empresa_id'], 'INNER');
    $this->_database->join('perfiles', 'usuarios_empresas.perfil_id = perfiles.idperfiles AND perfiles.nombre != "superadmin"', 'INNER');
    $this->_database->join('roles', 'perfiles.rol_id = roles.idroles', 'INNER');

    $total_rows = $this->_database->count_all_results();



    if( isset($where) && !empty($where)) {
      $this->_database->where($where);
    }
    
    $this->_database->from('users');
    $filtered_rows = $this->_database->count_all_results();

    $this->_database->stop_cache();

    $this->_database->limit($registros_pagina, (($pagina-1) * $registros_pagina));

    if( isset($orden) && is_array($orden) && count($orden) > 0) {
      foreach($orden as $o){
        $this->_database->order_by(key($o), $o[key($o)]);
      }
    }

    $result = $this->get_all();
    $this->firebug->log('$this->_database->last_query() ---> ' . var_export($this->_database->last_query(), true));
    $this->_database->flush_cache();
    // die($this->_database->last_query());
    
    if($result) {
      return array(
          'filtered_rows' => $filtered_rows,
          'total_rows' => $total_rows,
          'result'     => $result,
      ); // Return this back to the controller.
    } else {
        return FALSE;
    }
  }





    public function traer_creditos_paginados($empresa_id, $user_id, $registros_pagina, $pagina, $where, $orden, $cache_para_contar = false) {
    $this->table = "creditos";

    $this->_database->from($this->table);
    $this->_database->join('users', 'creditos.cargado_por = users.id', 'INNER');
    $this->_database->where('creditos.user_id', $user_id);
    $this->_database->where('creditos.empresa_id', $empresa_id);

    $total_rows = $this->_database->count_all_results();
    $this->firebug->log('$this->_database->last_query() ---> ' . var_export($this->_database->last_query(), true));


    if( isset($where) && !empty($where)) {
      $this->_database->having($where);
    }
    $this->_database->from($this->table);
    $this->_database->join('users', 'creditos.cargado_por = users.id', 'INNER');
    $this->_database->where('creditos.user_id', $user_id);
    $this->_database->where('creditos.empresa_id', $empresa_id);

    $filtered_rows = $this->_database->count_all_results();



    $this->_database->limit($registros_pagina, (($pagina-1) * $registros_pagina));

    $this->_database->join('users', 'creditos.cargado_por = users.id', 'INNER');
    $this->_database->where('creditos.user_id', $user_id);
    $this->_database->where('creditos.empresa_id', $empresa_id);
    if( isset($where) && !empty($where)) {
      $this->_database->having($where);
    }

    if( isset($orden) && is_array($orden) && count($orden) > 0) {
      foreach($orden as $o){
        $this->_database->order_by(key($o), $o[key($o)]);
      }
    }


    $result = $this->get_all();
    
    if($result) {
      return array(
          'filtered_rows' => $filtered_rows,
          'total_rows' => $total_rows,
          'result'     => $result,
      ); // Return this back to the controller.
    } else {
        return FALSE;
    }
  }





}
