<?php
defined('BASEPATH') OR exit('No direct script access allowed');

?>
<header class="main-header">
    <!-- Logo -->
    <a href="https://rematexremate.com.ar" target="_blank" class="logo hidden-xs hidden-sm">
      <!-- mini logo for sidebar mini 50x50 pixels -->
      <span class="logo-mini"><b>Rx</b>R</span>
      <!-- logo for regular state and mobile devices -->
      <span class="logo-lg"><img class="responsive" src="<?php echo base_url('assets/images/logo-rematexremate.png'); ?>" style="height: 45px; margin: 0 auto;" /> </span>
    </a>

    <!-- Header Navbar: style can be found in header.less -->
    <nav class="navbar navbar-static-top">
      <!-- Sidebar toggle button-->
      <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
        <span class="sr-only">Navegación</span>
      </a>
      <!-- Navbar Right Menu -->
      <div class="navbar-custom-menu">
        <ul class="nav navbar-nav">
          <?php if (isset($empresas) && is_array($empresas)): ?>                
          <li class="dropdown empresas-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown" aria-expanded="true">
              <span class="hidden-xs">
                <?php if (isset($empresa)): ?>
                  <?php echo $empresa->nombre; ?>
                <?php endif ?>
              </span>
              <span class="hidden-sm hidden-md hidden-lg hidden-xl">
                <?php if (isset($empresa)): ?>
                  <strong><?php echo strtoupper(substr($empresa->nombre, 0, 1)); ?></strong><?php echo strtolower(substr($empresa->nombre, 1, 1)); ?>
                <?php endif ?>
              </span>
            </a>
            <?php if (is_array($empresas) && count($empresas) > 1): ?>
              
            <ul class="dropdown-menu">
              <li class="header text-center">
                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#nueva_empresa">
                  Nueva empresa
                </button>
              </li>
              <li class="header">Seleccione la Empresa</li>
              <li style="overflow: auto; height: 400px;">
                <!-- inner menu: contains the actual data -->
                <ul class="menu">
                  <?php foreach ($empresas as $emp): ?>                   
                  <li data-empresa_id="<?php echo $emp->idempresas; ?>">
                    <a href="#">
                      <?php echo $emp->nombre; ?>
                    </a>
                  </li>
                  <?php endforeach ?>
                </ul>
              </li>
            </ul>
            <?php endif ?>
          </li>
          <?php endif ?>


          <!-- Notifications: style can be found in dropdown.less -->
          <li class="dropdown notifications-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
              <i class="fa fa-bell-o"></i>
              <!-- <span class="label label-warning">10</span> -->
            </a>
<?php /*
            <ul class="dropdown-menu">
              <li class="header">You have 10 notifications</li>
              <li>
                <!-- inner menu: contains the actual data -->
                <ul class="menu">
                  <li>
                    <a href="#">
                      <i class="fa fa-users text-aqua"></i> 5 new members joined today
                    </a>
                  </li>
                  <li>
                    <a href="#">
                      <i class="fa fa-warning text-yellow"></i> Very long description here that may not fit into the
                      page and may cause design problems
                    </a>
                  </li>
                  <li>
                    <a href="#">
                      <i class="fa fa-users text-red"></i> 5 new members joined
                    </a>
                  </li>
                  <li>
                    <a href="#">
                      <i class="fa fa-shopping-cart text-green"></i> 25 sales made
                    </a>
                  </li>
                  <li>
                    <a href="#">
                      <i class="fa fa-user text-red"></i> You changed your username
                    </a>
                  </li>
                </ul>
              </li>
              <li class="footer"><a href="#">View all</a></li>
            </ul>
*/ ?>

          </li>
          <!-- User Account: style can be found in dropdown.less -->
          <li class="user user-menu">
            <a href="#" >
              <?php if (isset($admin->foto)): ?>
              <img src="<?php echo $admin->foto; ?>" class="user-image" alt="Avatar">
              <?php endif ?>
              <span class="hidden-xs"><?php echo $admin->last_name . ', ' . $admin->first_name; ?></span>
            </a>
          </li>
          <li class="user user-menu">
            <a href="/auth/logout">
              <span class="fa fa-power-off navbar-icon" aria-hidden="true"></span>
            </a>
          </li>
        </ul>
      </div>
      <input type="hidden" id="logged_user_id" value="<?php echo $admin->id; ?>">
    </nav>
  </header>

<?php if ($es_superadmin): ?>
  
  <!-- Modal -->
  <div class="modal fade" id="nueva_empresa" tabindex="-1" role="dialog" aria-labelledby="lbl_nueva_empresa">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal" aria-label="Cancelar"><span aria-hidden="true">&times;</span></button>
          <h4 class="modal-title" id="lbl_nueva_empresa">Nueva empresa</h4>
        </div>
        <div class="modal-body">
          <form action="#" method="post" autocomplete="off" novalidate accept-charset="utf-8">
            <div class="row">
              <div class="col-xs-3">
                <label>Nombre</label>
              </div>
              <div class="col-xs-9">
                <input type="text" name="nueva_empresa_nombre" id="nueva_empresa_nombre" class="form-control" />
              </div>
            </div>
          </form>
        </div>
        <div class="modal-footer">
          <div class="bootstrap-dialog-footer">
            <div class="bootstrap-dialog-footer-buttons">
              <button type="button" data-dismiss="modal" class="btn pull-left">Cancelar</button>
              <button type="btn-primary" id="agregar_empresa_nueva" class="btn btn-grabar btn-success pull-right">Confirmar</button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
<?php endif ?>