var form_validator;

function grabar_empresa(){	
  if($("#frm_datos").valid()) {
			var opciones = new Array();
			var opciones_backend = new Array();
			$("#frm_datos").find('.btn-grabar span').show();
			$.each($("#frm_datos .opcion"), function (i, e) {
				var opcion = new Object();
				opcion.id = $(e).data('opcion-id');
				switch($(e).prop('type')) {
					case 'checkbox':
						opcion.valor = $(e).prop('checked') ? 1 : 0;
						break;
					default:
						opcion.valor = $(e).val();
						break;
				}
				opciones.push(opcion);
			});

			$.each($("#frm_datos .opciones_backend:checked"), function (i, e) {
				opciones_backend.push($(e).data('opcion-id'));
			});

			var datos = new Object();
			datos = {
				nombre: $("#nombre").val(),
				url: $("#url").val(),
				nombre_portada: $("#nombre_portada").val(),
				nombre_header: $("#nombre_header").val(),
				archivo_portada: $("#archivo_portada").val(),
				archivo_header: $("#archivo_header").val(),
				dominio: $("#dominio").val(),
				dominio_root: $("#dominio_root").val(),
				opciones: opciones,
				opciones_backend: opciones_backend
			}

    $.ajax( {
      url: '/empresa/grabar_empresa',
      data: {
        empresa_id: $("#empresa_id").val(),
        datos: datos,
      },
      dataType: 'json',
      type: 'POST',
      success: function (respuesta) {
        if (respuesta.error == false) {
          if( typeof(respuesta.redirect) != "undefined" ) {
            window.location.assign(respuesta.redirect);
          } else {
            toastr.success(respuesta.mensaje);
          }
        } else {
          toastr.error(respuesta.mensaje);
        }
      }
    });
  } else {
    form_validator.focusInvalid();
  }
  return false;
}




jQuery(document).ready(function($){

	$(".foto_upload").each(function() {
		var input_file = this;
		var barra_progreso = $(input_file).parent(".file-input-wrapper").find(".foto_progress");
		var mensaje_error = $(input_file).parent(".file-input-wrapper").find(".file-input-error");
		var imagen = $(input_file).parents(".foto_upload_container").find(".imagen_foto_upload");
		var archivo = $(input_file).parents(".foto_upload_container").find(".archivo");
		var nombre = $(input_file).parents(".foto_upload_container").find(".nombre");

		$(input_file).fileupload( {
			dataType: 'json',
			cache: false,
			url: '/empresa/upload_foto',
			fail: function (e, data) {
					$(input_file).attr('title', '');
					$(barra_progreso).hide(400);
					$(mensaje_error).html("<p>" + data.errorThrown + "</p>");
			},
			done: function (e, data) {
				if (data.result.rta.error !== undefined) {
					$(input_file).attr('title', '');
					$(barra_progreso).hide(400);
					$(imagen).attr('src', data.result.foto_default);
					$(mensaje_error).html("<p>" + data.result.rta.error + "</p>");
				} else {
					$(input_file).attr('title', data.result.rta.name);
					$(imagen).attr('src', data.result.rta.url + '?dt=' + (+new Date()));
					$(nombre).val(data.result.nombre);
					$(archivo).val(data.result.archivo);
					$(barra_progreso).hide(400);
				}
			},
			send: function(e, data) {
				$(mensaje_error).html("");
				$(barra_progreso).show();
			},
			progressall: function(e, data) {
				var progress = parseInt(data.loaded / data.total * 100, 10);
				$(input_file).parent(".file-input-wrapper").find('.progress_foto .files_progress_bar').css('width', progress + '%');
			}
		});
	});


	$(".imagen_foto_upload").on('click', function(e) {
		$(this).parents(".foto_upload_container").find(".foto_upload").trigger('click');
	});




  form_validator = $("#frm_datos").validate({

    errorPlacement: function(label, element) {
      label.addClass('error_form');
      label.insertAfter(element);
    },
    focusInvalid: true,

    rules: {
      nombre: {required : true},
      dominio: {required : true},
    }
  });

  $(".btn-cancelar").on('click', function() {
    window.location.assign('/empresa');
  });

});