var medidor;
var upload;
var global_previousUploads;

var slot_video= "<li class='list-group-item' style='background-color: #e3fbe3;'> \
              <div class='row row-eq-height'> \
                <div class='col-xs-2' style='padding:0; display: flex;justify-content: center;'> \
                  <canvas width='80' height='80' id='canvas_medidor'></canvas> \
                  <div id='texto_medidor' style='position:absolute; top:35%;'>0%</div> \
                </div> \
                <div class='col-xs-8'> \
                  <p id='status_medidor'> \
                  </p> \
                </div> \
                <div class='col-xs-1'> \
                  <p style='text-align: center;'> \
                    <i class='fa fa-pause media_upload_control media_upload_pausa' title='Pausar'></i> \
                  </p> \
                </div> \
                <div class='col-xs-1'> \
                  <p style='text-align: center;'> \
                    <i class='fa fa-stop media_upload_control media_upload_cancelar' title='Cancelar'></i> \
                  </p> \
                </div> \
              </div> \
            </li>";


var opts = {
  angle: 0.5, // The span of the gauge arc
  lineWidth: 0.1, // The line thickness
  radiusScale: 1, // Relative radius
  pointer: {
    length: 0.6, // // Relative to gauge radius
    strokeWidth: 0.035, // The thickness
    color: '#000000' // Fill color
  },
  limitMax: false,     // If false, max value increases automatically if value > maxValue
  limitMin: false,     // If true, the min value of the gauge will be fixed
  colorStart: '#6F6EA0',   // Colors
  colorStop: '#8FC0DA',    // just experiment with them
  strokeColor: '#E0E0E0',  // to see which ones work best for you
  generateGradient: true,
  highDpiSupport: true,     // High resolution support
  
};

var throb = Throbber({
    color: 'blue',
    padding: 10,
    size: 20,
    fade: 200,
    clockwise: false
    });



function format_size(bytes) {
  if (typeof bytes !== 'number') {
      return '';
  }
  if (bytes >= 1000000000) {
      return (bytes / 1000000000).toFixed(2) + ' GB';
  }
  if (bytes >= 1000000) {
      return (bytes / 1000000).toFixed(2) + ' MB';
  }
  return (bytes / 1000).toFixed(2) + ' KB';
}



function render_percent(gauge) {
   percentage = gauge.displayedValue / gauge.maxValue
   this.el.innerHTML = (percentage * 100).toFixed(0) + "%"  
}

jQuery(document).ready(function($){

  $(document).on('click', '.btn_eliminar_media', function () {
    $.ajax( {
      url: '/lotes/eliminar_media',
      type: "post",
      data: {
        media_id: $(this).parents('li.list-group-item').data('media_id'),
        lote_id: $("#lote_id").val()
      },
      success: function(respuesta) {
        $("#galeria_multimedia").html($.parseJSON(respuesta));
        $("#galeria_container").show();
        init_sortable();
        $('#sortable_list').sortable().disableSelection();
      }
    });
  });


  $(document).on('click', "#btn_nuevo, .editar_lote", function() {
    var lote_id;
    if ($(this).hasClass("editar_lote")) {
      lote_id = $(this).parents("tr").data("lote_id");
    } else {
      lote_id = null
    }
    $.ajax( {
      url: '/lotes/editar_lote',
      type: "post",
      data: {
        lote_id: lote_id
      },
      dataType: 'json',
      success: function ( json ) {
        if (json.error) {
          $("#lote_crud .modal-body").html( json.mensaje );
        } else {
          $("#lote_crud .modal-body").html( json.html );
          $("#lote_crud .modal-body").find("input[type='checkbox']").bootstrapToggle();
        
          form_validator = $("#frm_datos").validate({
              errorPlacement: function(label, element) {
                label.addClass('error_form');
                label.insertAfter(element);
              },
              focusInvalid: true,

              rules: {
                nombre: {required : true},
              },
            });


        }
        $("#lote_crud").modal('show');
        setup_file_upload();

        if (lote_id > 0) {
          $.post( "/lotes/refresh_galeria", 
            {lote_id : lote_id},
            function (data) {
              $("#galeria_multimedia").html($.parseJSON(data));
              $("#galeria_container").show();
              init_sortable();
              $('#sortable_list').sortable().disableSelection();
            });
        } else {
          $("#galeria_container").hide();
        }
      }
    });   
  });

});


function setup_file_upload () {

  $('#galeria_lotes_upload').fileupload({
    url: 'lotes/upload_imagen',
    dataType: 'json',
    autoUpload: false,
    disableImageResize: true
  })
  .on('fileuploadadd', function (e, data) {
    console.log("fileuploadadd");
    throb.appendTo( document.getElementById( 'lbl_galeria' ) );
    throb.start();

    var file_cliente = data.files[0];
    if( data.files[0].type == 'image/png' ||
      data.files[0].type == 'image/gif' ||
      data.files[0].type == 'image/jpg' ||
      data.files[0].type == 'image/jpeg' ||
      data.files[0].type == 'image/png') {
      data.submit();

    } else {
      console.log("Vimeo");
      upload = new tus.Upload(file_cliente, {
        endpoint: "/lotes/upload_vimeo",
        retryDelays: [0, 1000, 2000, 3000, 4000],
        parallelUploads: 1, /* Esteban: 16/12/20 | 10:25:14  If you want to use it, please evaluate it under real world situations to see if it actually improves your upload performance. In common browser session, we were not able to find a performance improve for the average user */
        removeFingerprintOnSuccess: false,
        storeFingerprintForResuming: true,
        onError: function(error) {
          $("#status_medidor").text("Transferencia fallida: " + error);
          /* Esteban: 16/12/20 | 10:37:31  acá tendría que ir un alerta o algo, y borrarse el "medidor" */
        },
        // Callback for reporting upload progress
        onProgress: function(bytesUploaded, bytesTotal) {
            var percentage = (bytesUploaded / bytesTotal * 100).toFixed(0);
            console.log("percentage", percentage);
            medidor.set(percentage);
            $("#status_medidor").text("Transfiriendo a Vimeo...");
        },
        onAfterResponse: function (req, res) {
          if (req._xhr.status == 200 && req._method == 'POST' && req._url == "/lotes/upload_vimeo") {
            throb.stop();
            respuesta = JSON.parse(res._xhr.response);
            $("#galeria_multimedia ul").prepend(slot_video);
            var canvas_medidor = document.getElementById("canvas_medidor");
            medidor = new Donut(canvas_medidor).setOptions(opts);
            medidor.maxValue = 100;
            medidor.setMinValue(0);
            medidor.animationSpeed = 70;
            medidor.set(0);
            var textRenderer = new TextRenderer(document.getElementById("texto_medidor"));
            textRenderer.render = render_percent;
            medidor.setTextField(textRenderer);
            upload.options.metadata = {
                ruta : respuesta.ruta
              };
            $("#status_medidor").text("Iniciando transferencia...");
          }
        },

        onSuccess: function() {
          $("#status_medidor").text("Codificando... ");
          upload.options.urlStorage.findUploadsByFingerprint(upload._fingerprint).then(function(stored_items) {
          item = stored_items[0];
          console.log("llamamos ahí");
            $.ajax({
              url: "/lotes/insert_media_sin_procesar",
              method: "POST",
              dataType: "json",
              data:{
                lote_id: $("#lote_id").val(),
                nombre: item.metadata.nombre ? item.metadata.nombre : '',
                tamanio : item.size,
                ruta: item.metadata.ruta,
              },
              success: function(respuesta) {
                upload.options.urlStorage.removeUpload(item.urlStorageKey).then(function() {
                  $("#galeria_multimedia").html(respuesta.html);
                  $("#galeria_container").show();
                  init_sortable();
                  $('#sortable_list').sortable().disableSelection();
          
                  connectToService(respuesta.video_id);

                });
              }
            });
          });
        },
        // _onUploadUrlAvailable: function(data) {
        //   console.log("_onUploadUrlAvailable data: ", data );
        // }
      });

      // $(document).on("click", ".media_upload_pausa", function(){
      //   $btn_pausa = $(this);
      //   upload.abort().then(function() {
      //     $btn_pausa.removeClass("fa-pause").addClass("fa-play");
      //     $btn_pausa.removeClass("media_upload_pausa").addClass("media_upload_reanudar");
      //   });
      // });

      // $(document).on("click", ".media_upload_reanudar", function(){
      //   $btn_pausa = $(this);
      //   console.log($btn_pausa.data('video_id'));
      //   $btn_pausa.removeClass("fa-pause").addClass("fa-play");
      //   $btn_pausa.removeClass("media_upload_pausa").addClass("media_upload_reanudar");
      // });


      // upload.findPreviousUploads().then((previousUploads) => {
          // previousUploads is an array containing details about the previously started uploads.
          // The objects in the array have following properties:
          // - size: The upload's size in bytes
          // - metadata: The metadata associated with the upload during its creation
          // - creationTime: The timestamp when the upload was created
          // We ask the end user if they want to resume one of those uploads or start a new one.


          // var chosenUpload = askToResumeUpload(previousUploads);

          // If an upload has been chosen to be resumed, instruct the upload object to do so.
          // if(chosenUpload) {
          //     upload.resumeFromPreviousUpload(chosenUpload);
          // }

          // Finally start the upload requests.
          // upload.start();
      // });
      // upload.findPreviousUploads().then((previousUploads) => {
      //   if (previousUploads.length > 0) {
      //     upload.resumeFromPreviousUpload(previousUploads[0])
      //   }
      //   console.log("Upload Start()");
      //   upload.start()
      // });

      upload.findPreviousUploads().then((previousUploads) => {
          // previousUploads is an array containing details about the previously started uploads.
          // The objects in the array have following properties:
          // - size: The upload's size in bytes
          // - metadata: The metadata associated with the upload during its creation
          // - creationTime: The timestamp when the upload was created

          // We ask the end user if they want to resume one of those uploads or start a new one.
          global_previousUploads = previousUploads;
          askToResumeUpload();

          // If an upload has been chosen to be resumed, instruct the upload object to do so.
          // if(chosenUpload) {
              // upload.resumeFromPreviousUpload(chosenUpload);
          // }

          // Finally start the upload requests.
          // upload.start();
      });

      // upload.start();
    }
  })
  .on('fileuploaddone', function (e, data) {
      throb.stop();
      if (data.result.error !== undefined) {
        alert(data.result.error);
      } else {
        console.log("fileuploaddone");
        $("#galeria_multimedia").html(data.result.html);
        init_sortable();
        $('#sortable_list').sortable().disableSelection();
      }
    });



  $('#galeria_lotes_upload').bind('fileuploadsubmit', function (e, data) {
    data.formData = {lote_id: $('#lote_id').val()};
  });


};




// Open a dialog box to the user where they can select whether they want to resume an upload
// or instead create a new one.
function askToResumeUpload() {
  if (global_previousUploads.length === 0) {
    ignorar_transferencias();
    return;
  }


  global_previousUploads.forEach((previousUpload, index) => {
    var transferencia = " <div class='row'> \
                            <div class='col-xs-12 text-center'> \
                              <button type='primary' onclick='reanudar_transferencia(global_previousUploads[" + index + "])'>" + moment(new Date(previousUpload.creationTime)).format("DD/MM/YYYY HH:mm") + "</button> \
                            </div>\
                          </div>";
    $("#upload_resume #transferencias").append(transferencia);
  });
  $("#upload_resume").modal('show');
}
  
function reanudar_transferencia(previousUpload) {
  $("#upload_resume").modal('hide');
  throb.stop();
  $("#galeria_multimedia ul").prepend(slot_video);
  var canvas_medidor = document.getElementById("canvas_medidor");
  medidor = new Donut(canvas_medidor).setOptions(opts);
  medidor.maxValue = 100;
  medidor.setMinValue(0);
  medidor.animationSpeed = 70;
  medidor.set(0);
  var textRenderer = new TextRenderer(document.getElementById("texto_medidor"));
  textRenderer.render = render_percent;
  medidor.setTextField(textRenderer);
  $("#status_medidor").text("Iniciando transferencia...");
  upload.resumeFromPreviousUpload(previousUpload);
  upload.start();
}

function ignorar_transferencias() {
  console.log("ignorar_transferencias");
  upload.start();
}
  // if (!isNaN(index) && previousUploads[index]) {
  //   return previousUploads[index];
  // }